/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.common.base.Objects;
import org.apache.shindig.social.opensocial.spi.DomainName;
import org.apache.shindig.social.opensocial.spi.LocalId;

public class GlobalId {
    private DomainName domainName;
    private LocalId localId;

    public GlobalId(String globalId) throws IllegalArgumentException {
        try {
            String[] gid = globalId.split(":");
            if (gid.length != 2) {
                throw new IllegalArgumentException("The provided GlobalId is not valid");
            }
            this.domainName = new DomainName(gid[0]);
            this.localId = new LocalId(gid[1]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The provided GlobalId is not valid");
        }
    }

    public GlobalId(DomainName domainName, LocalId localId) {
        this.domainName = domainName;
        this.localId = localId;
    }

    public GlobalId(String domainName, String localId) throws IllegalArgumentException {
        this.domainName = new DomainName(domainName);
        this.localId = new LocalId(localId);
    }

    public DomainName getDomainName() {
        return this.domainName;
    }

    public void setDomainName(DomainName domainName) {
        this.domainName = domainName;
    }

    public void setDomainName(String domainName) throws IllegalArgumentException {
        this.domainName = new DomainName(domainName);
    }

    public LocalId getLocalId() {
        return this.localId;
    }

    public void setLocalId(LocalId localId) {
        this.localId = localId;
    }

    public void setLocalId(String localId) {
        this.localId = new LocalId(localId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalId)) {
            return false;
        }
        GlobalId actual = (GlobalId)o;
        return this.getDomainName().equals(actual.getDomainName()) && this.getLocalId().equals(actual.getLocalId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainName, this.localId});
    }

    public String toString() {
        return this.domainName + ":" + this.localId.toString();
    }
}

