/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import com.google.common.base.Objects;
import java.util.regex.Pattern;

public class LocalId {
    private String localId;
    private static final Pattern localIdPattern = Pattern.compile("[\\w.-]*");

    public LocalId(String localId) throws IllegalArgumentException {
        if (localId != null) {
            this.setLocalId(localId);
        } else {
            this.setLocalId("");
        }
    }

    private boolean validate(String localId) {
        return localIdPattern.matcher(localId).matches();
    }

    public String getLocalId() {
        return this.localId;
    }

    public boolean setLocalId(String localId) throws IllegalArgumentException {
        if (this.validate(localId)) {
            this.localId = localId;
            return true;
        }
        throw new IllegalArgumentException("The provided LocalId is not valid");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalId)) {
            return false;
        }
        LocalId actual = (LocalId)o;
        return this.getLocalId().equals(actual.getLocalId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.localId});
    }

    public String toString() {
        return this.localId;
    }
}

