/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.mail.impl;

import java.io.InputStream;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.mail.impl.ExoAuthenticator;

public class MailServiceImpl
implements MailService {
    static final String MAX_THREAD_NUMBER = "mail.max.thread.number";
    private Session mailSession_;
    private Properties props_ = new Properties(PrivilegedSystemHelper.getProperties());
    private ExecutorService executorService;
    private volatile int mailServiceThreadCounter = 0;

    public MailServiceImpl(InitParams params, final ExoContainerContext ctx) throws Exception {
        this.props_.putAll((Map<?, ?>)params.getPropertiesParam("config").getProperties());
        if ("true".equals(this.props_.getProperty("mail.smtp.auth"))) {
            String username = this.props_.getProperty("mail.smtp.auth.username");
            String password = this.props_.getProperty("mail.smtp.auth.password");
            final ExoAuthenticator auth = new ExoAuthenticator(username, password);
            this.mailSession_ = (Session)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Session>(){

                @Override
                public Session run() {
                    return Session.getInstance((Properties)MailServiceImpl.this.props_, (Authenticator)auth);
                }
            });
        } else {
            this.mailSession_ = (Session)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Session>(){

                @Override
                public Session run() {
                    return Session.getInstance((Properties)MailServiceImpl.this.props_, null);
                }
            });
        }
        int threadNumber = this.props_.getProperty(MAX_THREAD_NUMBER) != null ? Integer.valueOf(this.props_.getProperty(MAX_THREAD_NUMBER)).intValue() : Runtime.getRuntime().availableProcessors();
        this.executorService = Executors.newFixedThreadPool(threadNumber, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                return new Thread(arg0, ctx.getName() + "-MailServiceThread-" + MailServiceImpl.this.mailServiceThreadCounter++);
            }
        });
    }

    @Override
    public Session getMailSession() {
        return this.mailSession_;
    }

    @Override
    public String getOutgoingMailServer() {
        return this.props_.getProperty("mail.smtp.host");
    }

    @Override
    public void sendMessage(String from, String to, String subject, String body) throws Exception {
        Message message = new Message();
        message.setFrom(from);
        message.setTo(to);
        message.setSubject(subject);
        message.setBody(body);
        this.sendMessage(message);
    }

    @Override
    public void sendMessage(Message message) throws Exception {
        int i;
        MimeMessage mimeMessage = new MimeMessage(this.getMailSession());
        String FROM = message.getFrom();
        String TO = message.getTo();
        String CC = message.getCC();
        String BCC = message.getBCC();
        String subject = message.getSubject();
        String mimeType = message.getMimeType();
        String body = message.getBody();
        String replyTo = message.getReplyTo();
        List<Attachment> attachment = message.getAttachment();
        if (FROM != null && !FROM.equals("")) {
            InternetAddress sentFrom = new InternetAddress(FROM);
            if (sentFrom.getPersonal() != null) {
                sentFrom.setPersonal(sentFrom.getPersonal(), "UTF-8");
            }
            mimeMessage.setFrom((Address)sentFrom);
        }
        InternetAddress[] sendTo = new InternetAddress[this.getArrs(TO).length];
        for (int i2 = 0; i2 < this.getArrs(TO).length; ++i2) {
            sendTo[i2] = new InternetAddress(this.getArrs(TO)[i2]);
            if (sendTo[i2].getPersonal() == null) continue;
            sendTo[i2].setPersonal(sendTo[i2].getPersonal(), "UTF-8");
        }
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])sendTo);
        if (this.getArrs(CC) != null && this.getArrs(CC).length > 0) {
            InternetAddress[] copyTo = new InternetAddress[this.getArrs(CC).length];
            for (i = 0; i < this.getArrs(CC).length; ++i) {
                copyTo[i] = new InternetAddress(this.getArrs(CC)[i]);
                if (copyTo[i].getPersonal() == null) continue;
                copyTo[i].setPersonal(copyTo[i].getPersonal(), "UTF-8");
            }
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])copyTo);
        }
        if (this.getArrs(BCC) != null && this.getArrs(BCC).length > 0) {
            InternetAddress[] bccTo = new InternetAddress[this.getArrs(BCC).length];
            for (i = 0; i < this.getArrs(BCC).length; ++i) {
                bccTo[i] = new InternetAddress(this.getArrs(BCC)[i]);
                if (bccTo[i].getPersonal() == null) continue;
                bccTo[i].setPersonal(bccTo[i].getPersonal(), "UTF-8");
            }
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bccTo);
        }
        if (this.getArrs(replyTo) != null && this.getArrs(replyTo).length > 0) {
            InternetAddress[] replyToArray = new InternetAddress[this.getArrs(replyTo).length];
            for (i = 0; i < this.getArrs(replyTo).length; ++i) {
                replyToArray[i] = new InternetAddress(this.getArrs(replyTo)[i]);
                if (replyToArray[i].getPersonal() == null) continue;
                replyToArray[i].setPersonal(replyToArray[i].getPersonal(), "UTF-8");
            }
            mimeMessage.setReplyTo((Address[])replyToArray);
        }
        mimeMessage.setSubject(subject);
        mimeMessage.setSubject(message.getSubject(), "UTF-8");
        mimeMessage.setSentDate(new Date());
        MimeMultipart multipPartRoot = new MimeMultipart("mixed");
        MimeMultipart multipPartContent = new MimeMultipart("alternative");
        if (attachment != null && attachment.size() != 0) {
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            if (mimeType != null && mimeType.indexOf("text/plain") > -1) {
                contentPartRoot.setContent((Object)body, "text/plain; charset=utf-8");
            } else {
                contentPartRoot.setContent((Object)body, "text/html; charset=utf-8");
            }
            MimeBodyPart mimeBodyPart1 = new MimeBodyPart();
            mimeBodyPart1.setContent((Object)body, mimeType);
            multipPartContent.addBodyPart((BodyPart)mimeBodyPart1);
            multipPartRoot.addBodyPart((BodyPart)contentPartRoot);
            for (Attachment att : attachment) {
                InputStream is = att.getInputStream();
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(is, att.getMimeType());
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
                mimeBodyPart.setDisposition("attachment");
                if (att.getName() != null) {
                    mimeBodyPart.setFileName(MimeUtility.encodeText((String)att.getName(), (String)"utf-8", null));
                }
                multipPartRoot.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimeMessage.setContent((Multipart)multipPartRoot);
        } else if (mimeType != null && mimeType.indexOf("text/plain") > -1) {
            mimeMessage.setContent((Object)body, "text/plain; charset=utf-8");
        } else {
            mimeMessage.setContent((Object)body, "text/html; charset=utf-8");
        }
        this.sendMessage(mimeMessage);
    }

    @Override
    public void sendMessage(MimeMessage message) throws Exception {
        Transport.send((javax.mail.Message)message);
    }

    @Override
    public Future<Boolean> sendMessageInFuture(final String from, final String to, final String subject, final String body) {
        return this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                MailServiceImpl.this.sendMessage(from, to, subject, body);
                return true;
            }
        });
    }

    @Override
    public Future<Boolean> sendMessageInFuture(final Message message) {
        return this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                MailServiceImpl.this.sendMessage(message);
                return true;
            }
        });
    }

    @Override
    public Future<Boolean> sendMessageInFuture(final MimeMessage message) {
        return this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                MailServiceImpl.this.sendMessage(message);
                return true;
            }
        });
    }

    protected String[] getArrs(String toArray) {
        if (toArray != null && !toArray.equals("")) {
            return toArray.split(",");
        }
        return null;
    }
}

