/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreImportService;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreService;

public class ExternalStoreUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(ExternalStoreUpgradePlugin.class);
    private IDMExternalStoreImportService externalStoreImportService;
    private IDMExternalStoreService externalStoreService;

    public ExternalStoreUpgradePlugin(IDMExternalStoreImportService externalStoreImportService, IDMExternalStoreService externalStoreService, InitParams initParams) {
        super(initParams);
        this.externalStoreImportService = externalStoreImportService;
        this.externalStoreService = externalStoreService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            this.externalStoreImportService.importAllModifiedEntitiesToQueue();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while migrating IDM entities", e);
        }
    }

    public boolean isEnabled() {
        if (!this.externalStoreService.isEnabled()) {
            LOG.info((Object)"ExternalStoreService is disabled, no migration is required.");
            return false;
        }
        return super.isEnabled();
    }
}

