/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class FavoriteServiceImpl
implements FavoriteService {
    private static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    private static final String EXO_FAVORITEFOLDER = "exo:favoriteFolder";
    private static final String NT_UNSTRUCTURED = "nt:unstructured";
    private static final String FAVORITE_ALIAS = "userPrivateFavorites";
    private NodeHierarchyCreator nodeHierarchyCreator;
    private LinkManager linkManager;
    private SessionProviderService sessionProviderService;
    private OrganizationService organizationService;

    public FavoriteServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, LinkManager linkManager, SessionProviderService sessionProviderService, OrganizationService organizationService) {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.linkManager = linkManager;
        this.sessionProviderService = sessionProviderService;
        this.organizationService = organizationService;
    }

    @Override
    public void addFavorite(Node node, String userName) throws Exception {
        if (this.linkManager.isLink((Item)node)) {
            return;
        }
        Node userFavoriteNode = null;
        try {
            userFavoriteNode = this.getUserFavoriteFolder(userName);
            if (userFavoriteNode == null) {
                return;
            }
        }
        catch (PathNotFoundException e) {
            userFavoriteNode = this.createFavoriteFolder(userName);
        }
        NodeIterator nodeIter = userFavoriteNode.getNodes();
        while (nodeIter.hasNext()) {
            Node targetNode;
            Node childNode = nodeIter.nextNode();
            if (!this.linkManager.isLink((Item)childNode) || !node.isSame((Item)(targetNode = this.getTargetNode(childNode)))) continue;
            return;
        }
        this.linkManager.createLink(userFavoriteNode, "exo:symlink", node, node.getName() + ".lnk");
        userFavoriteNode.getSession().save();
    }

    @Override
    public List<Node> getAllFavoriteNodesByUser(String workspace, String repository, String userName) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        Node userFavoriteNode = this.getUserFavoriteFolder(userName);
        if (userFavoriteNode != null) {
            NodeIterator nodeIter = userFavoriteNode.getNodes();
            while (nodeIter.hasNext()) {
                Node targetNode;
                Node childNode = nodeIter.nextNode();
                if (!this.linkManager.isLink((Item)childNode) || (targetNode = this.getTargetNode(childNode)) == null) continue;
                ret.add(targetNode);
            }
        }
        return ret;
    }

    @Override
    public void removeFavorite(Node node, String userName) throws Exception {
        Node targetNode = null;
        if (this.linkManager.isLink((Item)node)) {
            targetNode = this.getTargetNode(node);
            if (targetNode != null) {
                this.removeFavorite(targetNode, userName);
            }
        } else {
            Node userFavoriteNode = this.getUserFavoriteFolder(userName);
            if (userFavoriteNode != null) {
                NodeIterator nodeIter = userFavoriteNode.getNodes();
                while (nodeIter.hasNext()) {
                    Node childNode = nodeIter.nextNode();
                    if (!this.linkManager.isLink((Item)childNode) || !node.isSame((Item)(targetNode = this.getTargetNode(childNode)))) continue;
                    childNode.remove();
                    userFavoriteNode.save();
                    return;
                }
            }
        }
    }

    @Override
    public boolean isFavoriter(String userName, Node node) throws Exception {
        LinkManager lnkManager = WCMCoreUtils.getService(LinkManager.class);
        if (lnkManager.isLink((Item)node) && lnkManager.isTargetReachable(node)) {
            node = lnkManager.getTarget(node);
        }
        Node userFavoriteNode = null;
        try {
            userFavoriteNode = this.getUserFavoriteFolder(userName);
            if (userFavoriteNode == null) {
                return false;
            }
        }
        catch (PathNotFoundException e) {
            return false;
        }
        NodeIterator nodeIter = userFavoriteNode.getNodes();
        while (nodeIter.hasNext()) {
            Node targetNode;
            Node childNode = nodeIter.nextNode();
            if (!this.linkManager.isLink((Item)childNode) || !node.isSame((Item)(targetNode = this.getTargetNode(childNode)))) continue;
            return true;
        }
        return false;
    }

    private Node getUserFavoriteFolder(String userName) throws Exception {
        if (this.organizationService.getUserHandler().findUserByName(userName) == null) {
            return null;
        }
        Node userNode = this.nodeHierarchyCreator.getUserNode(this.sessionProviderService.getSystemSessionProvider(null), userName);
        String favoritePath = this.nodeHierarchyCreator.getJcrPath(FAVORITE_ALIAS);
        if (favoritePath == null || !userNode.hasNode(favoritePath)) {
            return null;
        }
        return userNode.getNode(favoritePath);
    }

    private Node createFavoriteFolder(String userName) throws Exception {
        Node userNode = this.nodeHierarchyCreator.getUserNode(this.sessionProviderService.getSystemSessionProvider(null), userName);
        String userFavoritePath = this.nodeHierarchyCreator.getJcrPath(FAVORITE_ALIAS);
        Node userFavoriteNode = userNode.addNode(userFavoritePath, NT_UNSTRUCTURED);
        userFavoriteNode.addMixin(EXO_PRIVILEGEABLE);
        userFavoriteNode.addMixin(EXO_FAVORITEFOLDER);
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        permissionsMap.put(userName, PermissionType.ALL);
        ((ExtendedNode)userFavoriteNode).setPermissions(permissionsMap);
        userNode.save();
        return userFavoriteNode;
    }

    private Node getTargetNode(Node linkNode) {
        Node targetNode = null;
        try {
            targetNode = this.linkManager.getTarget(linkNode);
        }
        catch (ItemNotFoundException e) {
            targetNode = null;
        }
        catch (RepositoryException e) {
            targetNode = null;
        }
        return targetNode;
    }
}

