/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.exoplatform.services.jcr.config.CacheEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCacheListener;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NullItemData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheId;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheKey;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheQPath;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheStatistic;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheValue;
import org.exoplatform.services.jcr.impl.dataflow.persistent.SimplePersistedSize;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class LinkedWorkspaceStorageCacheImpl
implements WorkspaceStorageCache,
Startable {
    public static final int MAX_CACHE_SIZE = 2048;
    public static final long MAX_CACHE_LIVETIME = 600000L;
    public static final long DEF_STATISTIC_PERIOD = 300000L;
    public static final long DEF_CLEANER_PERIOD = 1200000L;
    public static final int DEF_BLOCKING_USERS_COUNT = 0;
    public static final String DEEP_DELETE_PARAMETER_NAME = "deep-delete";
    public static final String STATISTIC_PERIOD_PARAMETER_NAME = "statistic-period";
    public static final String STATISTIC_CLEAN_PARAMETER_NAME = "statistic-clean";
    public static final String STATISTIC_LOG_PARAMETER_NAME = "statistic-log";
    public static final String BLOCKING_USERS_COUNT_PARAMETER_NAME = "blocking-users-count";
    public static final String CLEANER_PERIOD_PARAMETER_NAME = "cleaner-period";
    public static final float LOAD_FACTOR = 0.7f;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.LinkedWorkspaceStorageCacheImpl");
    private final Map<CacheKey, CacheValue> cache;
    private final CacheLock writeLock = new CacheLock();
    private final WeakHashMap<String, List<NodeData>> nodesCache;
    private final WeakHashMap<String, List<PropertyData>> propertiesCache;
    private final String name;
    private boolean enabled;
    private final Timer workerTimer;
    private CacheStatistic statistic;
    private final boolean deepDelete;
    private long liveTime;
    private final int maxSize;
    private final AtomicLong miss = new AtomicLong();
    private final AtomicLong hits = new AtomicLong();
    private volatile long totalGetTime = 0L;
    private final boolean cleanStatistics;
    private final boolean showStatistic;

    public LinkedWorkspaceStorageCacheImpl(String name, boolean enabled, int maxSize, long liveTimeSec, long cleanerPeriodMillis, long statisticPeriodMillis, boolean deepDelete, boolean cleanStatistics, int blockingUsers, boolean showStatistic) throws RepositoryConfigurationException {
        this.name = name;
        this.maxSize = maxSize;
        this.liveTime = liveTimeSec * 1000L;
        this.nodesCache = new WeakHashMap();
        this.propertiesCache = new WeakHashMap();
        this.enabled = enabled;
        this.deepDelete = deepDelete;
        this.cleanStatistics = cleanStatistics;
        this.cache = this.createCacheMap(blockingUsers);
        this.workerTimer = new Timer(this.name + "_CacheWorker", true);
        this.scheduleTask(new CleanerTask(), 5, cleanerPeriodMillis);
        this.showStatistic = showStatistic;
        this.gatherStatistic();
        this.scheduleTask(new StatisticTask(), 5, statisticPeriodMillis);
    }

    public LinkedWorkspaceStorageCacheImpl(WorkspaceEntry wsConfig) throws RepositoryConfigurationException {
        boolean showStatistic;
        long statisticPeriod;
        boolean cleanStats;
        long cleanerPeriod;
        int blockingUsers;
        this.name = "jcr." + wsConfig.getUniqueName();
        CacheEntry cacheConfig = wsConfig.getCache();
        if (cacheConfig != null) {
            int maxSizeConf;
            this.enabled = cacheConfig.isEnabled();
            try {
                maxSizeConf = cacheConfig.getParameterInteger("max-size");
            }
            catch (RepositoryConfigurationException e) {
                maxSizeConf = cacheConfig.getParameterInteger("maxSize");
            }
            this.maxSize = maxSizeConf;
            int initialSize = this.maxSize > 2048 ? this.maxSize / 4 : this.maxSize;
            this.nodesCache = new WeakHashMap(initialSize, 0.7f);
            this.propertiesCache = new WeakHashMap(initialSize, 0.7f);
            try {
                this.liveTime = cacheConfig.getParameterTime("live-time");
            }
            catch (RepositoryConfigurationException e) {
                this.liveTime = cacheConfig.getParameterTime("liveTime");
            }
            this.deepDelete = cacheConfig.getParameterBoolean(DEEP_DELETE_PARAMETER_NAME, false);
            blockingUsers = cacheConfig.getParameterInteger(BLOCKING_USERS_COUNT_PARAMETER_NAME, 0);
            cleanerPeriod = cacheConfig.getParameterTime(CLEANER_PERIOD_PARAMETER_NAME, 1200000L);
            cleanStats = cacheConfig.getParameterBoolean(STATISTIC_CLEAN_PARAMETER_NAME, true);
            statisticPeriod = cacheConfig.getParameterTime(STATISTIC_PERIOD_PARAMETER_NAME, 300000L);
            showStatistic = cacheConfig.getParameterBoolean(STATISTIC_LOG_PARAMETER_NAME, false);
        } else {
            this.maxSize = 2048;
            this.liveTime = 600000L;
            this.nodesCache = new WeakHashMap();
            this.propertiesCache = new WeakHashMap();
            this.enabled = true;
            this.deepDelete = false;
            blockingUsers = 0;
            statisticPeriod = 300000L;
            cleanerPeriod = 1200000L;
            cleanStats = true;
            showStatistic = false;
        }
        this.cleanStatistics = cleanStats;
        this.showStatistic = showStatistic;
        if (blockingUsers > 2048) {
            blockingUsers = 2048;
            LOG.warn((Object)("blocking-users-count maximum is limited to 2k. Using " + blockingUsers));
        }
        this.cache = this.createCacheMap(blockingUsers);
        this.workerTimer = new Timer(this.name + "_CacheWorker", true);
        int start = (int)cleanerPeriod / 2;
        start = start > 60000 ? start : 60000;
        this.scheduleTask(new CleanerTask(), start, cleanerPeriod);
        this.gatherStatistic();
        start = (int)statisticPeriod / 2;
        start = start > 15000 ? start : 15000;
        this.scheduleTask(new StatisticTask(), start, statisticPeriod);
    }

    private Map<CacheKey, CacheValue> createCacheMap(int blockingUsers) {
        if (blockingUsers <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.name + " Create unblocking cache map."));
            }
            return new CacheMap<CacheKey, CacheValue>(this.maxSize, 0.7f);
        }
        if (blockingUsers == 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.name + " Create per-user blocking cache map."));
            }
            return new BlockingCacheMap<CacheKey, CacheValue>(this.maxSize, 0.7f);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.name + " Create per-users-group blocking cache map."));
        }
        return new GroupBlockingCacheMap<CacheKey, CacheValue>(this.maxSize, 0.7f, blockingUsers);
    }

    private void scheduleTask(TimerTask task, int start, long period) {
        Calendar firstTime = Calendar.getInstance();
        firstTime.add(14, start);
        if (period < 30000L) {
            LOG.warn((Object)("Cache worker schedule period too short " + period + ". Will use 30sec."));
            period = 30000L;
        }
        this.workerTimer.schedule(task, firstTime.getTime(), period);
    }

    private void gatherStatistic() {
        CacheStatistic st = new CacheStatistic(this.miss.get(), this.hits.get(), this.cache.size(), this.nodesCache.size(), this.propertiesCache.size(), this.maxSize, this.liveTime, this.totalGetTime);
        if (this.showStatistic) {
            try {
                double rel;
                double d = rel = st.getMiss() > 0L && st.getHits() > 0L ? (double)Math.round(10000.0 * (double)st.getHits() / (double)st.getMiss()) / 10000.0 : 0.0;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cache " + this.name + ": relevancy " + rel + " (hits:" + st.getHits() + ", miss:" + st.getMiss() + "), get:" + Math.round((double)(st.getHits() + st.getMiss()) / (st.getTotalGetTime() > 0L ? (double)st.getTotalGetTime() / 1000.0 : 1.0)) + "oper/sec (" + (double)st.getTotalGetTime() / 1000.0 + "sec), size:" + st.getSize() + " (max " + st.getMaxSize() + "), childs(nodes:" + st.getNodesSize() + ", properties:" + st.getPropertiesSize() + ")"));
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)("Show statistic log.info error " + e.getMessage()));
            }
        }
        this.statistic = st;
        if (this.cleanStatistics) {
            this.miss.set(0L);
            this.hits.set(0L);
            this.totalGetTime = 0L;
        }
    }

    @Override
    public long getSize() {
        return this.cache.size();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ItemData get(String identifier) {
        if (this.enabled && identifier != null) {
            try {
                return this.getItem(identifier);
            }
            catch (Exception e) {
                LOG.error((Object)("GET operation fails. Item ID=" + identifier + ". Error " + e + ". NULL returned."), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public ItemData get(String parentId, QPathEntry name, ItemType itemType) {
        if (this.enabled && parentId != null && name != null) {
            try {
                ItemData itemData = null;
                if (itemType == ItemType.NODE || itemType == ItemType.UNKNOWN) {
                    itemData = this.getItem(parentId, name, ItemType.NODE);
                }
                if (itemType == ItemType.PROPERTY || itemType == ItemType.UNKNOWN && itemData == null) {
                    itemData = this.getItem(parentId, name, ItemType.PROPERTY);
                }
                return itemData;
            }
            catch (Exception e) {
                LOG.error((Object)("GET operation fails. Parent ID=" + parentId + " name " + (name != null ? name.getAsString() : name) + ". Error " + e + ". NULL returned."), (Throwable)e);
            }
        }
        return null;
    }

    protected void putItem(ItemData data) {
        this.cache.put(new CacheId(data.getIdentifier()), new CacheValue(data, System.currentTimeMillis() + this.liveTime));
        this.cache.put(new CacheQPath(data.getParentIdentifier(), data.getQPath(), ItemType.getItemType(data)), new CacheValue(data, System.currentTimeMillis() + this.liveTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ItemData item) {
        block32: {
            if (this.enabled && item != null) {
                if (item instanceof NullItemData) {
                    return;
                }
                this.writeLock.lock();
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.name + ", put()    " + item.getQPath().getAsString() + "    " + item.getIdentifier() + "  --  " + item));
                    }
                    this.putItem(item);
                    if (item.isNode()) {
                        List<NodeData> cachedParentChilds = this.nodesCache.get(item.getParentIdentifier());
                        if (cachedParentChilds == null) break block32;
                        NodeData nodeData = (NodeData)item;
                        int orderNumber = nodeData.getOrderNumber();
                        List<NodeData> list = cachedParentChilds;
                        synchronized (list) {
                            int index = cachedParentChilds.indexOf(nodeData);
                            if (index >= 0) {
                                if (orderNumber != cachedParentChilds.get(index).getOrderNumber()) {
                                    ArrayList<NodeData> newChilds = new ArrayList<NodeData>(cachedParentChilds.size());
                                    for (int ci = 0; ci < cachedParentChilds.size(); ++ci) {
                                        if (index == ci) {
                                            newChilds.add(nodeData);
                                            continue;
                                        }
                                        newChilds.add(cachedParentChilds.get(ci));
                                    }
                                    this.nodesCache.put(item.getParentIdentifier(), newChilds);
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)(this.name + ", put()    update child node  " + nodeData.getIdentifier() + "  order #" + orderNumber));
                                    }
                                } else {
                                    cachedParentChilds.set(index, nodeData);
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)(this.name + ", put()    update child node  " + nodeData.getIdentifier() + "  at index #" + index));
                                    }
                                }
                            } else {
                                ArrayList<NodeData> newChilds = new ArrayList<NodeData>(cachedParentChilds.size() + 1);
                                for (int ci = 0; ci < cachedParentChilds.size(); ++ci) {
                                    newChilds.add(cachedParentChilds.get(ci));
                                }
                                newChilds.add(nodeData);
                                this.nodesCache.put(item.getParentIdentifier(), newChilds);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(this.name + ", put()    add child node  " + nodeData.getIdentifier()));
                                }
                            }
                            break block32;
                        }
                    }
                    List<PropertyData> cachedParentChilds = this.propertiesCache.get(item.getParentIdentifier());
                    if (cachedParentChilds == null) break block32;
                    if (cachedParentChilds.get(0).getValues().size() > 0) {
                        List<PropertyData> list = cachedParentChilds;
                        synchronized (list) {
                            int index = cachedParentChilds.indexOf(item);
                            if (index >= 0) {
                                cachedParentChilds.set(index, (PropertyData)item);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(this.name + ", put()    update child property  " + item.getIdentifier() + "  at index #" + index));
                                }
                            } else if (index == -1) {
                                ArrayList<PropertyData> newChilds = new ArrayList<PropertyData>(cachedParentChilds.size() + 1);
                                for (int ci = 0; ci < cachedParentChilds.size(); ++ci) {
                                    newChilds.add(cachedParentChilds.get(ci));
                                }
                                newChilds.add((PropertyData)item);
                                this.propertiesCache.put(item.getParentIdentifier(), newChilds);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(this.name + ", put()    add child property  " + item.getIdentifier()));
                                }
                            }
                            break block32;
                        }
                    }
                    this.propertiesCache.remove(item.getParentIdentifier());
                }
                catch (Exception e) {
                    LOG.error((Object)(this.name + ", Error put item data in cache: " + (item != null ? item.getQPath().getAsString() : "[null]")), (Throwable)e);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildProperties(NodeData parentData, List<PropertyData> childItems) {
        if (this.enabled && parentData != null && childItems != null) {
            String logInfo = null;
            if (LOG.isDebugEnabled()) {
                logInfo = "parent:   " + parentData.getQPath().getAsString() + "    " + parentData.getIdentifier() + " " + childItems.size();
                LOG.debug((Object)(this.name + ", addChildProperties() >>> " + logInfo));
            }
            String operName = "";
            this.writeLock.lock();
            try {
                operName = "removing parent";
                this.removeItem(parentData);
                operName = "caching parent";
                this.putItem(parentData);
                List<PropertyData> list = childItems;
                synchronized (list) {
                    operName = "caching child properties list";
                    this.propertiesCache.put(parentData.getIdentifier(), childItems);
                    operName = "caching child properties";
                    for (ItemData itemData : childItems) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.name + ", addChildProperties()    " + itemData.getQPath().getAsString() + "    " + itemData.getIdentifier() + "  --  " + itemData));
                        }
                        this.putItem(itemData);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + ", Error in addChildProperties() " + operName + ": parent " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            finally {
                this.writeLock.unlock();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.name + ", addChildProperties() <<< " + logInfo));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildPropertiesList(NodeData parentData, List<PropertyData> childItems) {
        if (this.enabled && parentData != null && childItems != null) {
            String logInfo = null;
            if (LOG.isDebugEnabled()) {
                logInfo = "parent:   " + parentData.getQPath().getAsString() + "    " + parentData.getIdentifier() + " " + childItems.size();
                LOG.debug((Object)(this.name + ", addChildPropertiesList() >>> " + logInfo));
            }
            String operName = "";
            this.writeLock.lock();
            try {
                operName = "removing parent";
                this.removeItem(parentData);
                operName = "caching parent";
                this.putItem(parentData);
                List<PropertyData> list = childItems;
                synchronized (list) {
                    operName = "caching child properties list";
                    this.propertiesCache.put(parentData.getIdentifier(), childItems);
                }
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + ", Error in addChildPropertiesList() " + operName + ": parent " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            finally {
                this.writeLock.unlock();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.name + ", addChildPropertiesList() <<< " + logInfo));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildNodes(NodeData parentData, List<NodeData> childItems) {
        if (this.enabled && parentData != null && childItems != null) {
            String logInfo = null;
            if (LOG.isDebugEnabled()) {
                logInfo = "parent:   " + parentData.getQPath().getAsString() + "    " + parentData.getIdentifier() + " " + childItems.size();
                LOG.debug((Object)(this.name + ", addChildNodes() >>> " + logInfo));
            }
            String operName = "";
            this.writeLock.lock();
            try {
                operName = "removing parent";
                this.removeItem(parentData);
                operName = "caching parent";
                this.putItem(parentData);
                List<NodeData> list = childItems;
                synchronized (list) {
                    operName = "caching child nodes list";
                    this.nodesCache.put(parentData.getIdentifier(), childItems);
                    operName = "caching child nodes";
                    for (ItemData itemData : childItems) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.name + ", addChildNodes()    " + itemData.getQPath().getAsString() + "    " + itemData.getIdentifier() + "  --  " + itemData));
                        }
                        this.putItem(itemData);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + ", Error in addChildNodes() " + operName + ": parent " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            finally {
                this.writeLock.unlock();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.name + ", addChildNodes() <<< " + logInfo));
            }
        }
    }

    @Override
    public void remove(ItemData item) {
        if (this.enabled && item != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.name + ", remove() " + item.getQPath().getAsString() + " " + item.getIdentifier()));
            }
            this.writeLock.lock();
            try {
                String itemId = item.getIdentifier();
                this.removeItem(item);
                if (item.isNode()) {
                    this.nodesCache.remove(itemId);
                    this.propertiesCache.remove(itemId);
                    this.removeChildNode(item.getParentIdentifier(), itemId);
                } else {
                    this.removeChildProperty(item.getParentIdentifier(), itemId);
                }
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + ", Error remove item data from cache: " + item.getQPath().getAsString()), (Throwable)e);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String identifier, ItemData item) {
        this.writeLock.lock();
        try {
            ItemData data = this.getItem(identifier);
            if (data != null && data.equals(item)) {
                this.cache.remove(new CacheId(identifier));
            }
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + ", Error remove item data from cache: " + item.getQPath().getAsString()), (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ItemData getItem(String identifier) {
        long start = System.currentTimeMillis();
        try {
            CacheId k = new CacheId(identifier);
            CacheValue v = this.cache.get(k);
            if (v != null) {
                ItemData c = v.getItem();
                if (v.getExpiredTime() > System.currentTimeMillis()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.name + ", getItem() " + identifier + " --> " + (c != null ? c.getQPath().getAsString() + " parent:" + c.getParentIdentifier() : "[null]")));
                    }
                    this.hits.incrementAndGet();
                    ItemData itemData = c;
                    return itemData;
                }
                this.writeLock.lock();
                try {
                    this.cache.remove(k);
                    this.cache.remove(new CacheQPath(c.getParentIdentifier(), c.getQPath(), ItemType.getItemType(c)));
                    if (c.isNode()) {
                        this.nodesCache.remove(c.getIdentifier());
                        this.propertiesCache.remove(c.getIdentifier());
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            this.miss.incrementAndGet();
            ItemData itemData = null;
            return itemData;
        }
        finally {
            this.totalGetTime += System.currentTimeMillis() - start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ItemData getItem(String parentUuid, QPathEntry qname, ItemType itemType) {
        long start = System.currentTimeMillis();
        try {
            CacheQPath k = new CacheQPath(parentUuid, qname, itemType);
            CacheValue v = this.cache.get(k);
            if (v != null) {
                ItemData c = v.getItem();
                if (v.getExpiredTime() > System.currentTimeMillis()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.name + ", getItem() " + (c != null ? c.getQPath().getAsString() : "[null]") + " --> " + (c != null ? c.getIdentifier() + " parent:" + c.getParentIdentifier() : "[null]")));
                    }
                    this.hits.incrementAndGet();
                    ItemData itemData = c;
                    return itemData;
                }
                this.writeLock.lock();
                try {
                    this.cache.remove(k);
                    this.cache.remove(new CacheId(c.getIdentifier()));
                    if (c.isNode()) {
                        this.nodesCache.remove(c.getIdentifier());
                        this.propertiesCache.remove(c.getIdentifier());
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            this.miss.incrementAndGet();
            ItemData itemData = null;
            return itemData;
        }
        finally {
            this.totalGetTime += System.currentTimeMillis() - start;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodes(NodeData parentData) {
        if (this.enabled && parentData != null) {
            long start = System.currentTimeMillis();
            try {
                List<NodeData> cn = this.nodesCache.get(parentData.getIdentifier());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + ", getChildNodes() " + parentData.getQPath().getAsString() + " " + parentData.getIdentifier()));
                    StringBuilder blog = new StringBuilder();
                    if (cn != null) {
                        blog.append("\n");
                        for (NodeData nd : cn) {
                            blog.append("\t\t" + nd.getQPath().getAsString() + " " + nd.getIdentifier() + "\n");
                        }
                        LOG.debug((Object)("\t-->" + blog.toString()));
                    } else {
                        LOG.debug((Object)"\t--> null");
                    }
                }
                if (cn != null) {
                    this.hits.incrementAndGet();
                } else {
                    this.miss.incrementAndGet();
                }
                List<NodeData> list = cn;
                return list;
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + ", Error in getChildNodes() parentData: " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            finally {
                this.totalGetTime += System.currentTimeMillis() - start;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildNodesCount(NodeData parentData) {
        if (this.enabled && parentData != null) {
            long start = System.currentTimeMillis();
            try {
                List<NodeData> cn = this.nodesCache.get(parentData.getIdentifier());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + ", getChildNodesCount() " + parentData.getQPath().getAsString() + " " + parentData.getIdentifier()));
                    StringBuilder blog = new StringBuilder();
                    if (cn != null) {
                        blog.append("\n");
                        for (NodeData nd : cn) {
                            blog.append("\t\t" + nd.getQPath().getAsString() + " " + nd.getIdentifier() + "\n");
                        }
                        LOG.debug((Object)("\t-->" + blog.toString()));
                    } else {
                        LOG.debug((Object)"\t--> null");
                    }
                }
                if (cn != null) {
                    this.hits.incrementAndGet();
                } else {
                    this.miss.incrementAndGet();
                }
                int n = cn != null ? cn.size() : -1;
                return n;
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + ", Error in getChildNodesCount() parentData: " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            finally {
                this.totalGetTime += System.currentTimeMillis() - start;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildProperties(NodeData parentData) {
        if (this.enabled && parentData != null) {
            long start = System.currentTimeMillis();
            try {
                List<PropertyData> cp = this.propertiesCache.get(parentData.getIdentifier());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + ", getChildProperties() " + parentData.getQPath().getAsString() + " " + parentData.getIdentifier()));
                    StringBuilder blog = new StringBuilder();
                    if (cp != null) {
                        blog.append("\n");
                        for (PropertyData pd : cp) {
                            blog.append("\t\t" + pd.getQPath().getAsString() + " " + pd.getIdentifier() + "\n");
                        }
                        LOG.debug((Object)("\t--> " + blog.toString()));
                    } else {
                        LOG.debug((Object)"\t--> null");
                    }
                }
                if (cp != null && cp.get(0).getValues().size() > 0) {
                    this.hits.incrementAndGet();
                    List<PropertyData> list = cp;
                    return list;
                }
                this.miss.incrementAndGet();
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + ", Error in getChildProperties() parentData: " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            finally {
                this.totalGetTime += System.currentTimeMillis() - start;
            }
        }
        return null;
    }

    @Override
    public List<PropertyData> getReferencedProperties(String identifier) {
        return null;
    }

    @Override
    public void addReferencedProperties(String identifier, List<PropertyData> refProperties) {
    }

    @Override
    public List<PropertyData> listChildProperties(NodeData parentData) {
        if (this.enabled && parentData != null) {
            try {
                List<PropertyData> cp = this.propertiesCache.get(parentData.getIdentifier());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + ", listChildProperties() " + parentData.getQPath().getAsString() + " " + parentData.getIdentifier()));
                    StringBuilder blog = new StringBuilder();
                    if (cp != null) {
                        blog.append("\n");
                        for (PropertyData pd : cp) {
                            blog.append("\t\t" + pd.getQPath().getAsString() + " " + pd.getIdentifier() + "\n");
                        }
                        LOG.debug((Object)("\t--> " + blog.toString()));
                    } else {
                        LOG.debug((Object)"\t--> null");
                    }
                }
                if (cp != null) {
                    this.hits.incrementAndGet();
                } else {
                    this.miss.incrementAndGet();
                }
                return cp;
            }
            catch (Exception e) {
                LOG.error((Object)(this.name + ", Error in listChildProperties() parentData: " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isPatternSupported() {
        return false;
    }

    @Override
    public boolean isChildNodesByPageSupported() {
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMaxSize(int maxSize) {
        LOG.warn((Object)"setMaxSize not supported now");
    }

    public void setLiveTime(long liveTime) {
        this.writeLock.lock();
        try {
            this.liveTime = liveTime;
        }
        finally {
            this.writeLock.unlock();
        }
        LOG.info((Object)(this.name + " : set liveTime=" + liveTime + "ms. New value will be applied to items cached from this moment."));
    }

    protected void removeItem(ItemData item) {
        String itemId = item.getIdentifier();
        this.cache.remove(new CacheId(itemId));
        CacheValue v2 = this.cache.remove(new CacheQPath(item.getParentIdentifier(), item.getQPath(), ItemType.getItemType(item)));
        if (v2 != null && !v2.getItem().getIdentifier().equals(itemId)) {
            this.removeItem(v2.getItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSiblings(NodeData node) {
        if (node.getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) {
            return;
        }
        this.writeLock.lock();
        try {
            this.nodesCache.remove(node.getParentIdentifier());
            QPath path = node.getQPath().makeParentPath();
            ArrayList<CacheId> toRemove = new ArrayList<CacheId>();
            Iterator<Map.Entry<CacheKey, CacheValue>> citer = this.cache.entrySet().iterator();
            while (citer.hasNext()) {
                Map.Entry<CacheKey, CacheValue> ce = citer.next();
                CacheKey key = ce.getKey();
                CacheValue v = ce.getValue();
                if (v != null) {
                    if (!key.isDescendantOf(path)) continue;
                    toRemove.add(new CacheId(v.getItem().getIdentifier()));
                    citer.remove();
                    this.nodesCache.remove(v.getItem().getIdentifier());
                    this.propertiesCache.remove(v.getItem().getIdentifier());
                    continue;
                }
                citer.remove();
            }
            for (CacheId id : toRemove) {
                this.cache.remove(id);
            }
            toRemove.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSaveItems(ItemStateChangesLog changesLog) {
        if (!this.enabled) {
            return;
        }
        ItemState prevState = null;
        for (ItemState state : changesLog.getAllStates()) {
            block25: {
                ItemData item = state.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.name + ", onSaveItems() " + ItemState.nameFromValue(state.getState()) + " " + item.getQPath().getAsString() + " " + item.getIdentifier() + " parent:" + item.getParentIdentifier()));
                }
                try {
                    if (state.isAdded()) {
                        this.put(item);
                        break block25;
                    }
                    if (state.isDeleted()) {
                        this.remove(item);
                        break block25;
                    }
                    if (state.isRenamed()) {
                        this.put(item);
                        break block25;
                    }
                    if (state.isPathChanged()) {
                        this.writeLock.lock();
                        try {
                            for (Map.Entry<CacheKey, CacheValue> cacheEntry : this.cache.entrySet()) {
                                int index;
                                CacheKey cacheKey = cacheEntry.getKey();
                                CacheValue cacheValue = cacheEntry.getValue();
                                ItemData oldItemData = cacheValue.getItem();
                                if (!oldItemData.getQPath().isDescendantOf(state.getOldPath())) continue;
                                int relativeDegree = oldItemData.getQPath().getDepth() - state.getOldPath().getDepth();
                                QPath newQPath = QPath.makeChildPath(state.getData().getQPath(), oldItemData.getQPath().getRelPath(relativeDegree));
                                if (oldItemData.isNode()) {
                                    NodeData nodeData = (NodeData)oldItemData;
                                    PersistedNodeData newItemData = new PersistedNodeData(nodeData.getIdentifier(), newQPath, nodeData.getParentIdentifier(), nodeData.getPersistedVersion(), nodeData.getOrderNumber(), nodeData.getPrimaryTypeName(), nodeData.getMixinTypeNames(), nodeData.getACL());
                                    this.cache.put(cacheKey, new CacheValue(newItemData, cacheValue.getExpiredTime()));
                                    List<NodeData> cachedChildNodes = this.nodesCache.get(nodeData.getParentIdentifier());
                                    if (cachedChildNodes == null) continue;
                                    index = cachedChildNodes.indexOf(oldItemData);
                                    cachedChildNodes.set(index, newItemData);
                                    continue;
                                }
                                PersistedPropertyData oldPropertyData = (PersistedPropertyData)oldItemData;
                                PersistedPropertyData newPropertyData = new PersistedPropertyData(oldPropertyData.getIdentifier(), newQPath, oldPropertyData.getParentIdentifier(), oldPropertyData.getPersistedVersion(), oldPropertyData.getType(), oldPropertyData.isMultiValued(), oldPropertyData.getValues(), new SimplePersistedSize(oldPropertyData.getPersistedSize()));
                                this.cache.put(cacheKey, new CacheValue(newPropertyData, cacheValue.getExpiredTime()));
                                List<PropertyData> cachedChildProps = this.propertiesCache.get(oldPropertyData.getParentIdentifier());
                                if (cachedChildProps == null) continue;
                                index = cachedChildProps.indexOf(oldItemData);
                                cachedChildProps.set(index, newPropertyData);
                            }
                            break block25;
                        }
                        finally {
                            this.writeLock.unlock();
                        }
                    }
                    if (state.isUpdated()) {
                        if (item.isNode()) {
                            if (prevState != null && prevState.isDeleted() && prevState.getData().getParentIdentifier().equals(item.getParentIdentifier())) {
                                this.removeSiblings((NodeData)item);
                            }
                        } else if (item.getQPath().getName().equals((Object)Constants.EXO_PERMISSIONS)) {
                            ItemData parent = this.get(item.getParentIdentifier());
                            this.remove(parent);
                            this.writeLock.lock();
                            try {
                                this.nodesCache.remove(parent.getParentIdentifier());
                                Iterator<CacheValue> cacheIterator = this.cache.values().iterator();
                                while (cacheIterator.hasNext()) {
                                    ItemData cachedItem = cacheIterator.next().getItem();
                                    if (!cachedItem.isNode() || !cachedItem.getQPath().isDescendantOf(parent.getQPath())) continue;
                                    cacheIterator.remove();
                                }
                                Iterator<List<NodeData>> childNodesIterator = this.nodesCache.values().iterator();
                                while (childNodesIterator.hasNext()) {
                                    List<NodeData> list = childNodesIterator.next();
                                    if (list == null || list.size() <= 0 || !list.get(0).getQPath().isDescendantOf(parent.getQPath())) continue;
                                    childNodesIterator.remove();
                                }
                            }
                            finally {
                                this.writeLock.unlock();
                            }
                        }
                        this.put(item);
                        break block25;
                    }
                    if (state.isMixinChanged()) {
                        this.put(item);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)(this.name + ", Error process onSaveItems action for item data: " + (item != null ? item.getQPath().getAsString() : "[null]")), (Throwable)e);
                }
            }
            prevState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyData removeChildProperty(String parentIdentifier, String childIdentifier) {
        List<PropertyData> childProperties = this.propertiesCache.get(parentIdentifier);
        if (childProperties != null) {
            List<PropertyData> list = childProperties;
            synchronized (list) {
                Iterator<PropertyData> i = childProperties.iterator();
                while (i.hasNext()) {
                    PropertyData cn = i.next();
                    if (!cn.getIdentifier().equals(childIdentifier)) continue;
                    i.remove();
                    if (childProperties.size() <= 0) {
                        this.propertiesCache.remove(parentIdentifier);
                    }
                    return cn;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeData removeChildNode(String parentIdentifier, String childIdentifier) {
        List<NodeData> childNodes = this.nodesCache.get(parentIdentifier);
        if (childNodes != null) {
            List<NodeData> list = childNodes;
            synchronized (list) {
                Iterator<NodeData> i = childNodes.iterator();
                while (i.hasNext()) {
                    NodeData cn = i.next();
                    if (!cn.getIdentifier().equals(childIdentifier)) continue;
                    i.remove();
                    return cn;
                }
            }
        }
        return null;
    }

    public CacheStatistic getStatistic() {
        return this.statistic;
    }

    String dump() {
        StringBuilder res = new StringBuilder();
        for (Map.Entry<CacheKey, CacheValue> ce : this.cache.entrySet()) {
            res.append(ce.getKey().hashCode());
            res.append("\t\t");
            res.append(ce.getValue().getItem().getIdentifier());
            res.append(", ");
            res.append(ce.getValue().getItem().getQPath().getAsString());
            res.append(", ");
            res.append(ce.getValue().getExpiredTime());
            res.append(", ");
            res.append(ce.getKey().getClass().getSimpleName());
            res.append("\r\n");
        }
        return res.toString();
    }

    @Override
    public void beginTransaction() {
    }

    @Override
    public void commitTransaction() {
    }

    @Override
    public void rollbackTransaction() {
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    public void start() {
    }

    public void stop() {
        if (this.workerTimer != null) {
            try {
                this.workerTimer.cancel();
            }
            catch (Throwable e) {
                LOG.warn((Object)(this.name + " cache, stop error " + e.getMessage()));
            }
        }
        this.nodesCache.clear();
        this.propertiesCache.clear();
        this.cache.clear();
    }

    @Override
    public void addChildProperties(NodeData parent, QPathEntryFilter pattern, List<PropertyData> childProperties) {
    }

    @Override
    public List<PropertyData> getChildProperties(NodeData parent, QPathEntryFilter pattern) {
        return null;
    }

    @Override
    public void addChildNodes(NodeData parent, QPathEntryFilter pattern, List<NodeData> childNodes) {
    }

    @Override
    public List<NodeData> getChildNodes(NodeData parent, QPathEntryFilter pattern) {
        return null;
    }

    @Override
    public List<NodeData> getChildNodesByPage(NodeData parent, int fromOrderNum) {
        return null;
    }

    @Override
    public void addChildNodesByPage(NodeData parent, List<NodeData> childs, int fromOrderNum) {
    }

    @Override
    public void addListener(WorkspaceStorageCacheListener listener) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The cache listeners are not supported by the LinkedWorkspaceStorageCacheImpl");
    }

    @Override
    public void removeListener(WorkspaceStorageCacheListener listener) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The cache listeners are not supported by the LinkedWorkspaceStorageCacheImpl");
    }

    @Override
    public void addChildNodesCount(NodeData parent, int count) {
    }

    class StatisticTask
    extends WorkerTask {
        StatisticTask() {
        }

        @Override
        public void run() {
            if (this.currentWorker == null || this.currentWorker.done) {
                this.currentWorker = new StatisticCollector();
                this.currentWorker.start();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Statistic task skipped. Previous one still runs. Will try next time.");
            }
        }
    }

    class CleanerTask
    extends WorkerTask {
        CleanerTask() {
        }

        @Override
        public void run() {
            if (this.currentWorker == null || this.currentWorker.done) {
                this.currentWorker = new Cleaner(this.log);
                this.currentWorker.start();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Cleaner task skipped. Previous one still runs. Will try next time.");
            }
        }
    }

    abstract class WorkerTask
    extends TimerTask {
        protected Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.LinkedWorkspaceStorageCacheImpl_Worker");
        protected Worker currentWorker = null;

        WorkerTask() {
        }
    }

    class StatisticCollector
    extends Worker {
        StatisticCollector() {
        }

        @Override
        public void run() {
            try {
                LinkedWorkspaceStorageCacheImpl.this.gatherStatistic();
            }
            finally {
                this.done = true;
            }
        }
    }

    class Cleaner
    extends Worker {
        private final Log log;

        Cleaner(Log log) {
            this.log = log;
        }

        @Override
        public void run() {
            try {
                this.cleanExpired();
            }
            finally {
                this.done = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanExpired() {
            if (LinkedWorkspaceStorageCacheImpl.this.writeLock.tryLock()) {
                String lockOwnerId = "";
                try {
                    lockOwnerId = String.valueOf(LinkedWorkspaceStorageCacheImpl.this.writeLock.getLockOwner());
                    int sizeBefore = LinkedWorkspaceStorageCacheImpl.this.cache.size();
                    int expiredCount = 0;
                    long start = System.currentTimeMillis();
                    Iterator citer = LinkedWorkspaceStorageCacheImpl.this.cache.entrySet().iterator();
                    while (citer.hasNext()) {
                        Map.Entry ce = citer.next();
                        if (((CacheValue)ce.getValue()).getExpiredTime() > System.currentTimeMillis()) continue;
                        ItemData item = ((CacheValue)ce.getValue()).getItem();
                        if (item != null) {
                            this.removeExpiredChilds(item);
                        }
                        citer.remove();
                        ++expiredCount;
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)("Cleaner task done in " + (System.currentTimeMillis() - start) + "ms. Size " + sizeBefore + " -> " + LinkedWorkspaceStorageCacheImpl.this.cache.size() + ", " + expiredCount + " processed."));
                    return;
                }
                catch (ConcurrentModificationException e) {
                    if (!this.log.isDebugEnabled()) return;
                    StringBuilder lockUsers = new StringBuilder();
                    for (Thread user : LinkedWorkspaceStorageCacheImpl.this.writeLock.getLockThreads()) {
                        lockUsers.append(user.toString());
                        lockUsers.append(',');
                    }
                    this.log.error((Object)("Cleaner task error, cache in use. On-write owner [" + lockOwnerId + "], users [" + lockUsers.toString() + "], error " + e), (Throwable)e);
                    return;
                }
                catch (Throwable e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error((Object)("Cleaner task error " + e), e);
                        return;
                    }
                    this.log.error((Object)("Cleaner task error " + e + ". Will try next time."));
                    return;
                }
                finally {
                    LinkedWorkspaceStorageCacheImpl.this.writeLock.unlock();
                }
            } else {
                if (!this.log.isDebugEnabled()) return;
                this.log.debug((Object)("Cleaner task skipped. Ceche in use by another process [" + String.valueOf(LinkedWorkspaceStorageCacheImpl.this.writeLock.getLockOwner()) + "]. Will try next time."));
            }
        }

        private void removeExpiredChilds(ItemData item) {
            if (item.isNode()) {
                if (LinkedWorkspaceStorageCacheImpl.this.propertiesCache.remove(item.getIdentifier()) != null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)(LinkedWorkspaceStorageCacheImpl.this.name + ", removeExpiredChilds() propertiesCache.remove " + item.getIdentifier()));
                }
            } else if (LinkedWorkspaceStorageCacheImpl.this.propertiesCache.remove(item.getParentIdentifier()) != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)(LinkedWorkspaceStorageCacheImpl.this.name + ", removeExpiredChilds() propertiesCache.remove " + item.getParentIdentifier()));
            }
        }
    }

    abstract class Worker
    extends Thread {
        protected volatile boolean done = false;

        Worker() {
            this.setDaemon(true);
        }
    }

    class GroupBlockingCacheMap<K extends CacheKey, V extends CacheValue>
    extends CacheMap<K, V> {
        private final Semaphore usersLock;

        GroupBlockingCacheMap(long maxSize, float loadFactor, int limit) {
            super(maxSize, loadFactor);
            this.usersLock = new Semaphore(limit);
        }

        @Override
        public boolean containsValue(Object value) {
            try {
                this.usersLock.acquire();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Error in cache.containsValue, current thread is interrupted.", (Throwable)e);
                return false;
            }
            try {
                boolean bl = super.containsValue(value);
                return bl;
            }
            finally {
                this.usersLock.release();
            }
        }

        @Override
        public V get(Object key) {
            try {
                this.usersLock.acquire();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Error in cache.get, return null, current thread is interrupted.", (Throwable)e);
                return null;
            }
            try {
                CacheValue cacheValue = (CacheValue)super.get(key);
                return (V)cacheValue;
            }
            finally {
                this.usersLock.release();
            }
        }
    }

    class BlockingCacheMap<K extends CacheKey, V extends CacheValue>
    extends CacheMap<K, V> {
        private final CacheLock userLock;

        BlockingCacheMap(long maxSize, float loadFactor) {
            super(maxSize, loadFactor);
            this.userLock = new CacheLock();
        }

        @Override
        public boolean containsValue(Object value) {
            this.userLock.lock();
            try {
                boolean bl = super.containsValue(value);
                return bl;
            }
            finally {
                this.userLock.unlock();
            }
        }

        @Override
        public V get(Object key) {
            this.userLock.lock();
            try {
                CacheValue cacheValue = (CacheValue)super.get(key);
                return (V)cacheValue;
            }
            finally {
                this.userLock.unlock();
            }
        }
    }

    class CacheMap<K extends CacheKey, V extends CacheValue>
    extends LinkedHashMap<K, V> {
        CacheMap(long maxSize, float loadFactor) {
            super(Math.round((float)maxSize / loadFactor) + 100, loadFactor);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() > LinkedWorkspaceStorageCacheImpl.this.maxSize) {
                ItemData item;
                CacheValue v = (CacheValue)eldest.getValue();
                if (v != null && (item = v.getItem()).isNode()) {
                    LinkedWorkspaceStorageCacheImpl.this.nodesCache.remove(item.getIdentifier());
                    LinkedWorkspaceStorageCacheImpl.this.propertiesCache.remove(item.getIdentifier());
                }
                return true;
            }
            return false;
        }
    }

    class CacheLock
    extends ReentrantLock {
        CacheLock() {
        }

        Collection<Thread> getLockThreads() {
            return this.getQueuedThreads();
        }

        Thread getLockOwner() {
            return this.getOwner();
        }
    }
}

