/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.hibernate;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.exception.UniqueObjectException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupEventListenerHandler;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.hibernate.MembershipDAOImpl;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.security.PermissionConstants;
import org.hibernate.Query;
import org.hibernate.Session;

@Deprecated
public class GroupDAOImpl
implements GroupHandler,
GroupEventListenerHandler {
    public static final String queryFindGroupByName = "from g in class org.exoplatform.services.organization.impl.GroupImpl where g.groupName = :id ";
    public static final String queryFindGroupById = "from g in class org.exoplatform.services.organization.impl.GroupImpl where g.id = :id ";
    public static final String queryFindGroupByParent = "from g in class org.exoplatform.services.organization.impl.GroupImpl where g.parentId = :parentid ";
    public static final String queryFindCountGroupByParent = "select count(*)from g in class org.exoplatform.services.organization.impl.GroupImpl where g.parentId = :parentid ";
    private static final String queryFindRootGroups = "from g in class org.exoplatform.services.organization.impl.GroupImpl where g.parentId is null";
    private static final String queryFindGroupsOfUser = "select distinct g from g in class org.exoplatform.services.organization.impl.GroupImpl,      m in class org.exoplatform.services.organization.impl.MembershipImpl where m.groupId = g.id and m.userName = :username";
    private static final String queryFindGroupByMembership = "select g from m in class org.exoplatform.services.organization.impl.MembershipImpl,      g in class org.exoplatform.services.organization.impl.GroupImpl where m.groupId = g.id and m.userName = :username and m.membershipType = :membershiptype ";
    private static final String queryResolveGroupByMembership = "select g from m in class org.exoplatform.services.organization.impl.MembershipImpl,      g in class org.exoplatform.services.organization.impl.GroupImpl where m.groupId = g.id and m.userName = :username and (m.membershipType = :membershiptype or m.membershipType = '*')";
    private static final String queryGetAllGroups = "from g in class org.exoplatform.services.organization.impl.GroupImpl";
    private final HibernateService service_;
    private final List<GroupEventListener> listeners_;
    protected final OrganizationService orgService;

    public GroupDAOImpl(HibernateService service, OrganizationService orgService) {
        this.service_ = service;
        this.orgService = orgService;
        this.listeners_ = new ArrayList<GroupEventListener>();
    }

    public void addGroupEventListener(GroupEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners_.add(listener);
    }

    public void removeGroupEventListener(GroupEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners_.remove(listener);
    }

    public final Group createGroupInstance() {
        return new GroupImpl();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        String groupId = "/" + child.getGroupName();
        GroupImpl childImpl = (GroupImpl)child;
        if (parent != null) {
            Group parentGroup = this.findGroupById(parent.getId());
            if (parentGroup == null) {
                throw new InvalidNameException("Can't add node to not existed parent " + parent.getId());
            }
            groupId = parentGroup.getId() + "/" + child.getGroupName();
            childImpl.setParentId(parentGroup.getId());
        } else if (child.getId() != null) {
            groupId = child.getId();
        }
        Group o = this.findGroupById(groupId);
        if (o != null) {
            Object[] args = new Object[]{child.getGroupName()};
            throw new UniqueObjectException("OrganizationService.unique-group-exception", args);
        }
        childImpl.setId(groupId);
        if (broadcast) {
            this.preSave(child, true);
        }
        Session session = this.service_.openSession();
        session.save((Object)childImpl);
        session.flush();
        if (broadcast) {
            this.postSave(child, true);
        }
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        if (broadcast) {
            this.preSave(group, false);
        }
        Session session = this.service_.openSession();
        session.update((Object)group);
        session.flush();
        if (broadcast) {
            this.postSave(group, false);
        }
    }

    private boolean hasChildrenGroups(Group parent) throws Exception {
        Session session = this.service_.openSession();
        long countChildrenGroup = (Long)session.createQuery(queryFindCountGroupByParent).setString("parentid", parent.getId()).list().get(0);
        return countChildrenGroup > 0L;
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        if (session.get(group.getClass(), (Serializable)((Object)group.getId())) == null) {
            throw new InvalidNameException("Can not remove group " + group.getGroupName() + "record, because group does not exist.");
        }
        if (this.hasChildrenGroups(group)) {
            throw new IllegalStateException("Group " + group.getGroupName() + " has at least one child group");
        }
        if (broadcast) {
            this.preDelete(group);
        }
        session.delete((Object)group);
        MembershipDAOImpl membershipHanler = (MembershipDAOImpl)this.orgService.getMembershipHandler();
        membershipHanler.removeMembershipEntriesOfGroup(group, session);
        session.flush();
        if (broadcast) {
            this.postDelete(group);
        }
        return group;
    }

    public Collection<Group> findGroupByMembership(String userName, String membershipType) throws Exception {
        Session session = this.service_.openSession();
        Query q = session.createQuery(queryFindGroupByMembership).setString("username", userName).setString("membershiptype", membershipType);
        List groups = q.list();
        return groups;
    }

    public Collection<Group> resolveGroupByMembership(String userName, String membershipType) throws Exception {
        Session session = this.service_.openSession();
        Query q = session.createQuery(queryResolveGroupByMembership).setString("username", userName).setString("membershiptype", membershipType);
        List groups = q.list();
        return groups;
    }

    public Group findGroupByName(String groupName) throws Exception {
        Session session = this.service_.openSession();
        Group group = (Group)this.service_.findOne(session, queryFindGroupByName, groupName);
        return group;
    }

    public Group findGroupById(String groupId) throws Exception {
        Session session = this.service_.openSession();
        Group group = (Group)this.service_.findOne(session, queryFindGroupById, groupId);
        return group;
    }

    public Collection<Group> findGroups(Group parent) throws Exception {
        Session session = this.service_.openSession();
        if (parent == null) {
            return session.createQuery(queryFindRootGroups).list();
        }
        return session.createQuery(queryFindGroupByParent).setString("parentid", parent.getId()).list();
    }

    public Collection<Group> findGroupsOfUser(String user) throws Exception {
        Session session = this.service_.openSession();
        return session.createQuery(queryFindGroupsOfUser).setString("username", user).list();
    }

    public Collection<Group> getAllGroups() throws Exception {
        Session session = this.service_.openSession();
        Query q = session.createQuery(queryGetAllGroups);
        List groups = q.list();
        return groups;
    }

    public ListAccess<Group> findGroupsByKeyword(String keyword) throws Exception {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postDelete(group);
        }
    }

    public List<GroupEventListener> getGroupListeners() {
        return Collections.unmodifiableList(this.listeners_);
    }
}

