/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.spi.wsrp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.exoplatform.portal.pom.spi.wsrp.WSRPState;
import org.gatein.common.util.ParameterValidation;
import org.gatein.mop.spi.content.ContentProvider;
import org.gatein.mop.spi.content.StateContainer;

public class WSRPContentProvider
implements ContentProvider<WSRP, WSRPState> {
    public WSRP combine(List<WSRP> wsrpStates) {
        WSRP result = null;
        if (ParameterValidation.existsAndIsNotEmpty(wsrpStates)) {
            Iterator<WSRP> iterator = wsrpStates.iterator();
            while (iterator.hasNext()) {
                WSRP state;
                result = state = iterator.next();
                if (!state.isCloned()) continue;
                return state;
            }
        }
        return result;
    }

    public void setState(StateContainer<WSRPState> container, WSRP state) {
        WSRPState wsrpState = (WSRPState)((Object)container.getState());
        if (wsrpState != null) {
            if (state == null) {
                container.setState(null);
            } else {
                this.setInternalState(wsrpState, state);
            }
        } else if (state != null) {
            wsrpState = (WSRPState)((Object)container.create());
            this.setInternalState(wsrpState, state);
        }
    }

    public WSRP getState(StateContainer<WSRPState> container) {
        WSRPState wsrpState = (WSRPState)((Object)container.getState());
        if (wsrpState != null) {
            return this.getState(wsrpState);
        }
        return null;
    }

    public Class<WSRP> getExternalType() {
        return WSRP.class;
    }

    public Class<WSRPState> getInternalType() {
        return WSRPState.class;
    }

    private void setInternalState(WSRPState persistedState, WSRP updatedState) {
        byte[] bytes = updatedState.getState();
        if (bytes != null && bytes.length > 0) {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            persistedState.setState(is);
        }
        persistedState.setPortletId(updatedState.getPortletId());
        persistedState.setCloned(updatedState.isCloned());
    }

    private WSRP getState(WSRPState state) {
        WSRP wsrp = new WSRP();
        byte[] bytes = Safe.getBytes((InputStream)state.getState());
        wsrp.setState(bytes);
        wsrp.setPortletId(state.getPortletId());
        wsrp.setCloned(state.getCloned());
        return wsrp;
    }
}

