/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.updater;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.service.AsyncCallback;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.SocialServiceContext;
import org.exoplatform.social.common.service.impl.SocialServiceContextImpl;
import org.exoplatform.social.common.service.utils.ConsoleUtils;
import org.exoplatform.social.common.service.utils.ObjectHelper;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProfileEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.streams.SocialChromatticSyncProcessor;
import org.exoplatform.social.core.storage.streams.StreamProcessContext;
import org.exoplatform.social.core.updater.StreamUpgradeProcessor;
import org.exoplatform.social.core.updater.UserActivityStreamUpdaterPlugin;

public class UserActivityStreamMigration
extends AbstractStorage {
    private static final Log LOG = ExoLogger.getLogger(UserActivityStreamUpdaterPlugin.class);
    private static final int BATCH_FLUSH_LIMIT = 10;
    private IdentityStorage identityStorage = null;
    private static AtomicInteger currentNumber = new AtomicInteger(0);

    private IdentityStorage getIdentityStorage() {
        if (this.identityStorage == null) {
            this.identityStorage = (IdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(IdentityStorage.class);
        }
        return this.identityStorage;
    }

    public void upgrade(int limit, int from, int to, String prefix) {
        StringBuffer sb = new StringBuffer().append("SELECT * FROM soc:identitydefinition WHERE ");
        sb.append(JCRProperties.path.getName()).append(" LIKE '").append(this.getProviderRoot().getProviders().get("organization").getPath() + "/" + "%");
        sb.append("' AND NOT ").append(ProfileEntity.deleted.getName()).append(" = ").append("true");
        boolean hasGroup = false;
        if (to - from > 0) {
            sb.append(" AND (");
            hasGroup = true;
        }
        boolean hasOR = false;
        for (int i = from; i <= to; ++i) {
            if (hasOR) {
                sb.append(" OR ");
            }
            String name = prefix + i;
            sb.append(IdentityEntity.remoteId.getName()).append(" = '").append(name).append("'");
            hasOR = true;
        }
        if (hasGroup) {
            sb.append(") ");
        }
        LOG.warn((Object)("SQL : " + sb.toString()));
        NodeIterator it = this.nodes(sb.toString());
        long totalOfIdentity = to - from;
        Identity owner = null;
        Node node = null;
        try {
            while (it.hasNext()) {
                node = (Node)it.next();
                owner = this.getIdentityStorage().findIdentityById(node.getUUID());
                this.doUpgrade(owner, totalOfIdentity, limit);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to migration for Activity Stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(int limit) {
        StringBuffer sb = new StringBuffer().append("SELECT * FROM soc:identitydefinition WHERE ");
        sb.append(JCRProperties.path.getName()).append(" LIKE '").append(this.getProviderRoot().getProviders().get("organization").getPath() + "/" + "%");
        sb.append("' AND NOT ").append(ProfileEntity.deleted.getName()).append(" = ").append("true");
        LOG.warn((Object)("SQL : " + sb.toString()));
        NodeIterator it = this.nodes(sb.toString());
        long totalOfIdentity = it.getSize();
        Identity owner = null;
        Node node = null;
        int batchIndex = 0;
        int offset = 0;
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            while (it.hasNext()) {
                node = (Node)it.next();
                owner = this.getIdentityStorage().findIdentityById(node.getUUID());
                this.doUpgrade(owner, totalOfIdentity, limit);
                ++offset;
                if (++batchIndex != 10) continue;
                LOG.warn((Object)("UPGRAGE SESSION FLUSH: " + offset));
                StorageUtils.persistJCR(true);
                it = this.nodes(sb.toString());
                this._skip((Iterator<?>)it, offset);
                batchIndex = 0;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to migration for Activity Stream.", (Throwable)e);
        }
        finally {
            StorageUtils.persistJCR(false);
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessContext doUpgrade(Identity owner, long total, int limit) {
        SocialServiceContext ctx = SocialServiceContextImpl.getInstance();
        StreamProcessContext processCtx = StreamProcessContext.getIntance(String.format("%s-[%s limit=%s]", StreamProcessContext.UPGRADE_STREAM_PROCESS, owner.getRemoteId(), limit), ctx);
        processCtx.identity(owner).limit(limit).totalProcesses((int)total);
        try {
            this.upgradeProcessor().start((ProcessContext)processCtx);
            this.upgradeProcessor().process((ProcessContext)processCtx);
            this.upgradeProcessor().end((ProcessContext)processCtx);
            this.createAsyncCallback().done((ProcessContext)processCtx);
        }
        catch (Exception e) {
            processCtx.setException(e);
        }
        finally {
            if (processCtx.isFailed()) {
                LOG.warn((Object)"Failed to migration for Activity Stream.", (Throwable)processCtx.getException());
            } else {
                LOG.info((Object)processCtx.getTraceLog());
            }
        }
        return processCtx;
    }

    private SocialChromatticSyncProcessor upgradeProcessor() {
        return new SocialChromatticSyncProcessor(SocialServiceContextImpl.getInstance()){

            @Override
            protected ProcessContext execute(ProcessContext processContext) throws Exception {
                StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)processContext));
                int limit = streamCtx.getLimit();
                StreamUpgradeProcessor.feed(streamCtx.getIdentity()).upgrade(0, limit);
                StreamUpgradeProcessor.connection(streamCtx.getIdentity()).upgrade(0, limit);
                StreamUpgradeProcessor.myspaces(streamCtx.getIdentity()).upgrade(0, limit);
                StreamUpgradeProcessor.user(streamCtx.getIdentity()).upgrade(0, limit);
                return processContext;
            }
        };
    }

    private AsyncCallback createAsyncCallback() {
        return new AsyncCallback(){

            public void done(ProcessContext processContext) {
                int value = currentNumber.incrementAndGet();
                int percent = value * 100 / processContext.getTotalProcesses();
                ConsoleUtils.logProgBar((int)percent);
            }
        };
    }
}

