/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.webui.UISocialGroupSelector;

public class URLUtils {
    private static Log LOG = ExoLogger.getLogger(UISocialGroupSelector.class);
    private static String ROOT_NODE_NAME = "default";

    public static String getCurrentUser() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestPath = "/" + pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null) {
            return null;
        }
        String currentUserName = (String)route.localArgs.get("streamOwnerId");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        try {
            Identity id;
            if (currentUserName != null && (id = idm.getOrCreateIdentity("organization", currentUserName, false)) != null) {
                return currentUserName;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Could not found Identity of user " + currentUserName));
            }
            return null;
        }
        return null;
    }

    public static String getRequestedNode() throws Exception {
        UserNode prevParent;
        UserNode selectedUserNode = Util.getUIPortal().getSelectedUserNode();
        UserNode parent = prevParent = selectedUserNode.getParent();
        boolean isRoot = true;
        while (!ROOT_NODE_NAME.equals(parent.getName())) {
            prevParent = parent;
            parent = prevParent.getParent();
            isRoot = false;
        }
        return isRoot ? selectedUserNode.getName() : prevParent.getName();
    }
}

