/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class LocalHostManager {
    Set localAddresses;
    Set knownGoodNames;
    Set knownBadNames;

    public synchronized void update() throws SocketException {
        HashSet<InetAddress> tmp = new HashSet<InetAddress>();
        Enumeration<NetworkInterface> netintfcs = NetworkInterface.getNetworkInterfaces();
        while (netintfcs.hasMoreElements()) {
            NetworkInterface ni = netintfcs.nextElement();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                tmp.add(addresses.nextElement());
            }
        }
        this.localAddresses = Collections.unmodifiableSet(tmp);
        this.knownGoodNames = new HashSet();
        this.knownBadNames = new HashSet();
    }

    public synchronized Set getLocalAddresses() {
        return this.localAddresses;
    }

    public synchronized boolean isLocalAddress(InetAddress addr) {
        return this.localAddresses.contains(addr);
    }

    public synchronized boolean isLocalHostName(String name) {
        if (this.knownGoodNames.contains(name)) {
            return true;
        }
        if (this.knownGoodNames.contains(name)) {
            return false;
        }
        try {
            InetAddress nameAddr = InetAddress.getByName(name);
            if (this.localAddresses.contains(nameAddr)) {
                this.knownGoodNames.add(name);
                return true;
            }
            this.knownBadNames.add(name);
            return false;
        }
        catch (UnknownHostException e) {
            this.knownBadNames.add(name);
            return false;
        }
    }

    public LocalHostManager() throws SocketException {
        this.update();
    }

    public static void main(String[] argv) {
        try {
            LocalHostManager lhm = new LocalHostManager();
            System.out.println(lhm.getLocalAddresses());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

