/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

@Asynchronous
public class AuthenticationLoginListener
extends Listener<ConversationRegistry, ConversationState> {
    private ExoContainerContext context;

    public AuthenticationLoginListener(ExoContainerContext context) throws Exception {
        this.context = context;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        ConversationState state = (ConversationState)event.getData();
        String userId = state.getIdentity().getUserId();
        ExoContainer container = this.context.getContainer();
        ForumService fservice = (ForumService)container.getComponentInstanceOfType(ForumService.class);
        String masterHost = System.getProperty("tenant.masterhost");
        if (masterHost == null) {
            ConversationState.setCurrent((ConversationState)state);
            fservice.userLogin(userId);
        } else {
            String currentLoginRepo = ((RepositoryService)container.getComponentInstanceOfType(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
            fservice.userLogin(currentLoginRepo, userId);
        }
    }
}

