/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.data;

import java.util.Objects;
import org.exoplatform.forum.common.cache.model.CachedData;
import org.exoplatform.forum.service.ForumLinkData;

public class LinkData
implements CachedData<ForumLinkData> {
    private final String id;
    private final String name;
    private final String path;
    private final String type;
    private final boolean isClosed;
    private final boolean isLock;

    public LinkData(ForumLinkData link) {
        this.id = link.getId();
        this.name = link.getName();
        this.path = link.getPath();
        this.type = link.getType();
        this.isClosed = link.getIsClosed();
        this.isLock = link.getIsLock();
    }

    public ForumLinkData build() {
        ForumLinkData link = new ForumLinkData();
        link.setId(this.id);
        link.setName(this.name);
        link.setPath(this.path);
        link.setType(this.type);
        link.setIsClosed(this.isClosed);
        link.setIsLock(this.isLock);
        return link;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkData linkData = (LinkData)o;
        return this.isClosed == linkData.isClosed && this.isLock == linkData.isLock && Objects.equals(this.id, linkData.id) && Objects.equals(this.name, linkData.name) && Objects.equals(this.path, linkData.path) && Objects.equals(this.type, linkData.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.path, this.type, this.isClosed, this.isLock);
    }
}

