/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.data;

import java.util.Arrays;
import java.util.Objects;
import org.exoplatform.forum.common.cache.model.CachedData;
import org.exoplatform.forum.service.Tag;

public class TagData
implements CachedData<Tag> {
    private final String id;
    private final String name;
    private final String[] userTag;
    private final long useCount;

    public TagData(Tag tag) {
        this.id = tag.getId();
        this.name = tag.getName();
        this.userTag = tag.getUserTag();
        this.useCount = tag.getUseCount();
    }

    public Tag build() {
        Tag tag = new Tag();
        tag.setId(this.id);
        tag.setName(this.name);
        tag.setUserTag(this.userTag);
        tag.setUseCount(this.useCount);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagData tagData = (TagData)o;
        return this.useCount == tagData.useCount && Objects.equals(this.id, tagData.id) && Objects.equals(this.name, tagData.name) && Arrays.equals(this.userTag, tagData.userTag);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.userTag, this.useCount);
    }
}

