/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.transaction.UserTransaction;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.TransactionService;

public class MixinCleanerUpgradePlugin
extends UpgradeProductPlugin {
    public static final String DEFAULT_WORKSPACE_NAME = "social";
    public static final String MIGRATION_STATUS = "migration.status";
    public static final int UPDATE_LAST_NODE_FREQ = 1000;
    private static final int TRANSACTION_TIMEOUT_IN_SECONDS = 86400;
    private static final Log LOG = ExoLogger.getLogger(MixinCleanerUpgradePlugin.class);
    private static final int NODES_IN_ONE_TRANSACTION = 100;
    private final PortalContainer portalContainer;
    private final RepositoryService repositoryService;
    private final TransactionService txService;
    private String workspaceName;
    private long totalCount = 0L;
    private Map<String, List<String>> mixinNames = new HashMap<String, List<String>>();
    private String jcrRootPath;
    private long maxTreatedNodes = 0L;
    private boolean upgradeFinished = false;

    public MixinCleanerUpgradePlugin(PortalContainer portalContainer, RepositoryService repositoryService, TransactionService txService, SettingService settingService, InitParams initParams) {
        super(settingService, initParams);
        ValuesParam mixinsExceptionsValueParam;
        ValueParam maxNodesParam;
        ValuesParam mixinsValueParam;
        ValueParam pathParam;
        this.repositoryService = repositoryService;
        this.txService = txService;
        this.portalContainer = portalContainer;
        ValueParam workspaceValueParam = initParams.getValueParam("workspace");
        if (workspaceValueParam != null) {
            this.workspaceName = workspaceValueParam.getValue();
        }
        if (StringUtils.isBlank((String)this.workspaceName)) {
            this.workspaceName = DEFAULT_WORKSPACE_NAME;
        }
        if ((pathParam = initParams.getValueParam("path")) != null) {
            this.jcrRootPath = pathParam.getValue();
        }
        if (StringUtils.isBlank((String)this.jcrRootPath)) {
            this.jcrRootPath = "/";
        }
        if ((mixinsValueParam = initParams.getValuesParam("mixinsCleanup.includes")) != null) {
            List mixins = mixinsValueParam.getValues();
            for (String mixin : mixins) {
                if (StringUtils.isBlank((String)mixin)) continue;
                this.mixinNames.put(mixin, null);
            }
        }
        if (this.mixinNames.isEmpty()) {
            LOG.warn((Object)"No mixins to cleanup, the mixins list is empty.");
        }
        if ((maxNodesParam = initParams.getValueParam("mixinsCleanup.maxNodes")) != null) {
            try {
                this.maxTreatedNodes = Long.parseLong(maxNodesParam.getValue());
                if (this.maxTreatedNodes < 0L) {
                    throw new IllegalArgumentException("'maxTreatedNodes' parameter should be a positive integer.");
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Parameter '" + maxNodesParam.getName() + "' is not a valid number."), (Throwable)e);
            }
        }
        if ((mixinsExceptionsValueParam = initParams.getValuesParam("mixinsCleanup.excludes")) != null) {
            List mixins = mixinsExceptionsValueParam.getValues();
            for (String mixinException : mixins) {
                String[] mixinExceptionParams = mixinException.split(";");
                String mixinName = mixinExceptionParams[0];
                String typeName = mixinExceptionParams[1];
                if (!this.mixinNames.containsKey(mixinName)) continue;
                List<String> mixinExceptions = this.mixinNames.get(mixinName);
                if (mixinExceptions == null) {
                    mixinExceptions = new ArrayList<String>();
                    this.mixinNames.put(mixinName, mixinExceptions);
                }
                mixinExceptions.add(typeName);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String oldVersion) {
        String migrationStatus = this.getValue(MIGRATION_STATUS);
        return !(!VersionComparator.isAfter((String)newVersion, (String)oldVersion) && !VersionComparator.isSame((String)newVersion, (String)oldVersion) || migrationStatus != null && migrationStatus.equals("Completed"));
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        this.storeValueForPlugin(MIGRATION_STATUS, "0");
        PortalContainer.addInitTask((ServletContext)this.portalContainer.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MixinCleanerUpgradePlugin.this.doMigration();
                    }
                }, MixinCleanerUpgradePlugin.this.getName()).start();
            }
        });
    }

    public boolean isUpgradeFinished() {
        return this.upgradeFinished;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMigration() {
        LOG.info("Start migration, workspace = {}, root path = {}, maxNodes = {}", new Object[]{this.workspaceName, this.jcrRootPath, this.maxTreatedNodes});
        this.totalCount = 0L;
        Session session = null;
        UserTransaction transaction = null;
        try {
            ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
            session = SessionProvider.createSystemProvider().getSession(this.workspaceName, currentRepository);
            ((SessionImpl)session).setTimeout(86400L);
            transaction = this.beginTransaction();
            if (!session.itemExists(this.jcrRootPath)) {
                throw new IllegalStateException("Cannot procced to upgrade, path doesn't exist:" + this.workspaceName + ":" + this.jcrRootPath);
            }
            Node parentNode = (Node)session.getItem(this.jcrRootPath);
            transaction = this.cleanChildrenNodes(parentNode, session, transaction);
            session.save();
            transaction.commit();
            if (this.maxTreatedNodes > 0L && this.totalCount == this.maxTreatedNodes) {
                this.storeValueForPlugin(MIGRATION_STATUS, "" + this.totalCount);
            } else {
                this.storeValueForPlugin(MIGRATION_STATUS, "Completed");
            }
            LOG.info("Migration finished, proceeded nodes count = {}", new Object[]{this.totalCount});
        }
        catch (Exception e) {
            LOG.error((Object)"Migration interrupted because of the following error", (Throwable)e);
            try {
                session.refresh(false);
                transaction.rollback();
            }
            catch (Exception e1) {
                LOG.error((Object)"Error while rolling back transaction", (Throwable)e);
            }
        }
        finally {
            this.upgradeFinished = true;
            if (session != null) {
                session.logout();
            }
        }
    }

    private UserTransaction cleanChildrenNodes(Node parentNode, Session session, UserTransaction transaction) throws Exception {
        NodeIterator nodeIterator = ((NodeImpl)parentNode).getNodesLazily(1);
        while (nodeIterator.hasNext() && (this.maxTreatedNodes == 0L || this.totalCount < this.maxTreatedNodes)) {
            Node node = nodeIterator.nextNode();
            boolean proceeded = false;
            try {
                try {
                    proceeded = this.cleanSingleNodeMixins(node);
                }
                catch (Exception e) {
                    if (node != null) {
                        node.refresh(false);
                    }
                    throw e;
                }
                if (proceeded && this.totalCount > 0L && this.totalCount % 100L == 0L) {
                    transaction = this.commitTransaction(node, session, transaction);
                }
                transaction = this.cleanChildrenNodes(node, session, transaction);
            }
            catch (Exception e) {
                long canceledNodes = this.totalCount % 100L;
                LOG.error((Object)("Rollback '" + canceledNodes + "'  cleaned nodes"), (Throwable)e);
                session.refresh(false);
                transaction.rollback();
                this.totalCount -= canceledNodes;
                transaction = this.beginTransaction();
            }
        }
        return transaction;
    }

    private UserTransaction commitTransaction(Node node, Session session, UserTransaction transaction) throws Exception {
        session.save();
        transaction.commit();
        if (this.totalCount > 0L && this.totalCount % 1000L == 0L) {
            this.storeValueForPlugin(MIGRATION_STATUS, "" + this.totalCount);
        }
        LOG.info("Migration in progress, proceeded nodes count = {}", new Object[]{this.totalCount});
        transaction = this.beginTransaction();
        return transaction;
    }

    private boolean cleanSingleNodeMixins(Node node) throws Exception {
        boolean proceeded = false;
        for (String mixinName : this.mixinNames.keySet()) {
            if (!node.isNodeType(mixinName)) continue;
            if (this.isExceptionalNodeType(node, this.mixinNames.get(mixinName))) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignore node: '{}', nodetype = '{}', remove mixin '{}'", new Object[]{node.getPath(), node.getPrimaryNodeType().getName(), mixinName});
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proceed node: '{}', nodetype = '{}', remove mixin '{}'", new Object[]{node.getPath(), node.getPrimaryNodeType().getName(), mixinName});
            }
            node.removeMixin(mixinName);
            node.save();
            proceeded = true;
        }
        if (proceeded) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proceeded node: '{}', nodetype = '{}'", new Object[]{node.getPath(), node.getPrimaryNodeType().getName()});
            }
            ++this.totalCount;
        }
        return proceeded;
    }

    private boolean isExceptionalNodeType(Node node, List<String> exceptionalNodeTypes) throws RepositoryException {
        if (exceptionalNodeTypes == null) {
            return false;
        }
        for (String nodeType : exceptionalNodeTypes) {
            if (!node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    private UserTransaction beginTransaction() throws Exception {
        UserTransaction transaction = this.txService.getUserTransaction();
        transaction.setTransactionTimeout(86400);
        transaction.begin();
        return transaction;
    }
}

