/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gatein.management.api.model.Model;
import org.gatein.management.api.model.ModelList;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.core.api.model.DmrModel;
import org.gatein.management.core.api.model.DmrModelValue;
import org.jboss.dmr.ModelNode;

class DmrModelList
extends DmrModelValue
implements ModelList {
    DmrModelList(ModelNode value) {
        super(value);
    }

    public ModelValue get(int index) {
        int size;
        int n = size = this.isDefined() ? this.value.asInt() : 0;
        if (size <= index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
        return DmrModelList.asValue(this.value.get(index));
    }

    public <T extends ModelValue> T get(int index, Class<T> valueType) {
        return (T)((ModelValue)valueType.cast(this.get(index)));
    }

    public Model add() {
        return new DmrModel(this.value.add());
    }

    public ModelList add(String value) {
        this.value.add(value);
        return this;
    }

    public ModelList add(int value) {
        this.value.add(value);
        return this;
    }

    public ModelList add(long value) {
        this.value.add(value);
        return this;
    }

    public ModelList add(double value) {
        this.value.add(value);
        return this;
    }

    public ModelList add(BigInteger value) {
        this.value.add(value);
        return this;
    }

    public ModelList add(BigDecimal value) {
        this.value.add(value);
        return this;
    }

    public ModelList add(boolean value) {
        this.value.add(value);
        return this;
    }

    public List<ModelValue> getValues() {
        if (!this.isDefined()) {
            return Collections.emptyList();
        }
        List list = this.value.asList();
        ArrayList<ModelValue> values = new ArrayList<ModelValue>(list.size());
        for (ModelNode value : list) {
            values.add(DmrModelList.asValue(value));
        }
        return values;
    }

    public <T extends ModelValue> List<T> getValues(Class<T> valueType) {
        return this.getValues();
    }

    public Iterator<ModelValue> iterator() {
        return this.getValues().iterator();
    }

    public int size() {
        return this.getValues().size();
    }
}

