/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.binding.impl;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.UserSpaceBinding;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.GroupSpaceBindingStorage;

public class GroupSpaceBindingServiceImpl
implements GroupSpaceBindingService {
    public static final String MEMBER = "member";
    public static final String MANAGER = "manager";
    private GroupSpaceBindingStorage groupSpaceBindingStorage;
    private OrganizationService organizationService;
    private SpaceService spaceService;
    private static final Log LOG = ExoLogger.getLogger(GroupSpaceBindingServiceImpl.class);

    public GroupSpaceBindingServiceImpl(InitParams params, GroupSpaceBindingStorage groupSpaceBindingStorage, OrganizationService organizationService, SpaceService spaceService) throws Exception {
        this.groupSpaceBindingStorage = groupSpaceBindingStorage;
        this.organizationService = organizationService;
        this.spaceService = spaceService;
    }

    @Override
    public List<GroupSpaceBinding> findGroupSpaceBindingsBySpace(String spaceId) {
        LOG.info((Object)("Retrieving group/space bindings for space:" + spaceId));
        return this.groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(spaceId);
    }

    @Override
    public List<GroupSpaceBinding> findGroupSpaceBindingsByGroup(String group) {
        LOG.info((Object)("Retrieving group/space bindings for group:" + group));
        return this.groupSpaceBindingStorage.findGroupSpaceBindingsByGroup(group);
    }

    @Override
    public List<UserSpaceBinding> findUserBindingsBySpace(String spaceId, String userName) {
        LOG.info((Object)("Retrieving user bindings for member:" + userName + "/" + spaceId));
        return this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(spaceId, userName);
    }

    @Override
    public List<UserSpaceBinding> findUserBindingsByUser(String userName) {
        LOG.info((Object)("Retrieving user bindings for member:" + userName));
        return this.groupSpaceBindingStorage.findUserSpaceBindingsByUser(userName);
    }

    @Override
    public List<UserSpaceBinding> findUserBindingsByGroup(String group, String userName) {
        LOG.info((Object)("Retrieving user bindings for user : " + userName + " with group : " + group));
        return this.groupSpaceBindingStorage.findUserSpaceBindingsByGroup(group, userName);
    }

    @Override
    public void saveSpaceBindings(String spaceId, List<GroupSpaceBinding> groupSpaceBindings) {
        LOG.info((Object)("Saving space bindings:" + spaceId));
        try {
            for (GroupSpaceBinding groupSpaceBinding : groupSpaceBindings) {
                User[] users;
                groupSpaceBinding = this.groupSpaceBindingStorage.saveGroupBinding(groupSpaceBinding, groupSpaceBinding.getId() == -1L);
                ListAccess groupMembersAccess = this.organizationService.getUserHandler().findUsersByGroupId(groupSpaceBinding.getGroup());
                for (User user : users = (User[])groupMembersAccess.load(0, groupMembersAccess.getSize())) {
                    LinkedList<UserSpaceBinding> userSpaceBindings = new LinkedList<UserSpaceBinding>();
                    UserSpaceBinding userSpaceBinding = new UserSpaceBinding();
                    userSpaceBinding.setGroupBinding(groupSpaceBinding);
                    userSpaceBinding.setUser(user.getUserName());
                    userSpaceBinding.setSpaceId(spaceId);
                    userSpaceBindings.add(userSpaceBinding);
                    this.saveUserBindings(userSpaceBinding.getUser(), userSpaceBindings);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error Binding" + e));
            throw new RuntimeException("Failed binding space " + spaceId, e);
        }
    }

    @Override
    public void saveUserBindings(String userName, List<UserSpaceBinding> userSpaceBindings) {
        LOG.info((Object)("Saving user bindings for user :" + userName));
        try {
            for (UserSpaceBinding userSpaceBinding : userSpaceBindings) {
                this.bindUserToSpace(userSpaceBinding);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error Binding" + e));
            throw new RuntimeException("Failed binding user " + userName, e);
        }
    }

    @Override
    public void deleteAllSpaceBindingsByGroup(GroupSpaceBinding groupSpaceBinding) {
        LOG.info((Object)("Delete binding group :" + groupSpaceBinding.getGroup() + " for space :" + groupSpaceBinding.getSpaceId()));
        for (UserSpaceBinding userSpaceBinding : this.groupSpaceBindingStorage.findUserAllBindingsbyGroup(groupSpaceBinding.getGroup())) {
            this.deleteUserBinding(userSpaceBinding);
        }
        this.groupSpaceBindingStorage.deleteGroupBinding(groupSpaceBinding.getId());
    }

    @Override
    public void deleteUserBinding(UserSpaceBinding userSpaceBinding) {
        LOG.info((Object)("Delete user binding for member :" + userSpaceBinding.getUser() + "/" + userSpaceBinding.getSpaceId()));
        this.groupSpaceBindingStorage.deleteUserBinding(userSpaceBinding.getId());
        if (!this.groupSpaceBindingStorage.hasUserBindings(userSpaceBinding.getSpaceId(), userSpaceBinding.getUser())) {
            this.spaceService.removeMember(this.spaceService.getSpaceById(userSpaceBinding.getSpaceId()), userSpaceBinding.getUser());
        }
    }

    @Override
    public void deleteAllSpaceBindingsBySpace(String spaceId) {
        LOG.info((Object)("Delete all bindings for space :" + spaceId));
        for (GroupSpaceBinding groupSpaceBinding : this.findGroupSpaceBindingsBySpace(spaceId)) {
            this.deleteAllSpaceBindingsByGroup(groupSpaceBinding);
        }
    }

    @Override
    public void deleteAllUserBindings(String userName) {
        LOG.info((Object)("Delete all user bindings for user :" + userName));
        this.groupSpaceBindingStorage.deleteAllUserBindings(userName);
    }

    @Override
    public boolean hasUserBindings(String spaceId, String userName) {
        LOG.info((Object)("Checking if member has binding :" + userName + " space:" + spaceId));
        return this.groupSpaceBindingStorage.hasUserBindings(spaceId, userName);
    }

    private void bindUserToSpace(UserSpaceBinding userSpaceBinding) throws Exception {
        this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
    }
}

