/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.welcomescreens.service.impl;

import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.welcomescreens.service.TermsAndConditionsService;

public class TermsAndConditionsServiceImpl
implements TermsAndConditionsService {
    private static final Log LOG = ExoLogger.getLogger(TermsAndConditionsServiceImpl.class);
    private static final String TERMS_AND_CONDITIONS = "TermsAndConditions";
    private static final Context CONTEXT = Context.GLOBAL.id("TermsAndConditions");
    private static final Scope SCOPE = Scope.APPLICATION.id("TermsAndConditions");
    private PortalContainer container;
    private SettingService settingService;
    private boolean hasTermsAndConditionsNode = false;

    public TermsAndConditionsServiceImpl(PortalContainer container, SettingService settingService) {
        this.container = container;
        this.settingService = settingService;
    }

    @Override
    public boolean isTermsAndConditionsChecked() {
        boolean isChecked = false;
        if (this.hasTermsAndConditions()) {
            isChecked = true;
        }
        return isChecked;
    }

    @Override
    public void checkTermsAndConditions() {
        if (!this.hasTermsAndConditions()) {
            this.createTermsAndConditions();
        } else {
            LOG.debug((Object)"Terms and conditions: yet checked");
        }
    }

    private void createTermsAndConditions() {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.settingService.set(CONTEXT, SCOPE, TERMS_AND_CONDITIONS, SettingValue.create((Boolean)true));
        }
        catch (Exception e) {
            LOG.error((Object)"Terms and conditions: cannot save information", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private boolean hasTermsAndConditions() {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            if (this.hasTermsAndConditionsNode) {
                return true;
            }
            try {
                SettingValue value = this.settingService.get(CONTEXT, SCOPE, TERMS_AND_CONDITIONS);
                this.hasTermsAndConditionsNode = value != null && value.getValue() != null;
            }
            catch (Exception E) {
                LOG.error((Object)"Terms and conditions: connot get information from store", (Throwable)E);
                this.hasTermsAndConditionsNode = false;
            }
            finally {
                RequestLifeCycle.end();
            }
            return this.hasTermsAndConditionsNode;
        }
        catch (Exception e) {
            LOG.error((Object)"Terms and conditions: cannot check node", (Throwable)e);
            return this.hasTermsAndConditionsNode;
        }
    }
}

