/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.storage.cached;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.perkstore.dao.PerkStoreOrderDAO;
import org.exoplatform.perkstore.dao.PerkStoreProductDAO;
import org.exoplatform.perkstore.exception.PerkStoreException;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.perkstore.storage.PerkStoreStorage;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class PerkStoreCachedStorage
extends PerkStoreStorage {
    private static final int ORDER_ID_CONTEXT = 0;
    private static final int ORDER_TX_HASH_CONTEXT = 1;
    private static final int REFUND_TX_HASH_CONTEXT = 2;
    private FutureExoCache<Long, Product, Object> productFutureCache = null;
    private FutureExoCache<Serializable, ProductOrder, Integer> orderFutureCache = null;

    public PerkStoreCachedStorage(PerkStoreProductDAO perkStoreProductDAO, PerkStoreOrderDAO perkStoreOrderDAO, CacheService cacheService) {
        super(perkStoreProductDAO, perkStoreOrderDAO);
        ExoCache productCache = cacheService.getCacheInstance("perkstore.product");
        Loader<Long, Product, Object> productLoader = new Loader<Long, Product, Object>(){

            public Product retrieve(Object context, Long productId) throws Exception {
                return PerkStoreCachedStorage.super.getProductById(productId);
            }
        };
        this.productFutureCache = new FutureExoCache((Loader)productLoader, productCache);
        ExoCache orderCache = cacheService.getCacheInstance("perkstore.order");
        Loader<Serializable, ProductOrder, Integer> orderLoader = new Loader<Serializable, ProductOrder, Integer>(){

            public ProductOrder retrieve(Integer context, Serializable key) throws Exception {
                if (context == 0) {
                    return PerkStoreCachedStorage.super.getOrderById((Long)key);
                }
                if (context == 1) {
                    return PerkStoreCachedStorage.super.findOrderByTransactionHash((String)((Object)key));
                }
                if (context == 2) {
                    return PerkStoreCachedStorage.super.findOrderByRefundTransactionHash((String)((Object)key));
                }
                throw new IllegalStateException("Unkown context id " + context);
            }
        };
        this.orderFutureCache = new FutureExoCache((Loader)orderLoader, orderCache);
    }

    @Override
    public ProductOrder getOrderById(long orderId) {
        ProductOrder order = (ProductOrder)this.orderFutureCache.get((Object)0, (Object)orderId);
        return this.cloneOrder(order);
    }

    @Override
    public ProductOrder findOrderByTransactionHash(String hash) {
        ProductOrder order = (ProductOrder)this.orderFutureCache.get((Object)1, (Object)hash);
        return this.cloneOrder(order);
    }

    @Override
    public ProductOrder findOrderByRefundTransactionHash(String hash) {
        ProductOrder order = (ProductOrder)this.orderFutureCache.get((Object)2, (Object)hash);
        return this.cloneOrder(order);
    }

    @Override
    public Product getProductById(long productId) {
        Product product = (Product)this.productFutureCache.get(null, (Object)productId);
        if (product == null) {
            return null;
        }
        product = product.clone();
        Utils.refreshProfile(product.getReceiverMarchand());
        return product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProductOrder saveOrder(ProductOrder order) throws PerkStoreException {
        long orderId = order.getId();
        long productId = order.getProductId();
        try {
            ProductOrder productOrder = super.saveOrder(order);
            return productOrder;
        }
        finally {
            this.orderFutureCache.remove((Serializable)Long.valueOf(orderId));
            this.productFutureCache.remove((Serializable)Long.valueOf(productId));
            if (StringUtils.isNotBlank((CharSequence)order.getTransactionHash())) {
                this.orderFutureCache.remove((Serializable)((Object)order.getTransactionHash()));
            }
            if (StringUtils.isNotBlank((CharSequence)order.getRefundTransactionHash())) {
                this.orderFutureCache.remove((Serializable)((Object)order.getRefundTransactionHash()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Product saveProduct(Product product, String username) throws PerkStoreException {
        long productId = product.getId();
        try {
            Product product2 = super.saveProduct(product, username);
            return product2;
        }
        finally {
            this.productFutureCache.remove((Serializable)Long.valueOf(productId));
        }
    }

    private ProductOrder cloneOrder(ProductOrder order) {
        if (order == null) {
            return null;
        }
        order = order.clone();
        Utils.refreshProfile(order.getSender());
        Utils.refreshProfile(order.getReceiver());
        return order;
    }

    public void clearCache() {
        this.orderFutureCache.clear();
        this.productFutureCache.clear();
    }
}

