/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api.cache;

import java.io.Serializable;
import org.gatein.common.util.ParameterValidation;

public final class CacheLevel
implements Serializable {
    public static final CacheLevel FULL = new CacheLevel("FULL");
    public static final CacheLevel PORTLET = new CacheLevel("PORTLET");
    public static final CacheLevel PAGE = new CacheLevel("PAGE");
    private static final long serialVersionUID = -7020875805659724988L;
    private final String name;

    private CacheLevel(String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"CacheLevel name", null);
        this.name = name;
    }

    public final String name() {
        return this.name;
    }

    private Object readResolve() {
        CacheLevel standardCacheLevel = CacheLevel.isStandardCacheLevel(this.name);
        if (standardCacheLevel != null) {
            return standardCacheLevel;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheLevel that = (CacheLevel)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public static CacheLevel create(String name) {
        CacheLevel standardCacheLevel = CacheLevel.isStandardCacheLevel(name);
        if (standardCacheLevel != null) {
            return standardCacheLevel;
        }
        return new CacheLevel(name);
    }

    private static CacheLevel isStandardCacheLevel(String name) {
        if (CacheLevel.FULL.name.equals(name)) {
            return FULL;
        }
        if (CacheLevel.PORTLET.name.equals(name)) {
            return PORTLET;
        }
        if (CacheLevel.PAGE.name.equals(name)) {
            return PAGE;
        }
        return null;
    }
}

