/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.owasp.html.CssSchema;
import org.owasp.html.Handler;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;

public abstract class HTMLSanitizer {
    private static final Pattern COLOR_NAME = Pattern.compile("(?:aqua|black|blue|fuchsia|gray|grey|green|lime|maroon|navy|olive|purple|red|silver|teal|white|yellow)");
    private static final Pattern COLOR_CODE = Pattern.compile("(?:#(?:[0-9a-fA-F]{3}(?:[0-9a-fA-F]{3})?))");
    private static final Pattern NUMBER_OR_PERCENT = Pattern.compile("[0-9]+%?");
    private static final Pattern PARAGRAPH = Pattern.compile("(?:[\\p{L}\\p{N},'\\.\\s\\-_\\(\\)]|&[0-9]{2};)*");
    private static final Pattern HTML_ID = Pattern.compile("[a-zA-Z0-9\\:\\-_\\.]+");
    private static final Pattern HTML_TITLE = Pattern.compile("[\\p{L}\\p{N}\\s\\-_',:\\[\\]!\\./\\\\\\(\\)&]*");
    private static final Pattern HTML_CLASS = Pattern.compile("[a-zA-Z0-9\\s,\\-_]+");
    private static final Pattern ONSITE_URL = Pattern.compile("(?:[\\p{L}\\p{N} \\\\\\.\\#@\\$%\\+&;\\-_~,\\?=/!]+|\\#(\\w)+)");
    private static final Pattern OFFSITE_URL = Pattern.compile("\\s*(?:(?:ht|f)tps?://|mailto:)[\\p{L}\\p{N}][\\p{L}\\p{N} \\p{Zs}\\.\\#@\\$%\\+&;:\\-_~,\\?=/!\\(\\)\\*]*+\\s*");
    private static final Pattern NUMBER = Pattern.compile("[+-]?(?:(?:[0-9]+(?:\\.[0-9]*)?)|\\.[0-9]+)");
    private static final Pattern NAME = Pattern.compile("[a-zA-Z0-9\\-_\\$]+");
    private static final Pattern ALIGN = Pattern.compile("(?i)center|left|right|justify|char");
    private static final Pattern VALIGN = Pattern.compile("(?i)baseline|bottom|middle|top");
    private static final Predicate<String> COLOR_NAME_OR_COLOR_CODE = HTMLSanitizer.matchesEither(COLOR_NAME, COLOR_CODE);
    private static final Predicate<String> ONSITE_OR_OFFSITE_URL = HTMLSanitizer.matchesEither(ONSITE_URL, OFFSITE_URL);
    private static final Pattern HISTORY_BACK = Pattern.compile("(?:javascript:)?\\Qhistory.go(-1)\\E");
    private static final Pattern ONE_CHAR = Pattern.compile(".?", 32);
    private static final Collection<String> CUSTOM_ALLOWED_STYLES = CollectionUtils.union((Collection)CssSchema.DEFAULT.allowedProperties(), Arrays.asList("float", "display", "clear"));
    public static final Function<HtmlStreamEventReceiver, HtmlSanitizer.Policy> POLICY_DEFINITION = new HtmlPolicyBuilder().allowAttributes(new String[]{"id"}).matching(HTML_ID).globally().allowAttributes(new String[]{"class"}).matching(HTML_CLASS).globally().allowAttributes(new String[]{"lang"}).matching(Pattern.compile("[a-zA-Z]{2,20}")).globally().allowAttributes(new String[]{"title"}).matching(HTML_TITLE).globally().allowStyling(CssSchema.withProperties(CUSTOM_ALLOWED_STYLES)).allowAttributes(new String[]{"align"}).matching(ALIGN).onElements(new String[]{"p"}).allowAttributes(new String[]{"for"}).matching(HTML_ID).onElements(new String[]{"label"}).allowAttributes(new String[]{"color"}).matching(COLOR_NAME_OR_COLOR_CODE).onElements(new String[]{"font"}).allowAttributes(new String[]{"face"}).matching(Pattern.compile("[\\w;, \\-]+")).onElements(new String[]{"font"}).allowAttributes(new String[]{"size"}).matching(NUMBER).onElements(new String[]{"font"}).allowAttributes(new String[]{"href"}).matching(ONSITE_OR_OFFSITE_URL).onElements(new String[]{"a"}).allowStandardUrlProtocols().allowAttributes(new String[]{"nohref"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"name", "rel"}).matching(NAME).onElements(new String[]{"a"}).allowAttributes(new String[]{"onfocus", "onblur", "onclick", "onmousedown", "onmouseup"}).matching(HISTORY_BACK).onElements(new String[]{"a"}).requireRelNofollowOnLinks().allowAttributes(new String[]{"src"}).matching(ONSITE_OR_OFFSITE_URL).onElements(new String[]{"img"}).allowAttributes(new String[]{"src"}).matching(ONSITE_OR_OFFSITE_URL).onElements(new String[]{"img"}).allowAttributes(new String[]{"referrerpolicy", "data-plugin-name"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"name"}).matching(NAME).onElements(new String[]{"img"}).allowAttributes(new String[]{"alt"}).matching(PARAGRAPH).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "hspace", "vspace"}).matching(NUMBER).onElements(new String[]{"img"}).allowAttributes(new String[]{"width", "height"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "cellpadding", "cellspacing"}).matching(NUMBER).onElements(new String[]{"table"}).allowAttributes(new String[]{"bgcolor"}).matching(COLOR_NAME_OR_COLOR_CODE).onElements(new String[]{"table"}).allowAttributes(new String[]{"background"}).matching(ONSITE_URL).onElements(new String[]{"table"}).allowAttributes(new String[]{"align"}).matching(ALIGN).onElements(new String[]{"table"}).allowAttributes(new String[]{"noresize"}).matching(Pattern.compile("(?i)noresize")).onElements(new String[]{"table"}).allowAttributes(new String[]{"background"}).matching(ONSITE_URL).onElements(new String[]{"td", "th", "tr"}).allowAttributes(new String[]{"bgcolor"}).matching(COLOR_NAME_OR_COLOR_CODE).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"abbr"}).matching(PARAGRAPH).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"axis", "headers"}).matching(NAME).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"scope"}).matching(Pattern.compile("(?i)(?:row|col)(?:group)?")).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"nowrap"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"height", "width"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"table", "td", "th", "tr", "img"}).allowAttributes(new String[]{"align"}).matching(ALIGN).onElements(new String[]{"thead", "tbody", "tfoot", "img", "td", "th", "tr", "colgroup", "col"}).allowAttributes(new String[]{"valign"}).matching(VALIGN).onElements(new String[]{"thead", "tbody", "tfoot", "td", "th", "tr", "colgroup", "col"}).allowAttributes(new String[]{"charoff"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"td", "th", "tr", "colgroup", "col", "thead", "tbody", "tfoot"}).allowAttributes(new String[]{"char"}).matching(ONE_CHAR).onElements(new String[]{"td", "th", "tr", "colgroup", "col", "thead", "tbody", "tfoot"}).allowAttributes(new String[]{"colspan", "rowspan"}).matching(NUMBER).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"span", "width"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"colgroup", "col"}).allowElements(new String[]{"a", "label", "noscript", "h1", "h2", "h3", "h4", "h5", "h6", "p", "i", "b", "u", "strong", "em", "small", "big", "pre", "code", "cite", "samp", "sub", "sup", "strike", "del", "tt", "center", "blockquote", "hr", "br", "col", "font", "map", "span", "div", "img", "ul", "ol", "li", "dd", "dt", "dl", "tbody", "thead", "tfoot", "table", "td", "th", "tr", "colgroup", "fieldset", "legend", "ins"}).allowElements(new String[]{"wikiimage", "wikilink", "wikimacro"}).allowAttributes(new String[]{"wikiparam"}).globally().toFactory();

    public static String sanitize(String html) throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlStreamRenderer renderer = HtmlStreamRenderer.create((Appendable)sb, (Handler)new Handler<IOException>(){

            public void handle(IOException ex) {
                Throwables.propagate((Throwable)ex);
            }
        }, (Handler)new Handler<String>(){

            public void handle(String x) {
                throw new AssertionError((Object)x);
            }
        });
        HtmlSanitizer.sanitize((String)html, (HtmlSanitizer.Policy)((HtmlSanitizer.Policy)POLICY_DEFINITION.apply((Object)renderer)));
        return sb.toString();
    }

    private static Predicate<String> matchesEither(final Pattern a, final Pattern b) {
        return new Predicate<String>(){

            public boolean apply(String s) {
                return a.matcher(s).matches() || b.matcher(s).matches();
            }
        };
    }
}

