/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.module.ModuleRegistry;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceApplication;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.webui.application.WebuiRequestContext;

public class DefaultSpaceApplicationHandler
implements SpaceApplicationHandler {
    private static final Log LOG = ExoLogger.getLogger(DefaultSpaceApplicationHandler.class);
    public static final String NAME = "classic";
    private static final String TEMPLATE_NAME_PARAM = "templateName";
    public static final String SPACE_TEMPLATE_PAGE_ID = "portal::classic::spacetemplate";
    public static final String APPLICATION_CONTAINER = "Application";
    private static final String GROUP_ID_PREFERENCE = "{groupId}";
    private static final String MODIFIED_GROUP_ID_PREFERENCE = "{modifiedGroupId}";
    private static final String PAGE_NAME_PREFERENCE = "{pageName}";
    private static final String PAGE_URL_PREFERENCE = "{pageUrl}";
    private PortalContainer container = PortalContainer.getInstance();
    private DataStorage dataStorage = null;
    private PageService pageService = null;
    private SpaceService spaceService;
    private ModuleRegistry moduleRegistry;
    private SpaceTemplateService spaceTemplateService;
    private Map<ApplicationCategory, List<org.exoplatform.application.registry.Application>> appStoreCache = null;
    private static List<org.exoplatform.application.registry.Application> appCache = new ArrayList<org.exoplatform.application.registry.Application>();
    private String templateName;

    public DefaultSpaceApplicationHandler(InitParams params, DataStorage dataStorage, PageService pageService, SpaceTemplateService spaceTemplateService) {
        this.dataStorage = dataStorage;
        this.pageService = pageService;
        this.spaceTemplateService = spaceTemplateService;
        this.templateName = params == null ? NAME : params.getValueParam(TEMPLATE_NAME_PARAM).getValue();
    }

    @Override
    public void initApps(Space space, SpaceTemplate spaceTemplate) throws SpaceException {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
            NavigationContext navContext = SpaceUtils.createGroupNavigation(space.getGroupId());
            NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, navContext, Scope.CHILDREN, null);
            SpaceApplication homeApplication = spaceTemplate.getSpaceHomeApplication();
            if (homeApplication == null) {
                throw new IllegalStateException("Could not find space home application for template " + spaceTemplate.getName() == null ? "" : spaceTemplate.getName() + ". Could not init space apps");
            }
            NodeContext<NodeContext<?>> homeNodeCtx = this.createPageNodeFromApplication(navContext, parentNodeCtx, space, homeApplication, null, true);
            SpaceService spaceService = this.getSpaceService();
            List<SpaceApplication> spaceApplications = spaceTemplate.getSpaceApplicationList();
            if (spaceApplications != null) {
                for (SpaceApplication spaceApplication : spaceApplications) {
                    this.createPageNodeFromApplication(navContext, homeNodeCtx, space, spaceApplication, null, false);
                    spaceService.installApplication(space, spaceApplication.getPortletName());
                }
            }
            navService.saveNode(parentNodeCtx, null);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_INIT_APP, (Throwable)e);
        }
    }

    @Override
    public void deInitApp(Space space) throws SpaceException {
        try {
            String groupId = space.getGroupId();
            NavigationContext spaceNavCtx = SpaceUtils.getGroupNavigationContext(groupId);
            if (spaceNavCtx == null) {
                return;
            }
            NodeContext<NodeContext<?>> homeNodeCtx = SpaceUtils.getHomeNodeWithChildren(spaceNavCtx, groupId);
            Iterator iterator = homeNodeCtx.getNodes().iterator();
            while (iterator.hasNext()) {
                NodeContext child;
                NodeContext childNode = child = (NodeContext)iterator.next();
                Page page = this.dataStorage.getPage(childNode.getState().getPageRef().format());
                this.dataStorage.remove(page);
            }
            SpaceUtils.removeGroupNavigation(groupId);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_DEINIT_APP, (Throwable)e);
        }
    }

    @Override
    public void activateApplication(Space space, String appId, String appName) throws SpaceException {
        NavigationContext navContext;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        NodeContext<NodeContext<?>> homeNodeCtx = null;
        try {
            navContext = SpaceUtils.getGroupNavigationContext(space.getGroupId());
            homeNodeCtx = SpaceUtils.getHomeNodeWithChildren(navContext, space.getUrl());
        }
        catch (Exception e) {
            LOG.warn((Object)"space navigation not found.", (Throwable)e);
            return;
        }
        SpaceApplication spaceApplication = null;
        String spaceTemplateName = space.getTemplate();
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(spaceTemplateName);
        if (spaceTemplate == null) {
            throw new IllegalStateException("Space template with name " + spaceTemplateName + " wasn't found");
        }
        for (SpaceApplication application : spaceTemplate.getSpaceApplicationList()) {
            if (!appId.equals(application.getPortletName()) || SpaceUtils.isInstalledApp(space, appId)) continue;
            spaceApplication = application;
        }
        if (spaceApplication == null) {
            spaceApplication = new SpaceApplication();
            spaceApplication.setPortletName(appId);
        }
        this.createPageNodeFromApplication(navContext, homeNodeCtx, space, spaceApplication, appName, false);
        navService.saveNode(homeNodeCtx, null);
    }

    @Override
    public void deactiveApplication(Space space, String appId) throws SpaceException {
        this.deactivateApplicationClassic(space, appId);
    }

    @Override
    public void installApplication(Space space, String appId) throws SpaceException {
    }

    @Override
    public void removeApplication(Space space, String appId, String appName) throws SpaceException {
        this.removeApplicationClassic(space, appId, appName);
    }

    @Override
    public void removeApplications(Space space) throws SpaceException {
        try {
            String[] apps = space.getApp().split(",");
            String[] appPart = null;
            for (int i = 0; i < apps.length; ++i) {
                appPart = apps[i].split(":");
                this.removeApplication(space, appPart[0], appPart[1]);
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATIONS, (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return this.templateName;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String s) {
    }

    private void deactivateApplicationClassic(Space space, String appId) {
    }

    private void removeApplicationClassic(Space space, String appId, String appName) throws SpaceException {
        try {
            PageKey pageRef;
            UserNode spaceUserNode = SpaceUtils.getSpaceUserNode(space);
            UserNode removedNode = spaceUserNode.getChild(appName);
            if (removedNode == null) {
                String spaceTemplateName = space.getTemplate();
                SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(spaceTemplateName);
                if (spaceTemplate == null) {
                    throw new IllegalStateException("Space template with name " + spaceTemplateName + " wasn't found");
                }
                List<SpaceApplication> spaceApplications = spaceTemplate.getSpaceApplicationList();
                for (SpaceApplication spaceApplication : spaceApplications) {
                    if (!appId.equals(spaceApplication.getPortletName())) continue;
                    removedNode = spaceUserNode.getChild(spaceApplication.getUri());
                }
            }
            if (removedNode == null) {
                return;
            }
            spaceUserNode.removeChild(removedNode.getName());
            if (removedNode != null && (pageRef = removedNode.getPageRef()).format() != null && pageRef.format().length() > 0) {
                if (WebuiRequestContext.getCurrentInstance() != null) {
                    UIPortal uiPortal = Util.getUIPortal();
                    uiPortal.setUIPage(pageRef.format(), null);
                }
                this.pageService.destroyPage(pageRef);
            }
            SpaceUtils.getUserPortal().saveNode(spaceUserNode, null);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATION, (Throwable)e);
        }
    }

    private org.exoplatform.application.registry.Application getApplication(List<org.exoplatform.application.registry.Application> apps, String appId) {
        for (org.exoplatform.application.registry.Application app : apps) {
            if (!app.getApplicationName().equals(appId)) continue;
            return app;
        }
        return null;
    }

    private NodeContext<NodeContext<?>> createPageNodeFromApplication(NavigationContext navContext, NodeContext<NodeContext<?>> nodeCtx, Space space, SpaceApplication spaceApplication, String appName, boolean isRoot) throws SpaceException {
        org.exoplatform.application.registry.Application app;
        String appId = spaceApplication.getPortletName();
        String potletFullId = spaceApplication.getPortletApp() + "/" + spaceApplication.getPortletName();
        if (!this.isPortletActive(potletFullId)) {
            return null;
        }
        try {
            app = this.getApplication(space, appId);
        }
        catch (Exception e) {
            if (StringUtils.isBlank((CharSequence)spaceApplication.getPortletApp())) {
                throw new IllegalStateException("An error occurred while getting application '{}' from registry. In fact, the application isn't configured with its application name (WAR webapp name). This may be the cause of the problem", e);
            }
            throw new IllegalStateException("An error occurred while getting application '{}' from registry.", e);
        }
        String contentId = app.getContentId();
        if (contentId == null) {
            contentId = app.getCategoryName() + "/" + app.getApplicationName();
        }
        String appInstanceId = PortalConfig.GROUP_TYPE + "#" + space.getGroupId() + ":/" + contentId + "/" + app.getApplicationName() + System.currentTimeMillis();
        Application<Portlet> portletApplication = this.createPortletApplication(appInstanceId, space, isRoot);
        portletApplication.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
        portletApplication.setShowInfoBar(false);
        String pageTitle = space.getDisplayName() + " - " + app.getDisplayName();
        String pageName = app.getApplicationName();
        if (SpaceUtils.isInstalledApp(space, appId) && appName != null) {
            pageName = appName;
        }
        UserPortalConfigService userPortalConfigService = this.getUserPortalConfigService();
        Page page = null;
        try {
            if (isRoot) {
                page = userPortalConfigService.createPageTemplate("spaceHomePage", PortalConfig.GROUP_TYPE, space.getGroupId());
                this.setPermissionForPage(page.getChildren(), "*:" + space.getGroupId());
            } else {
                page = userPortalConfigService.createPageTemplate("space", PortalConfig.GROUP_TYPE, space.getGroupId());
                this.setPage(space, app, portletApplication, page);
            }
            page.setName(pageName);
            page.setTitle(pageTitle);
            String visibility = space.getVisibility();
            if (visibility.equals("public")) {
                page.setAccessPermissions(new String[]{"Everyone"});
            } else {
                page.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
            }
            page.setEditPermission("manager:" + space.getGroupId());
            SiteKey siteKey = navContext.getKey();
            PageKey pageKey = new PageKey(siteKey, page.getName());
            PageState pageState = new PageState(page.getTitle(), page.getDescription(), page.isShowMaxWindow(), page.getFactoryId(), page.getAccessPermissions() != null ? Arrays.asList(page.getAccessPermissions()) : null, page.getEditPermission(), Arrays.asList(page.getMoveAppsPermissions()), Arrays.asList(page.getMoveContainersPermissions()));
            this.pageService.savePage(new PageContext(pageKey, pageState));
            this.dataStorage.save(page);
            page = this.dataStorage.getPage(page.getPageId());
            PageContext pageContext = this.pageService.loadPage(PageKey.parse((String)page.getPageId()));
            pageContext.update(page);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        if (isRoot) {
            pageName = space.getUrl();
        } else if (spaceApplication.getUri() != null && !spaceApplication.getUri().isEmpty()) {
            pageName = spaceApplication.getUri();
        }
        NodeContext childNodeCtx = nodeCtx.add(null, pageName);
        NodeState.Builder nodeStateBuilder = new NodeState.Builder().icon(spaceApplication.getIcon()).pageRef(PageKey.parse((String)page.getPageId()));
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context != null && !context.getApplicationResourceBundle().containsKey(appId + ".label.name")) {
            nodeStateBuilder.label(app.getDisplayName());
        }
        childNodeCtx.setState(nodeStateBuilder.build());
        return childNodeCtx;
    }

    private org.exoplatform.application.registry.Application getApplication(Space space, String appId) throws SpaceException {
        org.exoplatform.application.registry.Application app = this.getApplication(appCache, appId);
        if (app == null) {
            try {
                if (this.appStoreCache == null) {
                    this.appStoreCache = SpaceUtils.getAppStore(space);
                }
                if ((app = this.getApplication(this.appStoreCache, appId)) == null) {
                    this.appStoreCache = SpaceUtils.getAppStore(space);
                    app = this.getApplication(this.appStoreCache, appId);
                    if (app == null && (app = SpaceUtils.getAppFromPortalContainer(appId)) == null) {
                        throw new Exception("app is null!");
                    }
                }
                appCache.add(app);
            }
            catch (Exception e) {
                throw new SpaceException(SpaceException.Code.UNABLE_TO_LIST_AVAILABLE_APPLICATIONS, (Throwable)e);
            }
        }
        return app;
    }

    private void setPage(Space space, org.exoplatform.application.registry.Application app, Application<Portlet> portletApplication, Page page) {
        ArrayList<ModelObject> pageChilds = page.getChildren();
        Container container = SpaceUtils.findContainerById(pageChilds, APPLICATION_CONTAINER);
        ArrayList children = container.getChildren();
        children.add(portletApplication);
        container.setChildren(children);
        pageChilds = this.setContainerById(pageChilds, container);
        page.setChildren(pageChilds);
        this.setPermissionForPage(page.getChildren(), "*:" + space.getGroupId());
    }

    private org.exoplatform.application.registry.Application getApplication(Map<ApplicationCategory, List<org.exoplatform.application.registry.Application>> appStore, String appId) {
        for (ApplicationCategory category : appStore.keySet()) {
            List appList = category.getApplications();
            for (org.exoplatform.application.registry.Application app : appList) {
                if (!app.getApplicationName().equals(appId)) continue;
                return app;
            }
        }
        return null;
    }

    private void setPermissionForPage(ArrayList<ModelObject> children, String perm) {
        for (ModelObject modelObject : children) {
            if (modelObject instanceof Application) {
                ((Application)modelObject).setAccessPermissions(new String[]{perm});
                continue;
            }
            if (!(modelObject instanceof Container)) continue;
            ((Container)modelObject).setAccessPermissions(new String[]{perm});
            this.setPermissionForPage(((Container)modelObject).getChildren(), perm);
        }
    }

    private ArrayList<ModelObject> setContainerById(ArrayList<ModelObject> childs, Container container) {
        ArrayList<ModelObject> result = childs;
        int index = result.indexOf(container);
        if (index != -1) {
            result.set(index, (ModelObject)container);
        } else {
            for (int i = 0; i < result.size(); ++i) {
                ModelObject obj = result.get(i);
                if (Application.class.isInstance(obj)) continue;
                Container objContainer = (Container)obj;
                ArrayList<ModelObject> tmp = this.setContainerById(objContainer.getChildren(), container);
                objContainer.setChildren(tmp);
                result.set(i, (ModelObject)objContainer);
            }
        }
        return result;
    }

    private Application<Portlet> createPortletApplication(String instanceId, Space space, boolean isRoot) {
        int i0 = instanceId.indexOf("#");
        int i1 = instanceId.indexOf(":/", i0 + 1);
        String ownerType = instanceId.substring(0, i0);
        String ownerId = instanceId.substring(i0 + 1, i1);
        String persistenceid = instanceId.substring(i1 + 2);
        String[] persistenceChunks = Utils.split((String)"/", (String)persistenceid);
        PortletBuilder pb = new PortletBuilder();
        String spaceTemplateName = space.getTemplate();
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(spaceTemplateName);
        if (spaceTemplate == null) {
            throw new IllegalStateException("Space template with name " + spaceTemplateName + " wasn't found");
        }
        List<SpaceApplication> spaceApplicationList = spaceTemplate.getSpaceApplicationList();
        SpaceApplication spaceApplication = null;
        Iterator<SpaceApplication> iterator = spaceApplicationList.iterator();
        while (iterator.hasNext() && spaceApplication == null) {
            SpaceApplication tmpSpaceApplication = iterator.next();
            if (!instanceId.contains(tmpSpaceApplication.getPortletName())) continue;
            spaceApplication = tmpSpaceApplication;
        }
        if (spaceApplication != null && spaceApplication.getPreferences() != null) {
            Set<Map.Entry<String, String>> entrySet = spaceApplication.getPreferences().entrySet();
            try {
                for (Map.Entry entry : entrySet) {
                    pb.add((String)entry.getKey(), this.getSubstituteValueFromPattern(space, spaceApplication, (String)entry.getValue()));
                }
            }
            catch (Exception exception) {
                LOG.warn((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        TransientApplicationState portletState = new TransientApplicationState(persistenceChunks[0] + "/" + persistenceChunks[1], (Object)pb.build(), ownerType, ownerId);
        Application portletApp = Application.createPortletApplication();
        portletApp.setState((ApplicationState)portletState);
        return portletApp;
    }

    private String getSubstituteValueFromPattern(Space space, SpaceApplication spaceApplication, String pattern) {
        if (!pattern.contains("{") || !pattern.contains("}")) {
            return pattern;
        }
        if (pattern.contains(GROUP_ID_PREFERENCE)) {
            pattern = pattern.replace(GROUP_ID_PREFERENCE, space.getGroupId());
        } else if (pattern.contains(MODIFIED_GROUP_ID_PREFERENCE)) {
            String modifiedGroupId = space.getGroupId().replace("/", ".");
            pattern = pattern.replace(MODIFIED_GROUP_ID_PREFERENCE, modifiedGroupId);
        } else if (pattern.contains(PAGE_NAME_PREFERENCE)) {
            pattern = pattern.replace(PAGE_NAME_PREFERENCE, spaceApplication.getAppTitle());
        } else if (pattern.contains(PAGE_URL_PREFERENCE)) {
            pattern = pattern.replace(PAGE_URL_PREFERENCE, spaceApplication.getUri());
        }
        return pattern;
    }

    private UserPortalConfigService getUserPortalConfigService() {
        return (UserPortalConfigService)this.container.getComponentInstanceOfType(UserPortalConfigService.class);
    }

    private SpaceService getSpaceService() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)container.getComponentInstance(SpaceService.class);
        }
        return this.spaceService;
    }

    private boolean isPortletActive(String potletFullId) {
        ModuleRegistry moduleRegistry = this.getModuleRegistry();
        if (moduleRegistry == null) {
            return true;
        }
        return moduleRegistry.isPortletActive(potletFullId);
    }

    private ModuleRegistry getModuleRegistry() {
        if (this.moduleRegistry == null) {
            this.moduleRegistry = (ModuleRegistry)CommonsUtils.getService(ModuleRegistry.class);
        }
        return this.moduleRegistry;
    }
}

