/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.net.URL;
import java.util.Set;
import javax.servlet.ServletContext;
import org.exoplatform.commons.xml.DocumentSource;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.resource.AbstractResourceDeployer;
import org.exoplatform.portal.resource.SkinDependentManager;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.config.xml.SkinConfigParser;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.WebApp;

public class GateInSkinConfigDeployer
extends AbstractResourceDeployer {
    private static final Logger log = LoggerFactory.getLogger(GateInSkinConfigDeployer.class);
    private final SkinService skinService;
    private final String portalContainerName;

    public GateInSkinConfigDeployer(String portalContainerName, SkinService _skinService) {
        this.skinService = _skinService;
        this.portalContainerName = portalContainerName;
    }

    @Override
    protected void add(final WebApp webApp, final URL url) {
        ServletContext scontext = null;
        try {
            scontext = webApp.getServletContext();
            RootContainer.PortalContainerPostInitTask task = new RootContainer.PortalContainerPostInitTask(){

                public void execute(ServletContext scontext, PortalContainer portalContainer) {
                    try {
                        SkinConfigParser.processConfigResource(DocumentSource.create((URL)url), GateInSkinConfigDeployer.this.skinService, scontext);
                    }
                    catch (Exception ex) {
                        log.error((Object)("An error occurs while registering '/WEB-INF/gatein-resources.xml' from the context '" + (scontext == null ? "unknown" : scontext.getServletContextName()) + "'"), (Throwable)ex);
                    }
                    GateInSkinConfigDeployer.this.skinService.registerContext(webApp);
                }
            };
            PortalContainer.addInitTask((ServletContext)scontext, (RootContainer.PortalContainerInitTask)task, (String)this.portalContainerName);
        }
        catch (Exception ex) {
            log.error((Object)("An error occurs while registering '/WEB-INF/gatein-resources.xml' from the context '" + (scontext == null ? "unknown" : scontext.getServletContextName()) + "'"), (Throwable)ex);
        }
    }

    @Override
    protected void remove(WebApp webApp) {
        String contextPath = webApp.getServletContext().getContextPath();
        try {
            this.skinService.removeSkins(SkinDependentManager.getPortalSkins(contextPath));
            this.skinService.removeSkins(SkinDependentManager.getPortletSkins(contextPath));
            Set<String> supportedSkins = SkinDependentManager.getSkinNames(contextPath);
            if (supportedSkins != null) {
                for (String skin : supportedSkins) {
                    if (!SkinDependentManager.skinNameIsRemovable(skin, contextPath)) continue;
                    this.skinService.removeSupportedSkin(skin);
                }
            }
            SkinDependentManager.clearAssociatedSkins(contextPath);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.skinService.unregisterServletContext(webApp);
    }
}

