/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.SocialNetworkService;
import org.gatein.security.oauth.utils.OAuthUtils;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;

public class OAuthLinkAccountFilter
extends AbstractSSOInterceptor {
    private static Logger log = LoggerFactory.getLogger(OAuthLinkAccountFilter.class);
    private SocialNetworkService socialNetworkService;

    protected void initImpl() {
        this.socialNetworkService = (SocialNetworkService)this.getExoContainer().getComponentInstanceOfType(SocialNetworkService.class);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession();
        if (httpRequest.getRemoteUser() == null) {
            chain.doFilter(request, response);
            return;
        }
        OAuthPrincipal oauthPrincipal = (OAuthPrincipal)request.getAttribute("_authenticatedOAuthPrincipal");
        if (oauthPrincipal == null) {
            chain.doFilter(request, response);
            return;
        }
        try {
            this.socialNetworkService.updateOAuthInfo(oauthPrincipal.getOauthProviderType(), httpRequest.getRemoteUser(), oauthPrincipal.getUserName(), oauthPrincipal.getAccessToken());
            session.setAttribute("_linkedOAuthProviderUsernameAttrName", (Object)oauthPrincipal.getOauthProviderType().getFriendlyName());
        }
        catch (OAuthException gtnOauthOAuthException) {
            if (gtnOauthOAuthException.getExceptionCode() == OAuthExceptionCode.DUPLICATE_OAUTH_PROVIDER_USERNAME) {
                session.setAttribute("_oauthExceptionAfterFailedLink", (Object)gtnOauthOAuthException);
            }
            throw gtnOauthOAuthException;
        }
        String urlToRedirect = OAuthUtils.getURLToRedirectAfterLinkAccount((HttpServletRequest)httpRequest, (HttpSession)session);
        if (log.isTraceEnabled()) {
            log.trace((Object)("User profile successfully updated with new userName and accessToken. oauthProvider=" + oauthPrincipal.getOauthProviderType() + ", username=" + httpRequest.getRemoteUser() + ", oauthUsername=" + oauthPrincipal.getUserName()));
            log.trace((Object)("Will redirect user to URL: " + urlToRedirect));
        }
        httpResponse.sendRedirect(httpResponse.encodeRedirectURL(urlToRedirect));
    }
}

