/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.web.linkedin;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.linkedin.LinkedinAccessTokenContext;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.web.OAuthProviderFilter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Verb;

public class LinkedInFilter
extends OAuthProviderFilter<LinkedinAccessTokenContext> {
    private static String URL_CURRENT_PROFILE_USER = "https://api.linkedin.com/v1/people/~:(id,first-name,last-name,email-address,public-profile-url,picture-url,picture-urls::(original))?format=json";

    @Override
    protected OAuthProviderType<LinkedinAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("LINKEDIN", LinkedinAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_linkedinRequestToken");
    }

    @Override
    protected OAuthPrincipal<LinkedinAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<LinkedinAccessTokenContext> interactionState) {
        LinkedinAccessTokenContext accessTokenContext = (LinkedinAccessTokenContext)interactionState.getAccessTokenContext();
        OAuthRequest oauthRequest = new OAuthRequest(Verb.GET, URL_CURRENT_PROFILE_USER);
        accessTokenContext.oauthService.signRequest(accessTokenContext.accessToken, oauthRequest);
        Response oauthResponse = oauthRequest.send();
        String body = oauthResponse.getBody();
        try {
            JSONArray arr;
            JSONObject json = new JSONObject(body);
            String id = json.getString("id");
            String firstName = json.getString("firstName");
            String lastName = json.getString("lastName");
            String displayName = firstName + " " + lastName;
            String email = json.getString("emailAddress");
            String avatar = json.optString("pictureUrl");
            JSONObject profilePictures = json.optJSONObject("pictureUrls");
            if (profilePictures != null && (arr = profilePictures.optJSONArray("values")) != null && arr.length() > 0) {
                avatar = arr.getString(0);
            }
            OAuthPrincipal principal = new OAuthPrincipal(id, firstName, lastName, displayName, email, avatar, (AccessTokenContext)accessTokenContext, this.getOAuthProvider());
            return principal;
        }
        catch (JSONException ex) {
            throw new OAuthException(OAuthExceptionCode.LINKEDIN_ERROR, "Error when obtaining user", (Throwable)ex);
        }
    }
}

