/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.cache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.api.settings.data.SettingContext;
import org.exoplatform.commons.api.settings.data.SettingKey;
import org.exoplatform.commons.api.settings.data.SettingScope;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.cache.future.Loader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.settings.cache.NullSettingValue;
import org.exoplatform.settings.cache.selector.SettingCacheSelector;
import org.exoplatform.settings.jpa.JPASettingServiceImpl;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class CacheSettingServiceImpl
implements SettingService {
    private static final Log LOG = ExoLogger.getLogger(CacheSettingServiceImpl.class);
    private static final String SETTING_CACHING_NAME = "commons.SettingService";
    protected ExoCache<SettingKey, SettingValue> settingCache;
    protected FutureExoCache<SettingKey, SettingValue, SettingService> futureExoCache;
    private static final Logger log = LoggerFactory.getLogger(CacheSettingServiceImpl.class);
    private final SettingService service;

    public CacheSettingServiceImpl(JPASettingServiceImpl service, CacheService cacheService) {
        this.settingCache = cacheService.getCacheInstance(SETTING_CACHING_NAME);
        Loader<SettingKey, SettingValue, SettingService> loader = new Loader<SettingKey, SettingValue, SettingService>(){

            public SettingValue retrieve(SettingService service, SettingKey key) throws Exception {
                NullSettingValue settingValue = service.get(key.getContext(), key.getScope(), key.getKey());
                if (settingValue == null) {
                    settingValue = NullSettingValue.getInstance();
                }
                return settingValue;
            }
        };
        this.futureExoCache = new FutureExoCache((Loader)loader, this.settingCache);
        this.service = service;
    }

    @Override
    public void set(Context context, Scope scope, String key, SettingValue<?> value) {
        SettingKey settingKey = new SettingKey(context, scope, key);
        this.settingCache.put((Serializable)settingKey, value);
        this.service.set(context, scope, key, value);
    }

    @Override
    public SettingValue<?> get(Context context, Scope scope, String key) {
        try {
            SettingValue settingValue = (SettingValue)this.futureExoCache.get((Object)this.service, (Object)new SettingKey(context, scope, key));
            if (settingValue == NullSettingValue.getInstance() || settingValue.getValue() == null) {
                return null;
            }
            return settingValue;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)"Exception raising when getting setting value ", (Throwable)e);
            } else if (context != null) {
                LOG.warn((Object)("Exception raising when getting setting value associated to the key " + key + " and the context " + context.getName()));
            } else {
                LOG.warn((Object)"Can't get setting value. The context is null");
            }
            return null;
        }
    }

    @Override
    public void remove(Context context, Scope scope, String key) {
        SettingKey settingKey = new SettingKey(context, scope, key);
        this.settingCache.remove((Serializable)settingKey);
        this.service.remove(context, scope, key);
    }

    @Override
    public void remove(Context context, Scope scope) {
        SettingScope settingScope = new SettingScope(context, scope);
        try {
            this.settingCache.select((CachedObjectSelector)new SettingCacheSelector(settingScope));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot get setting cache", (Throwable)e);
        }
        this.service.remove(context, scope);
    }

    @Override
    public void remove(Context context) {
        SettingContext settingContext = new SettingContext(context);
        try {
            this.settingCache.select((CachedObjectSelector)new SettingCacheSelector(settingContext));
        }
        catch (Exception e) {
            LOG.error((Object)"cannot get setting context", (Throwable)e);
        }
        this.service.remove(context);
    }

    @Override
    public long countContextsByType(String contextType) {
        return this.service.countContextsByType(contextType);
    }

    @Override
    public List<String> getContextNamesByType(String contextType, int offset, int limit) {
        return this.service.getContextNamesByType(contextType, offset, limit);
    }

    @Override
    public Map<Scope, Map<String, SettingValue<String>>> getSettingsByContext(Context context) {
        return this.service.getSettingsByContext(context);
    }

    @Override
    public List<Context> getContextsByTypeAndScopeAndSettingName(String contextType, String scopeType, String scopeName, String settingName, int offset, int limit) {
        return this.service.getContextsByTypeAndScopeAndSettingName(contextType, scopeType, scopeName, settingName, offset, limit);
    }

    @Override
    public Set<String> getEmptyContextsByTypeAndScopeAndSettingName(String contextType, String scopeType, String scopeName, String settingName, int offset, int limit) {
        return this.service.getEmptyContextsByTypeAndScopeAndSettingName(contextType, scopeType, scopeName, settingName, offset, limit);
    }

    @Override
    public void save(Context context) {
        this.service.save(context);
    }

    @Override
    public Map<String, SettingValue> getSettingsByContextAndScope(String contextType, String contextName, String scopeType, String scopeName) {
        return this.service.getSettingsByContextAndScope(contextType, contextName, scopeType, scopeName);
    }
}

