/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.binding.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gatein.management.api.binding.BindingException;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.model.ModelValue;
import org.gatein.management.core.api.model.DmrModelValue;

public class ModelValueMarshaller
implements Marshaller<ModelValue> {
    public static final ModelValueMarshaller INSTANCE = new ModelValueMarshaller();

    public void marshal(ModelValue value, OutputStream outputStream, boolean pretty) throws BindingException {
        try {
            value.toJsonStream(outputStream, pretty);
        }
        catch (IOException e) {
            throw new BindingException("Could not write ModelValue " + value + " to output stream.", (Throwable)e);
        }
    }

    public ModelValue unmarshal(InputStream inputStream) throws BindingException {
        try {
            return DmrModelValue.readFromJsonStream(inputStream);
        }
        catch (IOException e) {
            throw new BindingException("Could not read ModelValue from JSON stream.", (Throwable)e);
        }
    }
}

