/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.job;

import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.reward.service.RewardReportService;
import org.exoplatform.wallet.utils.RewardUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class RewardCurrentPeriodStatusUpdaterJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(RewardCurrentPeriodStatusUpdaterJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private RewardReportService rewardReportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            RewardSettings rewardSettings = RewardUtils.getRewardSettings();
            if (rewardSettings == null) {
                return;
            }
            RewardPeriodType periodType = rewardSettings.getPeriodType();
            if (periodType == null) {
                return;
            }
            List rewardPeriods = this.getRewardReportService().getRewardPeriodsNotSent();
            boolean currentPeriodSaved = false;
            long currentTimeInSeconds = System.currentTimeMillis() / 1000L;
            if (rewardPeriods != null && !rewardPeriods.isEmpty()) {
                for (RewardPeriod rewardPeriod : rewardPeriods) {
                    if (periodType != rewardPeriod.getRewardPeriodType()) continue;
                    LOG.info("Compute rewards for period from {} to {}", new Object[]{rewardPeriod.getStartDateFormatted("en"), rewardPeriod.getEndDateFormatted("en")});
                    long startDateInSeconds = rewardPeriod.getStartDateInSeconds();
                    RewardReport rewardReport = this.getRewardReportService().getRewardReport(startDateInSeconds);
                    if (rewardReport == null) continue;
                    rewardReport = this.getRewardReportService().computeRewards(startDateInSeconds);
                    currentPeriodSaved = currentPeriodSaved || currentTimeInSeconds >= rewardPeriod.getStartDateInSeconds() && currentTimeInSeconds < rewardPeriod.getEndDateInSeconds();
                    this.getRewardReportService().saveRewardReport(rewardReport);
                }
            }
            if (!currentPeriodSaved) {
                RewardReport rewardReport = this.getRewardReportService().computeRewards(currentTimeInSeconds);
                this.getRewardReportService().saveRewardReport(rewardReport);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending rewards", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private RewardReportService getRewardReportService() {
        if (this.rewardReportService == null) {
            this.rewardReportService = (RewardReportService)CommonsUtils.getService(RewardReportService.class);
        }
        return this.rewardReportService;
    }
}

