/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.job;

import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.reward.service.RewardReportService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class RewardStatusVerifierJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(RewardStatusVerifierJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private RewardReportService rewardReportService;
    private ListenerService listenerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            List rewardPeriodsInProgress = this.getRewardReportService().getRewardPeriodsInProgress();
            if (rewardPeriodsInProgress != null && !rewardPeriodsInProgress.isEmpty()) {
                Iterator rewardPeriodsIterator = rewardPeriodsInProgress.iterator();
                while (rewardPeriodsIterator.hasNext()) {
                    RewardPeriod rewardPeriod = (RewardPeriod)rewardPeriodsIterator.next();
                    RewardReport rewardReport = this.getRewardReportService().computeRewards(rewardPeriod.getStartDateInSeconds());
                    if (rewardReport == null) continue;
                    if (rewardReport.isCompletelyProceeded()) {
                        LOG.debug("Rewards sent successfully for period {}: wallets to reward = {} ,transactions = {} , success = {}, failed = {}, pending = {}, completed = {}", new Object[]{rewardPeriod.getStartDateInSeconds(), rewardReport.getValidRewardCount(), rewardReport.getTransactionsCount(), rewardReport.getSuccessTransactionCount(), rewardReport.getFailedTransactionCount(), rewardReport.getPendingTransactionCount(), rewardReport.isCompletelyProceeded()});
                        this.getListenerService().broadcast("exo.wallet.reward.report.success", (Object)rewardReport, null);
                        rewardPeriodsIterator.remove();
                    } else {
                        LOG.debug("Reward not completed for period {}: wallets to reward = {} ,transactions = {} , success = {}, failed = {}, pending = {}, completed = {}", new Object[]{rewardPeriod.getStartDateInSeconds(), rewardReport.getValidRewardCount(), rewardReport.getTransactionsCount(), rewardReport.getSuccessTransactionCount(), rewardReport.getFailedTransactionCount(), rewardReport.getPendingTransactionCount(), rewardReport.isCompletelyProceeded()});
                    }
                    this.getRewardReportService().saveRewardReport(rewardReport);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending rewards", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private RewardReportService getRewardReportService() {
        if (this.rewardReportService == null) {
            this.rewardReportService = (RewardReportService)CommonsUtils.getService(RewardReportService.class);
        }
        return this.rewardReportService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

