/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.PDFXrefStreamParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.persistence.util.COSObjectKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFParser
extends BaseParser {
    private static final Log LOG = LogFactory.getLog(PDFParser.class);
    private static final int SPACE_BYTE = 32;
    private static final String PDF_HEADER = "%PDF-";
    private static final String FDF_HEADER = "%FDF-";
    protected boolean isFDFDocment = false;
    private static final String PDF_DEFAULT_VERSION = "1.4";
    private static final String FDF_DEFAULT_VERSION = "1.0";
    private List<ConflictObj> conflictList = new ArrayList<ConflictObj>();
    private final HashSet<COSStream> streamLengthCheckSet = new HashSet();
    protected XrefTrailerResolver xrefTrailerResolver = new XrefTrailerResolver();
    private File tempDirectory = null;
    private RandomAccess raf = null;

    public PDFParser(InputStream input) throws IOException {
        this(input, null, FORCE_PARSING);
    }

    public PDFParser(InputStream input, RandomAccess rafi) throws IOException {
        this(input, rafi, FORCE_PARSING);
    }

    public PDFParser(InputStream input, RandomAccess rafi, boolean force) throws IOException {
        super(input, force);
        this.raf = rafi;
    }

    public void setTempDirectory(File tmpDir) {
        this.tempDirectory = tmpDir;
    }

    protected boolean isContinueOnError(Exception e) {
        return this.forceParsing;
    }

    public void parse() throws IOException {
        try {
            try {
                this.document = this.raf == null ? (this.tempDirectory != null ? new COSDocument(this.tempDirectory) : new COSDocument()) : new COSDocument(this.raf);
                this.setDocument(this.document);
                this.parseHeader();
                this.skipToNextObj();
                boolean wasLastParsedObjectEOF = false;
                while (!this.pdfSource.isEOF()) {
                    try {
                        wasLastParsedObjectEOF |= this.parseObject();
                    }
                    catch (IOException e) {
                        if (wasLastParsedObjectEOF) break;
                        if (this.isContinueOnError(e)) {
                            LOG.warn((Object)"Parsing Error, Skipping Object", (Throwable)e);
                            this.skipSpaces();
                            long lastOffset = this.pdfSource.getOffset();
                            this.skipToNextObj();
                            if (lastOffset == this.pdfSource.getOffset()) {
                                this.readStringNumber();
                                this.skipToNextObj();
                            }
                        }
                        throw e;
                    }
                    this.skipSpaces();
                }
                this.xrefTrailerResolver.setStartxref(this.document.getStartXref());
                this.document.setTrailer(this.xrefTrailerResolver.getTrailer());
                this.document.addXRefTable(this.xrefTrailerResolver.getXrefTable());
                this.fixStreamsLength();
                if (!this.document.isEncrypted()) {
                    this.document.dereferenceObjectStreams();
                } else {
                    LOG.info((Object)"Document is encrypted");
                }
                ConflictObj.resolveConflicts(this.document, this.conflictList);
            }
            catch (Throwable t) {
                if (this.document != null) {
                    this.document.close();
                    this.document = null;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new WrappedIOException(t);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.pdfSource.close();
            throw throwable;
        }
        this.pdfSource.close();
    }

    private void fixStreamsLength() throws IOException {
        for (COSObject obj : this.document.getObjects()) {
            long filteredLengthWritten;
            COSStream stream;
            long filteredLength;
            if (!(obj.getObject() instanceof COSStream) || !this.streamLengthCheckSet.contains((COSStream)obj.getObject()) || Math.abs((filteredLength = (stream = (COSStream)obj.getObject()).getFilteredLength()) - (filteredLengthWritten = stream.getFilteredLengthWritten())) <= 2L) continue;
            LOG.warn((Object)("/Length of " + obj + " corrected from " + filteredLength + " to " + filteredLengthWritten));
            stream.setLong(COSName.LENGTH, filteredLengthWritten);
            stream.setFilteredLength(filteredLengthWritten);
        }
    }

    private void skipToNextObj() throws IOException {
        int l;
        byte[] b = new byte[16];
        Pattern p = Pattern.compile("\\d+\\s+\\d+\\s+obj.*", 32);
        while (!this.pdfSource.isEOF() && (l = this.pdfSource.read(b)) >= 1) {
            String s = new String(b, "US-ASCII");
            if (s.startsWith("trailer") || s.startsWith("xref") || s.startsWith("startxref") || s.startsWith("stream") || p.matcher(s).matches()) {
                this.pdfSource.unread(b);
                break;
            }
            this.pdfSource.unread(b, 1, l - 1);
        }
    }

    protected void parseHeader() throws IOException {
        String headerGarbage;
        String header = this.readLine();
        if (!header.contains(PDF_HEADER) && !header.contains(FDF_HEADER)) {
            header = this.readLine();
            while (!(header.contains(PDF_HEADER) || header.contains(FDF_HEADER) || header.length() > 0 && Character.isDigit(header.charAt(0)))) {
                header = this.readLine();
            }
        }
        if (header.indexOf(PDF_HEADER) == -1 && header.indexOf(FDF_HEADER) == -1) {
            throw new IOException("Error: Header doesn't contain versioninfo");
        }
        int headerStart = header.indexOf(PDF_HEADER);
        if (headerStart == -1) {
            headerStart = header.indexOf(FDF_HEADER);
        }
        if (headerStart > 0) {
            header = header.substring(headerStart, header.length());
        }
        if (header.startsWith(PDF_HEADER)) {
            if (!header.matches("%PDF-\\d.\\d")) {
                if (header.length() < PDF_HEADER.length() + 3) {
                    header = "%PDF-1.4";
                    LOG.debug((Object)"No pdf version found, set to 1.4 as default.");
                } else {
                    headerGarbage = header.substring(PDF_HEADER.length() + 3, header.length()) + "\n";
                    header = header.substring(0, PDF_HEADER.length() + 3);
                    this.pdfSource.unread(headerGarbage.getBytes("ISO-8859-1"));
                }
            }
        } else {
            this.isFDFDocment = true;
            if (!header.matches("%FDF-\\d.\\d")) {
                if (header.length() < FDF_HEADER.length() + 3) {
                    header = "%FDF-1.0";
                    LOG.debug((Object)"No fdf version found, set to 1.0 as default.");
                } else {
                    headerGarbage = header.substring(FDF_HEADER.length() + 3, header.length()) + "\n";
                    header = header.substring(0, FDF_HEADER.length() + 3);
                    this.pdfSource.unread(headerGarbage.getBytes("ISO-8859-1"));
                }
            }
        }
        this.document.setHeaderString(header);
        try {
            if (header.startsWith(PDF_HEADER)) {
                float pdfVersion = Float.parseFloat(header.substring(PDF_HEADER.length(), Math.min(header.length(), PDF_HEADER.length() + 3)));
                this.document.setVersion(pdfVersion);
            } else {
                float pdfVersion = Float.parseFloat(header.substring(FDF_HEADER.length(), Math.min(header.length(), FDF_HEADER.length() + 3)));
                this.document.setVersion(pdfVersion);
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Error getting pdf version:" + e);
        }
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    public PDDocument getPDDocument() throws IOException {
        return new PDDocument(this.getDocument(), this);
    }

    public FDFDocument getFDFDocument() throws IOException {
        return new FDFDocument(this.getDocument());
    }

    private boolean parseObject() throws IOException {
        long currentObjByteOffset = this.pdfSource.getOffset();
        boolean isEndOfFile = false;
        this.skipSpaces();
        char peekedChar = (char)this.pdfSource.peek();
        while (peekedChar == 'e') {
            this.readString();
            this.skipSpaces();
            currentObjByteOffset = this.pdfSource.getOffset();
            peekedChar = (char)this.pdfSource.peek();
        }
        if (!this.pdfSource.isEOF()) {
            if (peekedChar == 'x') {
                this.parseXrefTable(currentObjByteOffset);
            } else if (peekedChar == 't' || peekedChar == 's') {
                if (peekedChar == 't') {
                    this.parseTrailer();
                    peekedChar = (char)this.pdfSource.peek();
                }
                if (peekedChar == 's') {
                    this.parseStartXref();
                    while (this.isWhitespace(this.pdfSource.peek()) && !this.pdfSource.isEOF()) {
                        this.pdfSource.read();
                    }
                    String eof = "";
                    if (!this.pdfSource.isEOF()) {
                        eof = this.readLine();
                    }
                    if (!"%%EOF".equals(eof)) {
                        if (eof.startsWith("%%EOF")) {
                            this.pdfSource.unread(32);
                            this.pdfSource.unread(eof.substring(5).getBytes("ISO-8859-1"));
                        } else {
                            LOG.warn((Object)("expected='%%EOF' actual='" + eof + "'"));
                            if (!this.pdfSource.isEOF()) {
                                this.pdfSource.unread(32);
                                this.pdfSource.unread(eof.getBytes("ISO-8859-1"));
                            }
                        }
                    }
                    isEndOfFile = true;
                }
            } else {
                COSObjectKey key;
                COSObject pdfObject;
                int genNum;
                long number = -1L;
                boolean missingObjectNumber = false;
                try {
                    char peeked = (char)this.pdfSource.peek();
                    if (peeked == '<') {
                        missingObjectNumber = true;
                    } else {
                        number = this.readObjectNumber();
                    }
                }
                catch (IOException e) {
                    number = this.readObjectNumber();
                }
                if (!missingObjectNumber) {
                    this.skipSpaces();
                    genNum = this.readGenerationNumber();
                    String objectKey = this.readString(3);
                    if (!(objectKey.equals("obj") || this.isContinueOnError(null) && objectKey.equals("o"))) {
                        throw new IOException("expected='obj' actual='" + objectKey + "' " + this.pdfSource);
                    }
                } else {
                    number = -1L;
                    genNum = -1;
                }
                this.skipSpaces();
                COSBase pb = this.parseDirObject();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    this.pdfSource.unread(32);
                    if (pb instanceof COSDictionary) {
                        pb = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile());
                        COSStream strmObj = (COSStream)pb;
                        COSBase streamLength = strmObj.getItem(COSName.LENGTH);
                        int length = -1;
                        if (streamLength instanceof COSNumber) {
                            length = ((COSNumber)streamLength).intValue();
                        }
                        if (length == -1) {
                            this.streamLengthCheckSet.add(strmObj);
                        }
                        if (COSName.XREF.equals(strmObj.getItem(COSName.TYPE))) {
                            this.parseXrefStream(strmObj, currentObjByteOffset);
                        }
                    } else {
                        throw new IOException("stream not preceded by dictionary");
                    }
                    this.skipSpaces();
                    endObjectKey = this.readLine();
                }
                if ((pdfObject = this.document.getObjectFromPool(key = new COSObjectKey(number, genNum))).getObject() == null) {
                    pdfObject.setObject(pb);
                } else {
                    this.addObjectToConflicts(currentObjByteOffset, key, pb);
                }
                if (!endObjectKey.equals("endobj")) {
                    if (endObjectKey.startsWith("endobj")) {
                        this.pdfSource.unread(32);
                        this.pdfSource.unread(endObjectKey.substring(6).getBytes("ISO-8859-1"));
                    } else if (endObjectKey.trim().endsWith("endobj")) {
                        LOG.warn((Object)("expected='endobj' actual='" + endObjectKey + "' "));
                    } else if (!this.pdfSource.isEOF()) {
                        this.pdfSource.unread(32);
                        this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    }
                }
                this.skipSpaces();
            }
        }
        return isEndOfFile;
    }

    private void addObjectToConflicts(long offset, COSObjectKey key, COSBase pb) throws IOException {
        COSObject obj = new COSObject(null);
        obj.setObjectNumber(COSInteger.get(key.getNumber()));
        obj.setGenerationNumber(COSInteger.get(key.getGeneration()));
        obj.setObject(pb);
        ConflictObj conflictObj = new ConflictObj(offset, key, obj);
        this.conflictList.add(conflictObj);
    }

    protected boolean parseStartXref() throws IOException {
        if (this.pdfSource.peek() != 115) {
            return false;
        }
        String startXRef = this.readString();
        if (!startXRef.trim().equals("startxref")) {
            return false;
        }
        this.skipSpaces();
        this.getDocument().setStartXref(this.readLong());
        return true;
    }

    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        char c;
        if (this.pdfSource.peek() != 120) {
            return false;
        }
        String xref = this.readString();
        if (!xref.trim().equals("xref")) {
            return false;
        }
        String str = this.readString();
        byte[] b = str.getBytes("ISO-8859-1");
        this.pdfSource.unread(b, 0, b.length);
        this.xrefTrailerResolver.nextXrefObj(startByteOffset);
        if (str.startsWith("trailer")) {
            LOG.warn((Object)"skipping empty xref table");
            return false;
        }
        do {
            long currObjID = this.readObjectNumber();
            long count = this.readLong();
            this.skipSpaces();
            int i = 0;
            while ((long)i < count && !this.pdfSource.isEOF() && !this.isEndOfName((char)this.pdfSource.peek()) && this.pdfSource.peek() != 116) {
                String currentLine = this.readLine();
                String[] splitString = currentLine.split("\\s");
                if (splitString.length < 3) {
                    LOG.warn((Object)("invalid xref line: " + currentLine));
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        long currOffset = Long.parseLong(splitString[0]);
                        int currGenID = Integer.parseInt(splitString[1]);
                        COSObjectKey objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(e.getMessage());
                    }
                } else if (!splitString[2].equals("f")) {
                    throw new IOException("Corrupt XRefTable Entry - ObjID:" + currObjID);
                }
                ++currObjID;
                this.skipSpaces();
                ++i;
            }
            this.skipSpaces();
        } while ((c = (char)this.pdfSource.peek()) >= '0' && c <= '9');
        return true;
    }

    protected boolean parseTrailer() throws IOException {
        if (this.pdfSource.peek() != 116) {
            return false;
        }
        String nextLine = this.readLine();
        if (!nextLine.trim().equals("trailer")) {
            if (nextLine.startsWith("trailer")) {
                byte[] b = nextLine.getBytes("ISO-8859-1");
                int len = "trailer".length();
                this.pdfSource.unread(10);
                this.pdfSource.unread(b, len, b.length - len);
            } else {
                return false;
            }
        }
        this.skipSpaces();
        COSDictionary parsedTrailer = this.parseCOSDictionary();
        this.xrefTrailerResolver.setTrailer(parsedTrailer);
        this.readVersionInTrailer(parsedTrailer);
        this.skipSpaces();
        return true;
    }

    protected void readVersionInTrailer(COSDictionary parsedTrailer) {
        COSObject root = (COSObject)parsedTrailer.getItem(COSName.ROOT);
        if (root != null) {
            COSBase item = root.getItem(COSName.VERSION);
            if (item instanceof COSName) {
                COSName version = (COSName)item;
                float trailerVersion = Float.valueOf(version.getName()).floatValue();
                if (trailerVersion > this.document.getVersion()) {
                    this.document.setVersion(trailerVersion);
                }
            } else if (item != null) {
                LOG.warn((Object)("Incorrect /Version entry is ignored: " + item));
            }
        }
    }

    public void parseXrefStream(COSStream stream, long objByteOffset) throws IOException {
        this.parseXrefStream(stream, objByteOffset, true);
    }

    public void parseXrefStream(COSStream stream, long objByteOffset, boolean isStandalone) throws IOException {
        if (isStandalone) {
            this.xrefTrailerResolver.nextXrefObj(objByteOffset);
            this.xrefTrailerResolver.setTrailer(stream);
        }
        PDFXrefStreamParser parser = new PDFXrefStreamParser(stream, this.document, this.forceParsing, this.xrefTrailerResolver);
        parser.parse();
    }

    private static boolean tolerantConflicResolver(Collection<Long> values, long offset, int tolerance) {
        if (values.contains(offset)) {
            return true;
        }
        for (Long integer : values) {
            if (Math.abs(integer - offset) > (long)tolerance) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearResources() {
        super.clearResources();
        if (this.conflictList != null) {
            this.conflictList.clear();
            this.conflictList = null;
        }
        if (this.xrefTrailerResolver != null) {
            this.xrefTrailerResolver.clearResources();
            this.xrefTrailerResolver = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConflictObj {
        private final long offset;
        private final COSObjectKey objectKey;
        private final COSObject object;

        ConflictObj(long offsetValue, COSObjectKey key, COSObject pdfObject) {
            this.offset = offsetValue;
            this.objectKey = key;
            this.object = pdfObject;
        }

        public String toString() {
            return "Object(" + this.offset + ", " + this.objectKey + ")";
        }

        private static void resolveConflicts(COSDocument document, List<ConflictObj> conflictList) throws IOException {
            Iterator<ConflictObj> conflicts = conflictList.iterator();
            if (conflicts.hasNext()) {
                Collection<Long> values = document.getXrefTable().values();
                do {
                    ConflictObj o = conflicts.next();
                    if (!PDFParser.tolerantConflicResolver(values, o.offset, 4)) continue;
                    COSObject pdfObject = document.getObjectFromPool(o.objectKey);
                    if (pdfObject.getObjectNumber() != null && pdfObject.getObjectNumber().equals(o.object.getObjectNumber())) {
                        pdfObject.setObject(o.object.getObject());
                        continue;
                    }
                    LOG.debug((Object)("Conflict object [" + o.objectKey + "] at offset " + o.offset + " found in the xref table, but the object numbers differ. Ignoring this object." + " The document is maybe malformed."));
                } while (conflicts.hasNext());
            }
        }
    }
}

