/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.transform.impl;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.xml.resolving.XMLResolvingService;
import org.exoplatform.services.xml.transform.AbstractTransformer;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class TransformerBase
implements AbstractTransformer {
    private Result result = null;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.xml-processing.TransformerBase");
    protected SAXTransformerFactory tSAXFactory;
    protected XMLResolvingService resolvingService;

    public TransformerBase() {
        LOG.debug((Object)("Current javax.xml.parsers.SAXParserFactory sys property [ " + PrivilegedSystemHelper.getProperty((String)"javax.xml.parsers.SAXParserFactory", (String)"-Not set-") + "]"));
        this.tSAXFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    }

    public static XMLReader getXMLReader() throws SAXException {
        return (XMLReader)SecurityHelper.doPrivilegedSAXExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<XMLReader>(){

            @Override
            public XMLReader run() throws Exception {
                return XMLReaderFactory.createXMLReader();
            }
        });
    }

    public void setResolvingService(XMLResolvingService r) {
        this.resolvingService = r;
    }

    protected void afterInitResult() {
        LOG.debug((Object)"Result is set");
    }

    @Override
    public final void initResult(Result result) throws NotSupportedIOTypeException {
        if (!this.isResultSupported(result)) {
            throw new NotSupportedIOTypeException(result);
        }
        this.result = result;
        this.afterInitResult();
    }

    protected Result getResult() {
        return this.result;
    }

    protected boolean isSourceSupported(Source source) {
        return true;
    }

    protected boolean isResultSupported(Result result) {
        return true;
    }

    protected abstract void internalTransform(Source var1) throws NotSupportedIOTypeException, TransformerException, IllegalStateException;

    @Override
    public final void transform(Source source) throws NotSupportedIOTypeException, TransformerException, IllegalStateException {
        if (!this.isSourceSupported(source)) {
            LOG.error((Object)("source of type " + source.getClass().getName() + " not supported"));
            throw new NotSupportedIOTypeException(source);
        }
        if (this.result == null) {
            LOG.error((Object)"Result not set");
            throw new IllegalStateException("Result not specified. See initResult(Result)");
        }
        this.internalTransform(source);
    }

    public void transformInputStream2Result(InputStream input, Result result) throws TransformerException {
        LOG.debug((Object)("Transform InputStream to result of type " + result.getClass().getName()));
        if (result instanceof StreamResult) {
            OutputStream outputStream = ((StreamResult)result).getOutputStream();
            try {
                int counter = 0;
                while (input.available() > 0) {
                    byte[] byteArray = new byte[input.available()];
                    int readBytes = input.read(byteArray);
                    counter += readBytes;
                    outputStream.write(byteArray, 0, readBytes);
                }
                LOG.debug((Object)("Write " + counter + " bytes to ouput stream"));
            }
            catch (IOException ex) {
                LOG.error((Object)"Error on read/write ", (Throwable)ex);
                throw new TransformerException(ex);
            }
        }
        XMLReader xmlReader = null;
        try {
            xmlReader = TransformerBase.getXMLReader();
            LOG.debug((Object)("xmlReader class is " + xmlReader.getClass().getName()));
            if (this.resolvingService != null) {
                xmlReader.setEntityResolver(this.resolvingService.getEntityResolver());
                LOG.debug((Object)"Set entity resolver");
            }
            if (result instanceof SAXResult) {
                SAXResult saxResult = (SAXResult)result;
                xmlReader.setContentHandler(saxResult.getHandler());
                LOG.debug((Object)"Parse direct to result");
            } else {
                LOG.debug((Object)"Create empty transformation");
                TransformerHandler transformerHandler = this.tSAXFactory.newTransformerHandler();
                transformerHandler.setResult(result);
                xmlReader.setContentHandler(transformerHandler);
                LOG.debug((Object)"Parse to result throw empty transformer");
            }
            xmlReader.parse(new InputSource(input));
            LOG.debug((Object)"Parse complete");
        }
        catch (SAXException ex) {
            throw new TransformerException(ex);
        }
        catch (IOException ex) {
            throw new TransformerException(ex);
        }
    }

    protected InputStream sourceAsInputStream(Source source) throws NotSupportedIOTypeException {
        InputSource inputSource = SAXSource.sourceToInputSource(source);
        if (inputSource == null) {
            throw new NotSupportedIOTypeException(source);
        }
        return inputSource.getByteStream();
    }

    protected void writeTofile(byte[] bytes, String postfix) {
        block4: {
            String POSTFIX = new SimpleDateFormat("yy-MM-DD_HH-mm-ss_").format(new Date());
            try {
                FileOutputStream fileLog = new FileOutputStream("c:/tmp/transf" + POSTFIX + postfix + ".xhtml");
                fileLog.write(bytes);
                fileLog.flush();
                fileLog.close();
            }
            catch (FileNotFoundException ex) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + ex.getMessage()));
                }
            }
            catch (IOException ex) {
                if (!LOG.isTraceEnabled()) break block4;
                LOG.trace((Object)("An exception occurred: " + ex.getMessage()));
            }
        }
    }
}

