/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.GroupVisibilityPlugin;
import org.exoplatform.portal.config.PortalACLPlugin;
import org.exoplatform.portal.config.UserACLMetaData;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;

public class UserACL {
    public static final String EVERYONE = "Everyone";
    public static final String NOBODY = "Nobody";
    protected static Log log = ExoLogger.getLogger((String)"organization:UserACL");
    private static final Collection<MembershipEntry> NO_MEMBERSHIP = Collections.emptyList();
    private static final Collection<String> NO_ROLES = Collections.emptyList();
    private static final Identity guest = new Identity(null, NO_MEMBERSHIP, NO_ROLES);
    private String superUser_;
    private String guestGroup_;
    private List<String> portalCreatorGroups_;
    private String navigationCreatorMembershipType_;
    private List<String> mandatoryGroups_;
    private List<String> mandatoryMSTypes_;
    private PortalACLPlugin portalACLPlugin;
    private String adminGroups;
    private String adminMSType;
    private Map<String, GroupVisibilityPlugin> groupVisibilityPlugins = new HashMap<String, GroupVisibilityPlugin>();

    public UserACL(InitParams params) {
        ValueParam adminMSTypeParam;
        UserACLMetaData md = new UserACLMetaData(params);
        ValuesParam mandatoryGroupsParam = params.getValuesParam("mandatory.groups");
        this.mandatoryGroups_ = mandatoryGroupsParam != null ? mandatoryGroupsParam.getValues() : new ArrayList<String>();
        ValuesParam mandatoryMSTypesParam = params.getValuesParam("mandatory.mstypes");
        this.mandatoryMSTypes_ = mandatoryMSTypesParam != null ? mandatoryMSTypesParam.getValues() : new ArrayList<String>();
        ValueParam adminGroupsParam = params.getValueParam("portal.administrator.groups");
        if (adminGroupsParam != null) {
            this.setAdminGroups(adminGroupsParam.getValue());
        }
        if ((adminMSTypeParam = params.getValueParam("portal.administrator.mstype")) != null) {
            this.setAdminMSType(adminMSTypeParam.getValue());
        }
        this.init(md);
    }

    public UserACL(UserACLMetaData md) {
        if (md == null) {
            throw new NullPointerException("No meta data provided");
        }
        this.init(md);
    }

    private void init(UserACLMetaData md) {
        if (md.getSuperUser() != null) {
            this.superUser_ = md.getSuperUser();
        }
        if (this.superUser_ == null || this.superUser_.trim().length() == 0) {
            this.superUser_ = "root";
        }
        if (md.getGuestsGroups() != null) {
            this.guestGroup_ = md.getGuestsGroups();
        }
        if (this.guestGroup_ == null || this.guestGroup_.trim().length() < 1) {
            this.guestGroup_ = "/platform/guests";
        }
        if (md.getNavigationCreatorMembershipType() != null) {
            this.navigationCreatorMembershipType_ = md.getNavigationCreatorMembershipType();
        }
        if (this.navigationCreatorMembershipType_ == null || this.navigationCreatorMembershipType_.trim().length() == 0) {
            this.navigationCreatorMembershipType_ = "owner";
        }
        String allGroups = "";
        if (md.getPortalCreateGroups() != null) {
            allGroups = md.getPortalCreateGroups();
        }
        this.portalCreatorGroups_ = this.defragmentPermission(allGroups);
    }

    public void addPortalACLPlugin(PortalACLPlugin plugin) {
        List<String> portalCreationRoles;
        this.portalACLPlugin = plugin;
        String superUser = this.portalACLPlugin.getSuperUser();
        if (superUser != null) {
            log.info((Object)"Overidden SuperUser by PortalACLPlugin");
            this.superUser_ = superUser;
        }
        if ((portalCreationRoles = this.portalACLPlugin.getPortalCreationRoles()) != null) {
            log.info((Object)"Overidden PortalCreatorGroup by PortalACLPlugin");
            this.portalCreatorGroups_ = portalCreationRoles;
        }
    }

    public void addGroupVisibilityPlugin(GroupVisibilityPlugin plugin) {
        this.groupVisibilityPlugins.put(plugin.getName(), plugin);
    }

    public String getMakableMT() {
        return this.navigationCreatorMembershipType_;
    }

    public List<String> getPortalCreatorGroups() {
        return this.portalCreatorGroups_;
    }

    public String getSuperUser() {
        return this.superUser_;
    }

    public String getGuestsGroup() {
        return this.guestGroup_;
    }

    public List<String> getMandatoryGroups() {
        return this.mandatoryGroups_;
    }

    public List<String> getMandatoryMSTypes() {
        return this.mandatoryMSTypes_;
    }

    public void setAdminGroups(String adminGroups) {
        this.adminGroups = adminGroups;
    }

    public String getAdminGroups() {
        return this.adminGroups;
    }

    public void setAdminMSType(String adminMSType) {
        this.adminMSType = adminMSType;
    }

    public String getAdminMSType() {
        return this.adminMSType;
    }

    public boolean hasPermission(PortalConfig pconfig) {
        String[] accessPerms;
        Identity identity = this.getIdentity();
        if (this.hasPermission(identity, pconfig.getEditPermission())) {
            pconfig.setModifiable(true);
            return true;
        }
        pconfig.setModifiable(false);
        for (String per : accessPerms = pconfig.getAccessPermissions()) {
            if (!this.hasPermission(identity, per)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEditPermission(PortalConfig pconfig) {
        return this.hasPermission(this.getIdentity(), pconfig.getEditPermission());
    }

    public boolean hasEditPermissionOnPortal(String ownerType, String ownerId, String editPermExpression) {
        Identity identity = this.getIdentity();
        if (this.superUser_.equals(identity.getUserId())) {
            return true;
        }
        if (PortalConfig.USER_TYPE.equals(ownerType)) {
            return identity.getUserId().equals(ownerId);
        }
        return this.hasPermission(identity, editPermExpression);
    }

    public boolean hasCreatePortalPermission() {
        Identity identity = this.getIdentity();
        if (this.superUser_.equals(identity.getUserId())) {
            return true;
        }
        if (this.portalCreatorGroups_ == null || this.portalCreatorGroups_.size() < 1) {
            return false;
        }
        for (String ele : this.portalCreatorGroups_) {
            if (!this.hasPermission(identity, ele)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEditPermissionOnNavigation(SiteKey siteKey) {
        Identity identity = this.getIdentity();
        if (this.superUser_.equals(identity.getUserId())) {
            return true;
        }
        switch (siteKey.getType()) {
            case PORTAL: {
                return false;
            }
            case GROUP: {
                String temp = siteKey.getName().trim();
                String expAdminGroup = this.getAdminGroups();
                String expPerm = null;
                if (expAdminGroup != null) {
                    expAdminGroup = expAdminGroup.startsWith("/") ? expAdminGroup : "/" + expAdminGroup;
                    String string = expPerm = temp.startsWith("/") ? temp : "/" + temp;
                    if (this.isUserInGroup(expPerm) && this.isUserInGroup(expAdminGroup)) {
                        return true;
                    }
                }
                expPerm = this.navigationCreatorMembershipType_ + (temp.startsWith("/") ? ":" + temp : ":/" + temp);
                return this.hasPermission(identity, expPerm);
            }
            case USER: {
                return siteKey.getName().equals(identity.getUserId());
            }
        }
        return false;
    }

    public boolean hasPermission(Page page) {
        Identity identity = this.getIdentity();
        if (PortalConfig.USER_TYPE.equals(page.getOwnerType()) && page.getOwnerId().equals(identity.getUserId())) {
            page.setModifiable(true);
            return true;
        }
        if (this.superUser_.equals(identity.getUserId())) {
            page.setModifiable(true);
            return true;
        }
        if (this.hasEditPermission(page)) {
            page.setModifiable(true);
            return true;
        }
        page.setModifiable(false);
        String[] accessPerms = page.getAccessPermissions();
        if (accessPerms != null) {
            for (String per : accessPerms) {
                if (!this.hasPermission(identity, per)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPermission(PageContext page) {
        PageKey key = page.getKey();
        Identity identity = this.getIdentity();
        if (SiteType.USER == key.getSite().getType() && key.getSite().getName().equals(identity.getUserId())) {
            return true;
        }
        if (this.superUser_.equals(identity.getUserId())) {
            return true;
        }
        if (this.hasEditPermission(page)) {
            return true;
        }
        List<String> accessPerms = page.getState().getAccessPermissions();
        if (accessPerms != null) {
            for (String per : accessPerms) {
                if (!this.hasPermission(identity, per)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasEditPermission(Page page) {
        Identity identity = this.getIdentity();
        if (PortalConfig.USER_TYPE.equals(page.getOwnerType())) {
            if (page.getOwnerId().equals(identity.getUserId())) {
                page.setModifiable(true);
                return true;
            }
            return false;
        }
        if (this.hasPermission(identity, page.getEditPermission())) {
            page.setModifiable(true);
            return true;
        }
        page.setModifiable(false);
        return false;
    }

    public boolean hasEditPermission(PageContext page) {
        PageKey key = page.getKey();
        Identity identity = this.getIdentity();
        if (SiteType.USER == key.getSite().getType()) {
            return key.getSite().getName().equals(identity.getUserId());
        }
        return this.hasPermission(identity, page.getState().getEditPermission());
    }

    public boolean hasEditPermissionOnPage(String ownerType, String ownerId, String editPermExpression) {
        Identity identity = this.getIdentity();
        if (PortalConfig.USER_TYPE.equals(ownerType)) {
            return ownerId.equals(identity.getUserId());
        }
        return this.hasPermission(identity, editPermExpression);
    }

    public boolean hasPermission(String expPerm) {
        return this.hasPermission(this.getIdentity(), expPerm);
    }

    public boolean hasPermission(String[] permissions) {
        Identity identity = this.getIdentity();
        String currentUser = identity.getUserId();
        if (this.superUser_.equals(currentUser)) {
            return true;
        }
        if (permissions == null || permissions.length == 0) {
            return false;
        }
        for (String per : permissions) {
            if (!this.hasPermission(identity, per)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserInGroup(String group) {
        ConversationState conv = ConversationState.getCurrent();
        Identity id = null;
        if (conv != null) {
            id = conv.getIdentity();
        }
        if (id == null) {
            return false;
        }
        Iterator iter = id.getGroups().iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equals(group)) continue;
            return true;
        }
        return false;
    }

    public boolean isSuperUser() {
        Identity identity = this.getIdentity();
        return this.superUser_.equals(identity.getUserId());
    }

    private Identity getIdentity() {
        ConversationState conv = ConversationState.getCurrent();
        if (conv == null) {
            return guest;
        }
        Identity id = conv.getIdentity();
        if (id == null) {
            return guest;
        }
        return id;
    }

    public boolean hasPermission(Identity identity, String expPerm) {
        String currentUser = identity.getUserId();
        if (this.superUser_.equals(currentUser)) {
            return true;
        }
        if (expPerm == null) {
            return false;
        }
        if (EVERYONE.equals(expPerm)) {
            return true;
        }
        Permission permission = new Permission();
        permission.setPermissionExpression(expPerm);
        String groupId = permission.getGroupId();
        if ((currentUser == null || currentUser.equals(IdentityConstants.ANONIM)) && groupId.equals(this.guestGroup_)) {
            return true;
        }
        String membership = permission.getMembership();
        return identity.isMemberOf(groupId, membership);
    }

    public boolean hasPermission(Identity identity, Group group, String pluginId) {
        GroupVisibilityPlugin plugin = this.groupVisibilityPlugins.get(pluginId);
        return plugin == null ? true : plugin.hasPermission(identity, group);
    }

    private List<String> defragmentPermission(String permission) {
        ArrayList<String> result = new ArrayList<String>();
        if (permission != null) {
            if (permission.contains(",")) {
                String[] groups;
                for (String group : groups = permission.split(",")) {
                    result.add(group.trim());
                }
            } else {
                result.add(permission);
            }
        }
        return result;
    }

    public static class Permission
    implements Serializable {
        private static final long serialVersionUID = -2642107810551203332L;
        private String name_;
        private String groupId_ = "";
        private String membership_ = "";
        private String expression;
        private boolean selected_ = false;

        public void setPermissionExpression(String exp) {
            if (exp == null || exp.length() == 0) {
                return;
            }
            String[] temp = exp.split(":");
            if (temp.length < 2) {
                return;
            }
            this.expression = exp;
            this.membership_ = temp[0].trim();
            this.groupId_ = temp[1].trim();
        }

        public String getGroupId() {
            return this.groupId_;
        }

        public void setGroupId(String groupId) {
            this.groupId_ = groupId;
        }

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }

        public String getValue() {
            if (this.membership_.length() == 0 || this.groupId_.length() == 0) {
                return null;
            }
            return this.membership_ + ":" + this.groupId_;
        }

        public String getMembership() {
            return this.membership_;
        }

        public void setMembership(String membership) {
            this.membership_ = membership;
        }

        public boolean isSelected() {
            return this.selected_;
        }

        public void setSelected(boolean selected) {
            this.selected_ = selected;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }
    }
}

