/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.jdbc.entity.NavigationEntity;
import org.exoplatform.portal.jdbc.entity.NodeEntity;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.jdbc.dao.NavigationDAO;
import org.exoplatform.portal.mop.jdbc.dao.NodeDAO;
import org.exoplatform.portal.mop.jdbc.dao.PageDAO;
import org.exoplatform.portal.mop.jdbc.dao.SiteDAO;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NavigationError;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NavigationStore;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NavigationStoreImpl
implements NavigationStore {
    private NavigationDAO navigationDAO;
    private SiteDAO siteDAO;
    private NodeDAO nodeDAO;
    private PageDAO pageDAO;
    private DataStorage dataStorage;
    private static Log log = ExoLogger.getExoLogger(NavigationStoreImpl.class);

    public NavigationStoreImpl(NavigationDAO navigationDAO, SiteDAO siteDAO, NodeDAO nodeDAO, PageDAO pageDAO, DataStorage dataStorage) {
        this.navigationDAO = navigationDAO;
        this.siteDAO = siteDAO;
        this.nodeDAO = nodeDAO;
        this.pageDAO = pageDAO;
        this.dataStorage = dataStorage;
    }

    @Override
    public NodeData loadNode(Long nodeId) {
        NodeEntity node = (NodeEntity)this.nodeDAO.find(nodeId);
        return this.buildNodeData(node);
    }

    @Override
    public NodeData[] loadNodes(String pageRef) {
        PageEntity page = this.pageDAO.findByKey(PageKey.parse(pageRef));
        if (page == null) {
            return new NodeData[0];
        }
        List<NodeEntity> nodes = this.nodeDAO.findAllByPage(page.getId());
        NodeData[] result = new NodeData[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            result[i] = this.buildNodeData(nodes.get(i));
        }
        return result;
    }

    @Override
    public NodeData[] createNode(Long parentId, Long previousId, String name, NodeState state) {
        NodeEntity parent = null;
        if (parentId != null) {
            parent = (NodeEntity)this.nodeDAO.find(parentId);
        }
        Long prev = null;
        if (previousId != null) {
            prev = previousId;
        }
        NodeEntity target = this.buildNodeEntity(null, state);
        target.setName(name);
        target.setParent(parent);
        if (parent != null) {
            int i;
            List<NodeEntity> children = parent.getChildren();
            for (i = 0; i < children.size(); ++i) {
                if (!children.get(i).getId().equals(prev)) continue;
                ++i;
                break;
            }
            children.add(i, target);
            parent.setChildren(children);
            this.nodeDAO.create(target);
            this.nodeDAO.update(parent);
        } else {
            this.nodeDAO.create(target);
        }
        return new NodeData[]{this.buildNodeData(parent), this.buildNodeData(target)};
    }

    @Override
    public NodeData destroyNode(Long targetId) {
        NodeEntity node = (NodeEntity)this.nodeDAO.find(targetId);
        if (node != null) {
            NodeEntity parent = node.getParent();
            if (parent != null) {
                Iterator<NodeEntity> children = parent.getChildren().iterator();
                while (children.hasNext()) {
                    if (!children.next().getId().equals(node.getId())) continue;
                    children.remove();
                    break;
                }
            }
            this.nodeDAO.delete(node);
            return this.buildNodeData(parent);
        }
        return null;
    }

    @Override
    public NodeData updateNode(Long targetId, NodeState state) {
        NodeEntity node = (NodeEntity)this.nodeDAO.find(targetId);
        if (node != null) {
            node = this.buildNodeEntity(node, state);
            this.nodeDAO.update(node);
            return this.buildNodeData(node);
        }
        return null;
    }

    @Override
    public NodeData[] moveNode(Long targetId, Long fromId, Long toId, Long previousId) {
        List<NodeEntity> children;
        NodeEntity target = (NodeEntity)this.nodeDAO.find(targetId);
        if (target == null) {
            return null;
        }
        NodeEntity from = null;
        if (fromId != null && (from = (NodeEntity)this.nodeDAO.find(fromId)) != null) {
            List<NodeEntity> children2 = from.getChildren();
            children2.remove(target);
        }
        int index = -1;
        NodeEntity to = null;
        if (toId != null && (children = (to = (NodeEntity)this.nodeDAO.find(toId)).getChildren()) != null && previousId != null) {
            Long prev = previousId;
            for (index = 0; index < children.size() && !children.get(index).getId().equals(prev); ++index) {
            }
        }
        target.setParent(to);
        if (to != null) {
            children = to.getChildren();
            index = index >= children.size() ? children.size() : ++index;
            children.add(index, target);
            to.setChildren(children);
            to = (NodeEntity)this.nodeDAO.update(to);
        }
        target = (NodeEntity)this.nodeDAO.update(target);
        if (from != null && fromId != toId) {
            from = (NodeEntity)this.nodeDAO.update(from);
        }
        return new NodeData[]{this.buildNodeData(target), this.buildNodeData(from), this.buildNodeData(to)};
    }

    @Override
    public NodeData[] renameNode(Long targetId, Long parentId, String name) {
        NodeEntity target = (NodeEntity)this.nodeDAO.find(targetId);
        if (target == null) {
            return null;
        }
        NodeEntity parent = null;
        if (parentId != null) {
            parent = (NodeEntity)this.nodeDAO.find(parentId);
        }
        target.setName(name);
        this.nodeDAO.update(target);
        return new NodeData[]{this.buildNodeData(target), this.buildNodeData(parent)};
    }

    @Override
    public void flush() {
    }

    @Override
    public List<NavigationData> loadNavigations(SiteType type) {
        LinkedList<NavigationData> results = new LinkedList<NavigationData>();
        Query<PortalConfig> q = new Query<PortalConfig>(type.getName(), null, PortalConfig.class);
        try {
            LazyPageList<PortalConfig> configs = this.dataStorage.find(q);
            for (PortalConfig config : configs.getAll()) {
                SiteKey siteKey = new SiteKey(config.getType(), config.getName());
                NavigationData navData = this.loadNavigationData(siteKey);
                if (navData == NavigationData.EMPTY) continue;
                results.add(navData);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return results;
    }

    @Override
    public NavigationData loadNavigationData(SiteKey key) {
        NavigationEntity navEntity = this.navigationDAO.findByOwner(key.getType(), key.getName());
        if (navEntity != null) {
            NavigationState navigationState = new NavigationState(navEntity.getPriority());
            return new NavigationData(key, navigationState, String.valueOf(navEntity.getRootNode().getId()));
        }
        return NavigationData.EMPTY;
    }

    @Override
    public NavigationData loadNavigationData(Long nodeId) {
        NodeData root = this.buildNodeData(this.getRootNode(nodeId));
        NavigationEntity navEntity = this.navigationDAO.findByRootNode(Safe.parseLong((String)root.getId()));
        if (navEntity != null) {
            SiteEntity siteEntity = navEntity.getOwner();
            SiteKey key = siteEntity.getSiteType().key(siteEntity.getName());
            NavigationState navigationState = new NavigationState(navEntity.getPriority());
            return new NavigationData(key, navigationState, String.valueOf(navEntity.getRootNode().getId()));
        }
        return NavigationData.EMPTY;
    }

    private NodeEntity getRootNode(Long nodeId) {
        NodeEntity entity = (NodeEntity)this.nodeDAO.find(nodeId);
        if (entity.getParent() != null) {
            return this.getRootNode(entity.getParent().getId());
        }
        return entity;
    }

    @Override
    public void saveNavigation(SiteKey key, NavigationState state) {
        SiteEntity owner = this.siteDAO.findByKey(key);
        if (owner == null) {
            throw new NavigationServiceException(NavigationError.NAVIGATION_NO_SITE);
        }
        NavigationEntity navEntity = this.navigationDAO.findByOwner(key.getType(), key.getName());
        if ((navEntity = this.buildNavEntity(navEntity, key, state.getPriority())).getId() == null) {
            this.nodeDAO.create(navEntity.getRootNode());
            this.navigationDAO.create(navEntity);
        } else {
            this.navigationDAO.update(navEntity);
        }
    }

    @Override
    public boolean destroyNavigation(NavigationData data) {
        SiteKey siteKey = data.key;
        SiteEntity owner = this.siteDAO.findByKey(siteKey);
        if (owner == null) {
            throw new NavigationServiceException(NavigationError.NAVIGATION_NO_SITE);
        }
        NavigationEntity navEntity = this.navigationDAO.findByOwner(siteKey.getType(), siteKey.getName());
        if (navEntity != null) {
            this.navigationDAO.delete(navEntity);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
    }

    private NavigationEntity buildNavEntity(NavigationEntity entity, SiteKey key, Integer priority) {
        if (entity == null) {
            entity = new NavigationEntity();
            NodeEntity rootNode = new NodeEntity();
            rootNode.setName("default");
            entity.setRootNode(rootNode);
        }
        entity.setPriority(priority == null ? 0 : priority);
        entity.setOwner(this.siteDAO.findByKey(key));
        return entity;
    }

    private NodeEntity buildNodeEntity(NodeEntity entity, NodeState state) {
        if (entity == null) {
            entity = new NodeEntity();
        }
        if (state == null) {
            return entity;
        }
        entity.setEndTime(state.getEndPublicationTime());
        entity.setIcon(state.getIcon());
        entity.setLabel(state.getLabel());
        if (state.getPageRef() != null) {
            PageEntity page = this.pageDAO.findByKey(state.getPageRef());
            if (page != null) {
                entity.setPage(page);
            }
        } else {
            entity.setPage(null);
        }
        entity.setStartTime(state.getStartPublicationTime());
        entity.setVisibility(state.getVisibility());
        return entity;
    }

    private NodeData buildNodeData(NodeEntity node) {
        if (node == null) {
            return null;
        }
        String parentId = null;
        if (node.getParent() != null) {
            parentId = node.getParent().getId().toString();
        }
        ArrayList<String> children = new ArrayList<String>();
        if (node.getChildren() != null) {
            for (NodeEntity child : node.getChildren()) {
                children.add(child.getId().toString());
            }
        }
        NodeState.Builder builder = new NodeState.Builder();
        builder.endPublicationTime(node.getEndTime()).icon(node.getIcon()).label(node.getLabel()).startPublicationTime(node.getStartTime()).visibility(node.getVisibility());
        PageEntity page = node.getPage();
        if (page != null) {
            SiteKey siteKey = new SiteKey(page.getOwnerType(), page.getOwnerId());
            PageKey pageKey = new PageKey(siteKey, page.getName());
            builder.pageRef(pageKey);
        }
        NodeState state = builder.build();
        return new NodeData(parentId, node.getId().toString(), node.getName(), state, children.toArray(new String[children.size()]));
    }
}

