/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;

public class NodeData
implements Serializable {
    final String parentId;
    final String id;
    final String name;
    final NodeState state;
    final String[] children;

    public NodeData(String parentId, String id, String name, NodeState state, String[] children) {
        this.parentId = parentId;
        this.id = id;
        this.name = name;
        this.state = state;
        this.children = children;
    }

    NodeData(NodeContext<?> context) {
        int size = 0;
        for (NodeContext current = (NodeContext)context.getFirst(); current != null; current = (NodeContext)current.getNext()) {
            ++size;
        }
        String[] children = new String[size];
        for (NodeContext current = (NodeContext)context.getFirst(); current != null; current = (NodeContext)current.getNext()) {
            children[children.length - size--] = current.handle;
        }
        String parentId = context.getParent() != null ? ((NodeContext)context.getParent()).handle : null;
        String id = context.handle;
        String name = context.getName();
        NodeState state = context.getState();
        this.parentId = parentId;
        this.id = id;
        this.name = name;
        this.state = state;
        this.children = children;
    }

    public Iterator<String> iterator(boolean reverse) {
        if (reverse) {
            return new Iterator<String>(){
                int index;
                {
                    this.index = NodeData.this.children.length;
                }

                @Override
                public boolean hasNext() {
                    return this.index > 0;
                }

                @Override
                public String next() {
                    if (this.index > 0) {
                        return NodeData.this.children[--this.index];
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<String>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < NodeData.this.children.length;
            }

            @Override
            public String next() {
                if (this.index < NodeData.this.children.length) {
                    return NodeData.this.children[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public NodeState getState() {
        return this.state;
    }

    public String getParentId() {
        return this.parentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeData)) {
            return false;
        }
        NodeData nodeData = (NodeData)o;
        return StringUtils.equals((String)this.parentId, (String)nodeData.parentId) && StringUtils.equals((String)this.id, (String)nodeData.id) && StringUtils.equals((String)this.name, (String)nodeData.name);
    }

    public int hashCode() {
        int result = this.parentId != null ? this.parentId.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NodeData[id=" + this.id + ",name=" + this.name + ",state=" + this.state + ",children=" + Arrays.asList(this.children) + "]";
    }
}

