/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.tree.diff;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.exoplatform.portal.tree.diff.ListChangeType;
import org.exoplatform.portal.tree.diff.ListDiff;

public class ListChangeIterator<L1, L2, E>
implements Iterator<ListChangeType> {
    private static final int[] EMPTY = new int[0];
    private static final int TRIVIAL_MODE = 0;
    private static final int LCS_MODE = 1;
    ListDiff<L1, L2, E> diff;
    private final L1 elements1;
    private final L2 elements2;
    private final Iterator<E> it1;
    private final Iterator<E> it2;
    private int index1;
    private int index2;
    private E next1;
    private E next2;
    private E element;
    private ListChangeType type;
    private int mode;
    private boolean buffered;
    private int[] matrix;
    private int m;
    private int n;

    ListChangeIterator(ListDiff<L1, L2, E> diff, L1 elements1, L2 elements2) {
        this.diff = diff;
        this.elements1 = elements1;
        this.elements2 = elements2;
        this.it1 = elements1 != null ? diff.adapter1.iterator(elements1, false) : null;
        this.it2 = elements2 != null ? diff.adapter2.iterator(elements2, false) : null;
        this.mode = 0;
        this.index1 = 0;
        this.index2 = 0;
        this.buffered = false;
        this.next1 = null;
        this.next2 = null;
        this.type = null;
        this.element = null;
        if (this.it1 != null && this.it1.hasNext()) {
            this.next1 = this.it1.next();
        }
        if (this.it2 != null && this.it2.hasNext()) {
            this.next2 = this.it2.next();
        }
        this.m = 0;
        this.n = 0;
        this.matrix = EMPTY;
    }

    private void next1() {
        ++this.index1;
        this.next1 = this.it1 != null && this.it1.hasNext() ? this.it1.next() : null;
    }

    private void next2() {
        ++this.index2;
        this.next2 = this.it2 != null && this.it2.hasNext() ? this.it2.next() : null;
    }

    @Override
    public boolean hasNext() {
        while (!this.buffered) {
            if (this.mode == 0) {
                if (this.next1 != null) {
                    if (this.next2 != null) {
                        if (this.diff.equals(this.next1, this.next2)) {
                            this.type = ListChangeType.SAME;
                            this.element = this.next1;
                            this.buffered = true;
                            this.next1();
                            this.next2();
                            continue;
                        }
                        this.lcs(this.index1, this.elements1, this.elements2);
                        this.mode = 1;
                        continue;
                    }
                    this.type = ListChangeType.REMOVE;
                    this.element = this.next1;
                    this.buffered = true;
                    this.next1();
                    continue;
                }
                if (this.next2 == null) break;
                this.type = ListChangeType.ADD;
                this.element = this.next2;
                this.buffered = true;
                this.next2();
                continue;
            }
            if (this.mode == 1) {
                Object elt1 = null;
                Object elt2 = null;
                int i = this.diff.adapter1.size(this.elements1) - this.index1;
                int j = this.diff.adapter2.size(this.elements2) - this.index2;
                if (i > 0 && j > 0) {
                    E e = this.next1;
                    elt1 = e;
                    E e2 = this.next2;
                    elt2 = e2;
                    if (this.diff.equals(e, e2)) {
                        this.type = ListChangeType.SAME;
                        this.element = elt1;
                        this.next1();
                        this.next2();
                        this.buffered = true;
                        continue;
                    }
                }
                int index1 = i + (j - 1) * this.m;
                int index2 = i - 1 + j * this.m;
                if (j > 0 && (i == 0 || this.matrix[index1] >= this.matrix[index2])) {
                    this.type = ListChangeType.ADD;
                    this.element = elt2 == null ? this.next2 : elt2;
                    this.next2();
                    this.buffered = true;
                    continue;
                }
                if (i <= 0 || j != 0 && this.matrix[index1] >= this.matrix[index2]) break;
                this.type = ListChangeType.REMOVE;
                this.element = elt1 == null ? this.next1 : elt1;
                this.next1();
                this.buffered = true;
                continue;
            }
            throw new AssertionError();
        }
        return this.buffered;
    }

    @Override
    public ListChangeType next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.buffered = false;
        return this.type;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public E getElement() {
        return this.element;
    }

    public int getIndex1() {
        return this.index1;
    }

    public int getIndex2() {
        return this.index2;
    }

    private void lcs(int offset, L1 elements1, L2 elements2) {
        this.m = 1 + this.diff.adapter1.size(elements1) - offset;
        this.n = 1 + this.diff.adapter2.size(elements2) - offset;
        int s = this.m * this.n;
        this.matrix = new int[s];
        Iterator itI = this.diff.adapter1.iterator(elements1, true);
        for (int i = 1; i < this.m; ++i) {
            Object abc = itI.next();
            Iterator itJ = this.diff.adapter2.iterator(elements2, true);
            for (int j = 1; j < this.n; ++j) {
                int v2;
                int v1;
                int index = i + j * this.m;
                Object def = itJ.next();
                int v = this.diff.equals(abc, def) ? this.matrix[index - this.m - 1] + 1 : ((v1 = this.matrix[index - 1]) < (v2 = this.matrix[index - this.m]) ? v2 : v1);
                this.matrix[index] = v;
            }
        }
    }

    String getMatrix() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.m; ++i) {
            sb.append('[');
            for (int j = 0; j < this.n; ++j) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(this.matrix[i + j * this.m]);
            }
            sb.append("]\n");
        }
        return sb.toString();
    }
}

