/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.binding;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingQueue;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.GroupSpaceBindingRestResources;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingEntity;

@Path(value="v1/social/spaceGroupBindings")
@Api(tags={"v1/social/groupSpaceBindings"}, value="v1/social/groupSpaceBindings", description="API  to manage the binding between a space and an organization group")
public class GroupSpaceBindingRestResourcesV1
implements GroupSpaceBindingRestResources {
    private GroupSpaceBindingService groupSpaceBindingService;
    private UserACL userACL;

    public GroupSpaceBindingRestResourcesV1(GroupSpaceBindingService groupSpaceBindingService, UserACL userACL) {
        this.groupSpaceBindingService = groupSpaceBindingService;
        this.userACL = userACL;
    }

    @Override
    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Path(value="{spaceId}")
    @ApiOperation(value="Gets list of binding for a space.", httpMethod="GET", response=Response.class, notes="Returns a list of bindings in the following cases if the authenticated user is a member of space administrator group.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getBindingsBySpaceId(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="spaceId") String spaceId, @ApiParam(value="Offset", defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", defaultValue="10") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of spaces found or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List removedSpaceBindingsIds = this.groupSpaceBindingService.getGroupSpaceBindingsFromQueueByAction(GroupSpaceBindingQueue.ACTION_REMOVE).stream().map(groupSpaceBinding -> groupSpaceBinding.getId()).collect(Collectors.toList());
        List spaceBindings = this.groupSpaceBindingService.findGroupSpaceBindingsBySpace(spaceId);
        if (removedSpaceBindingsIds.size() > 0 && spaceBindings.size() > 0) {
            spaceBindings.removeIf(spaceBinding -> removedSpaceBindingsIds.contains(spaceBinding.getId()));
        }
        if (spaceBindings.size() == 0) {
            return EntityBuilder.getResponse(new CollectionEntity(new ArrayList(), "groupSpaceBindings", offset, limit), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        ArrayList<DataEntity> bindingEntities = new ArrayList<DataEntity>();
        for (GroupSpaceBinding binding : spaceBindings) {
            GroupSpaceBindingEntity bindingEntity = EntityBuilder.buildEntityFromGroupSpaceBinding(binding);
            bindingEntities.add(bindingEntity.getDataEntity());
        }
        CollectionEntity collectionBinding = new CollectionEntity(bindingEntities, "groupSpaceBindings", offset, limit);
        if (returnSize) {
            collectionBinding.setSize(bindingEntities.size());
        }
        return EntityBuilder.getResponse(collectionBinding, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="saveGroupsSpaceBindings/{spaceId}")
    @ApiOperation(value="Save space group bindings", httpMethod="POST", response=Response.class, notes="This method update bindings for a specific space if the authenticated user is a spaces super manager")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error due to data encoding")})
    public Response saveGroupSpaceBindings(@Context UriInfo uriInfo, @ApiParam(value="SpaceId of the space", required=true) @PathParam(value="spaceId") String spaceId, @ApiParam(value="List of group names to be bound to the space", required=true) List<String> groupNames) {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (groupNames == null || groupNames.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List spaceBoundGroups = this.groupSpaceBindingService.findGroupSpaceBindingsBySpace(spaceId).stream().map(groupSpaceBinding -> groupSpaceBinding.getGroup()).collect(Collectors.toList());
        groupNames.removeAll(spaceBoundGroups);
        if (groupNames.size() == 0) {
            return Response.ok((Object)"Already bound!").build();
        }
        ArrayList groupSpaceBindings = new ArrayList();
        groupNames.stream().forEach(groupName -> groupSpaceBindings.add(new GroupSpaceBinding(spaceId, groupName)));
        this.groupSpaceBindingService.saveGroupSpaceBindings(groupSpaceBindings);
        return Response.ok().build();
    }

    @Override
    @DELETE
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="removeGroupSpaceBinding/{bindingId}")
    @ApiOperation(value="Deletes a binding.", httpMethod="DELETE", response=Response.class, notes="This method deletes a binding in the following cases the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteSpaceBinding(@Context UriInfo uriInfo, @ApiParam(value="spaceId", required=true) @PathParam(value="bindingId") String bindingId) throws Exception {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        GroupSpaceBinding binding = this.groupSpaceBindingService.findGroupSpaceBindingById(bindingId);
        if (binding != null) {
            GroupSpaceBindingQueue bindingQueue = new GroupSpaceBindingQueue(binding, GroupSpaceBindingQueue.ACTION_REMOVE);
            this.groupSpaceBindingService.createGroupSpaceBindingQueue(bindingQueue);
        }
        return Response.ok().build();
    }
}

