/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.ActivityStreamRestOut;
import org.exoplatform.social.service.rest.api.models.CommentRestOut;
import org.exoplatform.social.service.rest.api.models.IdentityRestOut;

public class ActivityRestOut
extends HashMap<String, Object> {
    public ActivityRestOut() {
        this.initialize();
    }

    public ActivityRestOut(ExoSocialActivity activity, String portalContainerName) {
        this.initialize();
        this.setId(activity.getId());
        this.setTitle(activity.getTitle());
        this.setBody(activity.getBody());
        this.setPriority(activity.getPriority());
        this.setAppId(activity.getAppId());
        this.setType(activity.getType());
        this.setPostedTime(activity.getPostedTime());
        this.setLastUpdatedTime(activity.getUpdated().getTime());
        this.setCreatedAt(Util.convertTimestampToTimeString(this.getPostedTime()));
        this.setTitleId(activity.getTitleId());
        this.setTemplateParams(activity.getTemplateParams());
        if (activity.getLikeIdentityIds() != null) {
            this.setTotalNumberOfLikes(activity.getLikeIdentityIds().length);
        } else {
            this.setTotalNumberOfLikes(null);
        }
        if (Util.isLikedByIdentity(Util.getAuthenticatedUserIdentity(portalContainerName).getId(), activity)) {
            this.setLiked(true);
        } else {
            this.setLiked(false);
        }
        RealtimeListAccess commentRealtimeListAccess = Util.getActivityManager(portalContainerName).getCommentsWithListAccess(activity);
        this.setTotalNumberOfComments(commentRealtimeListAccess.getSize());
        Identity streamOwnerIdentity = Util.getOwnerIdentityIdFromActivity(portalContainerName, activity);
        if (streamOwnerIdentity != null) {
            this.put(Field.IDENTITY_ID.toString(), streamOwnerIdentity.getId());
        }
    }

    public String getId() {
        return (String)this.get(Field.ID.toString());
    }

    public void setId(String id) {
        if (id != null) {
            this.put(Field.ID.toString(), id);
        } else {
            this.put(Field.ID.toString(), "");
        }
    }

    public String getTitle() {
        return (String)this.get(Field.TITLE.toString());
    }

    public void setTitle(String title) {
        if (title != null) {
            this.put(Field.TITLE.toString(), title);
        } else {
            this.put(Field.TITLE.toString(), "");
        }
    }

    public String getBody() {
        return (String)this.get(Field.BODY.toString());
    }

    public void setBody(String body) {
        if (body != null) {
            this.put(Field.BODY.toString(), body);
        } else {
            this.put(Field.BODY.toString(), "");
        }
    }

    public Float getPriority() {
        return (Float)this.get(Field.PRIORITY.toString());
    }

    public void setPriority(Float priority) {
        if (priority != null) {
            this.put(Field.PRIORITY.toString(), priority);
        } else {
            this.put(Field.PRIORITY.toString(), new Float(0.0f));
        }
    }

    public String getAppId() {
        return (String)this.get(Field.APPID.toString());
    }

    public void setAppId(String appId) {
        if (appId != null) {
            this.put(Field.APPID.toString(), appId);
        } else {
            this.put(Field.APPID.toString(), "");
        }
    }

    public String getType() {
        return (String)this.get(Field.TYPE.toString());
    }

    public void setType(String type) {
        if (type != null) {
            this.put(Field.TYPE.toString(), type);
        } else {
            this.put(Field.TYPE.toString(), "");
        }
    }

    public Long getPostedTime() {
        return (Long)this.get(Field.POSTED_TIME.toString());
    }

    public Long getLastUpdatedTime() {
        return (Long)this.get(Field.LAST_UPDATED.toString());
    }

    public void setPostedTime(Long postedTime) {
        if (postedTime != null) {
            this.put(Field.POSTED_TIME.toString(), postedTime);
        } else {
            this.put(Field.POSTED_TIME.toString(), new Long(0L));
        }
    }

    public void setLastUpdatedTime(Long updatedTime) {
        if (updatedTime != null) {
            this.put(Field.LAST_UPDATED.toString(), updatedTime);
        } else {
            this.put(Field.LAST_UPDATED.toString(), new Long(0L));
        }
    }

    public String getCreatedAt() {
        return (String)this.get(Field.CREATED_AT.toString());
    }

    public void setCreatedAt(String createdAt) {
        if (createdAt != null) {
            this.put(Field.CREATED_AT.toString(), createdAt);
        } else {
            this.put(Field.CREATED_AT.toString(), "");
        }
    }

    public String getTitleId() {
        return (String)this.get(Field.TITLE_ID.toString());
    }

    public void setTitleId(String titleId) {
        if (titleId != null) {
            this.put(Field.TITLE_ID.toString(), titleId);
        } else {
            this.put(Field.TITLE_ID.toString(), "");
        }
    }

    public Map<String, String> getTemplateParams() {
        return (Map)this.get(Field.TEMPLATE_PARAMS.toString());
    }

    public void setTemplateParams(Map<String, String> map) {
        if (map != null) {
            this.put(Field.TEMPLATE_PARAMS.toString(), map);
        } else {
            this.put(Field.TEMPLATE_PARAMS.toString(), new HashMap());
        }
    }

    public Boolean getLiked() {
        return (Boolean)this.get(Field.LIKED.toString());
    }

    public void setLiked(Boolean liked) {
        if (liked != null) {
            this.put(Field.LIKED.toString(), liked);
        } else {
            this.put(Field.LIKED.toString(), new Boolean(false));
        }
    }

    public ArrayList<IdentityRestOut> getLikedByIdentities() {
        return (ArrayList)this.get(Field.LIKED_BY_IDENTITIES.toString());
    }

    public void setLikedByIdentities(List<IdentityRestOut> likedByIdentities) {
        if (likedByIdentities != null) {
            this.put(Field.LIKED_BY_IDENTITIES.toString(), likedByIdentities);
        } else {
            this.put(Field.LIKED_BY_IDENTITIES.toString(), new ArrayList());
        }
    }

    public List<CommentRestOut> getComments() {
        return (List)this.get(Field.COMMENTS.toString());
    }

    public void setComments(List<CommentRestOut> comments) {
        if (comments != null) {
            this.put(Field.COMMENTS.toString(), comments);
        } else {
            this.put(Field.COMMENTS.toString(), new ArrayList());
        }
    }

    public Integer getTotalNumberOfComments() {
        return (Integer)this.get(Field.TOTAL_NUMBER_OF_COMMENTS.toString());
    }

    public void setTotalNumberOfComments(Integer numberOfComments) {
        if (numberOfComments != null) {
            this.put(Field.TOTAL_NUMBER_OF_COMMENTS.toString(), numberOfComments);
        } else {
            this.put(Field.TOTAL_NUMBER_OF_COMMENTS.toString(), new Integer(0));
        }
    }

    public IdentityRestOut getPosterIdentity() {
        return (IdentityRestOut)this.get(Field.POSTER_IDENTITY.toString());
    }

    public void setPosterIdentity(IdentityRestOut posterIdentity) {
        if (posterIdentity != null) {
            this.put(Field.POSTER_IDENTITY.toString(), posterIdentity);
        } else {
            this.put(Field.POSTER_IDENTITY.toString(), new HashMap());
        }
    }

    public String getIdentityId() {
        return (String)this.get(Field.IDENTITY_ID.toString());
    }

    public void setIdentityId(String identityId) {
        if (identityId != null) {
            this.put(Field.IDENTITY_ID.toString(), identityId);
        } else {
            this.put(Field.IDENTITY_ID.toString(), "");
        }
    }

    public ActivityStreamRestOut getActivityStream() {
        return (ActivityStreamRestOut)this.get(Field.ACTIVITY_STREAM.toString());
    }

    public void setActivityStream(ActivityStreamRestOut activityStream) {
        if (activityStream != null) {
            this.put(Field.ACTIVITY_STREAM.toString(), activityStream);
        } else {
            this.put(Field.ACTIVITY_STREAM.toString(), new HashMap());
        }
    }

    public Integer getTotalNumberOfLikes() {
        return (Integer)this.get(Field.TOTAL_NUMBER_OF_LIKES.toString());
    }

    public void setTotalNumberOfLikes(Integer totalNumberOfLikes) {
        if (totalNumberOfLikes != null) {
            this.put(Field.TOTAL_NUMBER_OF_LIKES.toString(), totalNumberOfLikes);
        } else {
            this.put(Field.TOTAL_NUMBER_OF_LIKES.toString(), new Integer(0));
        }
    }

    public void setNumberOfLikes(int numberOfLikes, ExoSocialActivity activity, String portalContainerName) {
        if (numberOfLikes <= 0) {
            return;
        }
        String[] likeIdentityIds = activity.getLikeIdentityIds();
        numberOfLikes = Math.min(numberOfLikes, likeIdentityIds.length);
        ArrayList<IdentityRestOut> identityRests = new ArrayList<IdentityRestOut>(numberOfLikes);
        for (int i = 0; i < numberOfLikes; ++i) {
            identityRests.add(new IdentityRestOut(likeIdentityIds[likeIdentityIds.length - i - 1], portalContainerName));
        }
        this.setLikedByIdentities(identityRests);
    }

    public void setNumberOfComments(int numberOfComments, ExoSocialActivity activity, String portalContainerName) {
        if (numberOfComments <= 0) {
            return;
        }
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        RealtimeListAccess rcla = activityManager.getCommentsWithListAccess(activity);
        ExoSocialActivity[] comments = (ExoSocialActivity[])rcla.load(0, numberOfComments);
        numberOfComments = Math.min(comments.length, numberOfComments);
        ArrayList<CommentRestOut> commentRests = new ArrayList<CommentRestOut>(numberOfComments);
        for (int i = 0; i < numberOfComments; ++i) {
            ExoSocialActivity currentComment = comments[i];
            CommentRestOut commentRestOut = new CommentRestOut(comments[i], portalContainerName);
            commentRestOut.setPosterIdentity(new IdentityRestOut(identityManager.getIdentity(currentComment.getUserId(), false)));
            commentRests.add(commentRestOut);
        }
        this.setComments(commentRests);
    }

    private void initialize() {
        this.setId("");
        this.setTitle("");
        this.setBody("");
        this.setPriority(new Float(0.0f));
        this.setAppId("");
        this.setType("");
        this.setPostedTime(new Long(0L));
        this.setCreatedAt("");
        this.setTitleId("");
        this.setTemplateParams(new HashMap<String, String>());
        this.setLiked(false);
        this.setLikedByIdentities(new ArrayList<IdentityRestOut>());
        this.setComments(new ArrayList<CommentRestOut>());
        this.setTotalNumberOfComments(0);
        this.setTotalNumberOfLikes(0);
        this.setPosterIdentity(null);
        this.setIdentityId("");
        this.setActivityStream(null);
    }

    public static enum Field {
        ID("id"),
        TITLE("title"),
        BODY("body"),
        PRIORITY("priority"),
        APPID("appId"),
        TYPE("type"),
        POSTED_TIME("postedTime"),
        CREATED_AT("createdAt"),
        LAST_UPDATED("lastUpdated"),
        TITLE_ID("titleId"),
        TEMPLATE_PARAMS("templateParams"),
        LIKED("liked"),
        LIKED_BY_IDENTITIES("likedByIdentities"),
        COMMENTS("comments"),
        TOTAL_NUMBER_OF_COMMENTS("totalNumberOfComments"),
        POSTER_IDENTITY("posterIdentity"),
        IDENTITY_ID("identityId"),
        ACTIVITY_STREAM("activityStream"),
        TOTAL_NUMBER_OF_LIKES("totalNumberOfLikes");

        private final String fieldName;

        private Field(String string2) {
            this.fieldName = string2;
        }

        public String toString() {
            return this.fieldName;
        }
    }
}

