/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.batch;

import com.google.api.client.googleapis.batch.BatchCallback;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.http.BackOffPolicy;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BatchUnparsedResponse {
    private final String boundary;
    private final List<BatchRequest.RequestInfo<?, ?>> requestInfos;
    private final BufferedReader bufferedReader;
    boolean hasNext = true;
    List<BatchRequest.RequestInfo<?, ?>> unsuccessfulRequestInfos = new ArrayList();
    boolean backOffRequired;
    private int contentId = 0;
    private final boolean retryAllowed;

    BatchUnparsedResponse(InputStream inputStream, String boundary, List<BatchRequest.RequestInfo<?, ?>> requestInfos, boolean retryAllowed) throws IOException {
        this.boundary = boundary;
        this.requestInfos = requestInfos;
        this.retryAllowed = retryAllowed;
        this.bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        this.checkForFinalBoundary(this.bufferedReader.readLine());
    }

    void parseNextResponse() throws IOException {
        String line;
        ++this.contentId;
        while ((line = this.bufferedReader.readLine()) != null && !line.equals("")) {
        }
        String statusLine = this.bufferedReader.readLine();
        String[] statusParts = statusLine.split(" ");
        int statusCode = Integer.parseInt(statusParts[1]);
        ArrayList<String> headerNames = new ArrayList<String>();
        ArrayList<String> headerValues = new ArrayList<String>();
        while ((line = this.bufferedReader.readLine()) != null && !line.equals("")) {
            String[] headerParts = line.split(": ", 2);
            headerNames.add(headerParts[0]);
            headerValues.add(headerParts[1]);
        }
        StringBuilder partContent = new StringBuilder();
        while ((line = this.bufferedReader.readLine()) != null && !line.startsWith(this.boundary)) {
            partContent.append(line);
        }
        HttpResponse response = this.getFakeResponse(statusCode, partContent.toString(), headerNames, headerValues);
        this.parseAndCallback(this.requestInfos.get(this.contentId - 1), statusCode, this.contentId, response);
        this.checkForFinalBoundary(line);
    }

    private <T, E> void parseAndCallback(BatchRequest.RequestInfo<T, E> requestInfo, int statusCode, int contentID, HttpResponse response) throws IOException {
        BatchCallback callback = requestInfo.callback;
        HttpHeaders responseHeaders = response.getHeaders();
        HttpUnsuccessfulResponseHandler unsuccessfulResponseHandler = requestInfo.request.getUnsuccessfulResponseHandler();
        BackOffPolicy backOffPolicy = requestInfo.request.getBackOffPolicy();
        this.backOffRequired = false;
        if (HttpStatusCodes.isSuccess((int)statusCode)) {
            if (callback == null) {
                return;
            }
            Object parsed = this.getParsedDataClass(requestInfo.dataClass, response, requestInfo, responseHeaders.getContentType());
            callback.onSuccess(parsed, responseHeaders);
        } else {
            HttpContent content = requestInfo.request.getContent();
            boolean retrySupported = this.retryAllowed && (content == null || content.retrySupported());
            boolean errorHandled = false;
            boolean redirectRequest = false;
            if (unsuccessfulResponseHandler != null) {
                errorHandled = unsuccessfulResponseHandler.handleResponse(requestInfo.request, response, retrySupported);
            }
            if (!errorHandled) {
                if (requestInfo.request.handleRedirect(response.getStatusCode(), response.getHeaders())) {
                    redirectRequest = true;
                } else if (retrySupported && backOffPolicy != null && backOffPolicy.isBackOffRequired(response.getStatusCode())) {
                    this.backOffRequired = true;
                }
            }
            if (retrySupported && (errorHandled || this.backOffRequired || redirectRequest)) {
                this.unsuccessfulRequestInfos.add(requestInfo);
            } else {
                if (callback == null) {
                    return;
                }
                Object parsed = this.getParsedDataClass(requestInfo.errorClass, response, requestInfo, responseHeaders.getContentType());
                callback.onFailure(parsed, responseHeaders);
            }
        }
    }

    private <A, T, E> A getParsedDataClass(Class<A> dataClass, HttpResponse response, BatchRequest.RequestInfo<T, E> requestInfo, String contentType) throws IOException {
        if (dataClass == Void.class) {
            return null;
        }
        return (A)requestInfo.request.getParser().parseAndClose(response.getContent(), response.getContentCharset(), dataClass);
    }

    @Deprecated
    private HttpResponse getFakeResponse(int statusCode, String partContent, List<String> headerNames, List<String> headerValues) throws IOException {
        HttpRequest request = new FakeResponseHttpTransport(statusCode, partContent, headerNames, headerValues).createRequestFactory().buildPostRequest(new GenericUrl("http://google.com/"), null);
        request.setLoggingEnabled(false);
        request.setThrowExceptionOnExecuteError(false);
        return request.execute();
    }

    private void checkForFinalBoundary(String boundaryLine) throws IOException {
        if (boundaryLine.equals(this.boundary + "--")) {
            this.hasNext = false;
            this.bufferedReader.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    private static class FakeLowLevelHttpResponse
    extends LowLevelHttpResponse {
        private InputStream partContent;
        private int statusCode;
        private List<String> headerNames = new ArrayList<String>();
        private List<String> headerValues = new ArrayList<String>();

        FakeLowLevelHttpResponse(InputStream partContent, int statusCode, List<String> headerNames, List<String> headerValues) {
            this.partContent = partContent;
            this.statusCode = statusCode;
            this.headerNames = headerNames;
            this.headerValues = headerValues;
        }

        public InputStream getContent() {
            return this.partContent;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getContentEncoding() {
            return null;
        }

        public long getContentLength() {
            return 0L;
        }

        public String getContentType() {
            return null;
        }

        public String getStatusLine() {
            return null;
        }

        public String getReasonPhrase() {
            return null;
        }

        public int getHeaderCount() {
            return this.headerNames.size();
        }

        public String getHeaderName(int index) {
            return this.headerNames.get(index);
        }

        public String getHeaderValue(int index) {
            return this.headerValues.get(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    private static class FakeLowLevelHttpRequest
    extends LowLevelHttpRequest {
        private String partContent;
        private int statusCode;
        private List<String> headerNames;
        private List<String> headerValues;

        FakeLowLevelHttpRequest(String partContent, int statusCode, List<String> headerNames, List<String> headerValues) {
            this.partContent = partContent;
            this.statusCode = statusCode;
            this.headerNames = headerNames;
            this.headerValues = headerValues;
        }

        public void addHeader(String name, String value) {
        }

        public void setContent(HttpContent content) {
        }

        public LowLevelHttpResponse execute() {
            FakeLowLevelHttpResponse response = new FakeLowLevelHttpResponse(new ByteArrayInputStream(StringUtils.getBytesUtf8((String)this.partContent)), this.statusCode, this.headerNames, this.headerValues);
            return response;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    private static class FakeResponseHttpTransport
    extends HttpTransport {
        private int statusCode;
        private String partContent;
        private List<String> headerNames;
        private List<String> headerValues;

        FakeResponseHttpTransport(int statusCode, String partContent, List<String> headerNames, List<String> headerValues) {
            this.statusCode = statusCode;
            this.partContent = partContent;
            this.headerNames = headerNames;
            this.headerValues = headerValues;
        }

        protected LowLevelHttpRequest buildRequest(String method, String url) {
            return new FakeLowLevelHttpRequest(this.partContent, this.statusCode, this.headerNames, this.headerValues);
        }
    }
}

