/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.model;

import org.exoplatform.social.core.identity.model.GlobalId;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLoader;

public class Identity
implements Cloneable {
    String id;
    String remoteId;
    String providerId;
    boolean isDeleted;
    private boolean isEnable;
    volatile Profile profile;
    private volatile ProfileLoader profileLoader;
    GlobalId globalId;

    public Identity(String id) {
        this.id = id;
        this.isEnable = true;
    }

    public Identity(String providerId, String remoteId) {
        this.remoteId = remoteId;
        this.providerId = providerId;
        this.isEnable = true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean isEnable) {
        this.isEnable = isEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile getProfile() {
        if (this.profile == null) {
            if (this.profileLoader == null) {
                this.profile = new Profile(this);
            } else {
                Identity identity = this;
                synchronized (identity) {
                    if (this.profile == null) {
                        this.profile = this.profileLoader.load();
                        this.profileLoader = null;
                    }
                }
            }
        }
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public void setProfileLoader(ProfileLoader profileLoader) {
        this.profileLoader = profileLoader;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String toString() {
        return this.getGlobalId().toString();
    }

    public GlobalId getGlobalId() {
        if (this.globalId == null) {
            this.globalId = GlobalId.create(this.providerId, this.remoteId);
        }
        return this.globalId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    protected Identity clone() throws CloneNotSupportedException {
        return (Identity)super.clone();
    }
}

