/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;

public class ProfileESListenerImpl
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(ProfileESListenerImpl.class);

    @Override
    public void avatarUpdated(ProfileLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getProfile().getIdentity().getId();
        LOG.info("Notifying indexing service for profile avatar update id={}", new Object[]{id});
        indexingService.reindex("profile", id);
    }

    @Override
    public void bannerUpdated(ProfileLifeCycleEvent event) {
        LOG.debug("Profile banner of user {} has been updated", new Object[]{event.getProfile().getIdentity().getId()});
    }

    @Override
    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getProfile().getIdentity().getId();
        LOG.info("Notifying indexing service for the profile contact update id={}", new Object[]{id});
        indexingService.reindex("profile", id);
    }

    @Override
    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
        String id = event.getProfile().getIdentity().getId();
        LOG.info("Notifying indexing service for the profile aboutme update id={}", new Object[]{id});
        ((IndexingService)CommonsUtils.getService(IndexingService.class)).reindex("profile", id);
    }

    @Override
    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        String id = event.getProfile().getIdentity().getId();
        LOG.info("Notifying indexing service for the profile experience update id={}", new Object[]{id});
        ((IndexingService)CommonsUtils.getService(IndexingService.class)).reindex("profile", id);
    }

    @Override
    public void createProfile(ProfileLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getProfile().getIdentity().getId();
        LOG.info("Notifying indexing service for the profile creation id={}", new Object[]{id});
        indexingService.index("profile", id);
    }
}

