/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.entity.AppEntity;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.storage.entity.ProfileExperienceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EntityConverterUtils {
    private static final Log LOG = ExoLogger.getLogger(EntityConverterUtils.class);

    public static Identity convertToIdentity(IdentityEntity entity) {
        return EntityConverterUtils.convertToIdentity(entity, true);
    }

    public static Identity convertToIdentity(IdentityEntity entity, boolean mapDeleted) {
        if (entity.isDeleted() && !mapDeleted) {
            return null;
        }
        Identity identity = new Identity(entity.getStringId());
        EntityConverterUtils.mapToIdentity(entity, identity);
        return identity;
    }

    public static void mapToIdentity(IdentityEntity entity, Identity identity) {
        identity.setProviderId(entity.getProviderId());
        identity.setRemoteId(entity.getRemoteId());
        identity.setProfile(EntityConverterUtils.convertToProfile(entity, identity));
        identity.setEnable(entity.isEnabled());
        identity.setDeleted(entity.isDeleted());
    }

    public static Profile convertToProfile(IdentityEntity entity, Identity identity) {
        Profile p = new Profile(identity);
        p.setId(String.valueOf(identity.getId()));
        EntityConverterUtils.mapToProfile(entity, p);
        if ("organization".equals(identity.getProviderId()) && p.getProperty("username") == null) {
            p.getProperties().put("username", identity.getRemoteId());
        }
        return p;
    }

    public static void mapToProfile(IdentityEntity entity, Profile p) {
        Map<String, String> properties = entity.getProperties();
        Map<String, Object> props = p.getProperties();
        String providerId = entity.getProviderId();
        Identity identity = p.getIdentity();
        if (!"organization".equals(providerId) && !"space".equals(providerId)) {
            p.setUrl(properties.get("Url"));
            p.setAvatarUrl(LinkProvider.buildAvatarURL(identity.getProviderId(), identity.getRemoteId()));
            p.setBannerUrl(LinkProvider.buildBannerURL(identity.getProviderId(), identity.getRemoteId()));
        } else {
            Long lastUpdated;
            String remoteId = entity.getRemoteId();
            if ("organization".equals(providerId)) {
                p.setUrl(LinkProvider.getUserProfileUri(remoteId));
            } else if ("space".equals(providerId)) {
                p.setUrl(LinkProvider.getSpaceUri(remoteId));
            }
            if (entity.getAvatarFileId() != null && entity.getAvatarFileId() > 0L) {
                p.setAvatarUrl(LinkProvider.buildAvatarURL(identity.getProviderId(), identity.getRemoteId()));
                lastUpdated = EntityConverterUtils.getFileLastUpdated(entity.getAvatarFileId());
                if (lastUpdated != null) {
                    p.setAvatarLastUpdated(lastUpdated);
                }
            }
            if (entity.getBannerFileId() != null && entity.getBannerFileId() > 0L) {
                p.setBannerUrl(LinkProvider.buildBannerURL(identity.getProviderId(), identity.getRemoteId()));
                lastUpdated = EntityConverterUtils.getFileLastUpdated(entity.getBannerFileId());
                if (lastUpdated != null) {
                    p.setBannerLastUpdated(lastUpdated);
                }
            }
        }
        StringBuilder skills = new StringBuilder();
        StringBuilder positions = new StringBuilder();
        Set<ProfileExperienceEntity> experiences = entity.getExperiences();
        if (experiences != null && experiences.size() > 0) {
            ArrayList xpData = new ArrayList();
            for (ProfileExperienceEntity exp : experiences) {
                HashMap<String, Object> xpMap = new HashMap<String, Object>();
                if (exp.getSkills() != null && !exp.getSkills().isEmpty()) {
                    skills.append(exp.getSkills()).append(",");
                }
                if (exp.getPosition() != null && !exp.getPosition().isEmpty()) {
                    positions.append(exp.getPosition()).append(",");
                }
                xpMap.put("id", String.valueOf(exp.getId()));
                xpMap.put("skills", exp.getSkills());
                xpMap.put("position", exp.getPosition());
                xpMap.put("startDate", exp.getStartDate());
                xpMap.put("endDate", exp.getEndDate());
                xpMap.put("company", exp.getCompany());
                xpMap.put("description", exp.getDescription());
                xpMap.put("isCurrent", exp.isCurrent());
                xpData.add(xpMap);
            }
            props.put("experiences", xpData);
        }
        if (skills.length() > 0) {
            skills.deleteCharAt(skills.length() - 1);
            props.put("skills", skills.toString());
        }
        if (positions.length() > 0) {
            positions.deleteCharAt(positions.length() - 1);
            props.put("position", positions.toString());
        }
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if ("ims".equals(key) || "phones".equals(key) || "urls".equals(key)) {
                    ArrayList list = new ArrayList();
                    try {
                        JSONArray arr = new JSONArray(value);
                        for (int i = 0; i < arr.length(); ++i) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            JSONObject json = arr.getJSONObject(i);
                            Iterator keys = json.keys();
                            while (keys.hasNext()) {
                                String k = (String)keys.next();
                                map.put(k, json.optString(k));
                            }
                            list.add(map);
                        }
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    props.put(key, list);
                    continue;
                }
                if ("Url".equals(key)) continue;
                props.put(key, value);
            }
        }
        p.setCreatedTime(entity.getCreatedDate().getTime());
        p.setLastLoaded(System.currentTimeMillis());
    }

    public static void mapToEntity(Identity identity, IdentityEntity entity) {
        entity.setProviderId(identity.getProviderId());
        entity.setRemoteId(identity.getRemoteId());
        entity.setEnabled(identity.isEnable());
        entity.setDeleted(identity.isDeleted());
    }

    public static long parseId(String id) {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    public static List<IdentityWithRelationship> convertToIdentitiesWithRelationship(ListAccess<Map.Entry<IdentityEntity, ConnectionEntity>> list, int offset, int limit) {
        try {
            if (list == null) {
                return Collections.emptyList();
            }
            Map.Entry[] entities = (Map.Entry[])list.load(offset, limit);
            ArrayList<IdentityWithRelationship> result = new ArrayList<IdentityWithRelationship>(limit);
            for (Map.Entry tuple : entities) {
                IdentityEntity identityEntity = (IdentityEntity)tuple.getKey();
                ConnectionEntity connectionEntity = (ConnectionEntity)tuple.getValue();
                IdentityWithRelationship identityWithRelationship = new IdentityWithRelationship(identityEntity.getStringId());
                EntityConverterUtils.mapToIdentity(identityEntity, identityWithRelationship);
                Relationship relationship = EntityConverterUtils.convertRelationshipItemToRelationship(connectionEntity);
                identityWithRelationship.setRelationship(relationship);
                result.add(identityWithRelationship);
            }
            return result;
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public static List<Identity> convertToIdentities(ListAccess<IdentityEntity> list, long offset, long limit) {
        try {
            return EntityConverterUtils.convertToIdentities((IdentityEntity[])list.load((int)offset, (int)limit));
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public static List<Identity> convertToIdentities(IdentityEntity[] entities) {
        if (entities == null || entities.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Identity> result = new ArrayList<Identity>(entities.length);
        for (IdentityEntity entity : entities) {
            Identity idt = EntityConverterUtils.convertToIdentity(entity);
            if (idt == null) continue;
            result.add(idt);
        }
        return result;
    }

    public static SpaceEntity buildFrom(Space space, SpaceEntity spaceEntity) {
        spaceEntity.setApp(AppEntity.parse(space.getApp()));
        if (space.getAvatarLastUpdated() != null) {
            spaceEntity.setAvatarLastUpdated(space.getAvatarLastUpdated() > 0L ? new Date(space.getAvatarLastUpdated()) : null);
        } else {
            spaceEntity.setAvatarLastUpdated(null);
        }
        if (space.getBannerLastUpdated() != null) {
            spaceEntity.setBannerLastUpdated(space.getBannerLastUpdated() > 0L ? new Date(space.getBannerLastUpdated()) : null);
        } else {
            spaceEntity.setBannerLastUpdated(null);
        }
        spaceEntity.setCreatedDate(space.getCreatedTime() > 0L ? new Date(space.getCreatedTime()) : new Date());
        spaceEntity.setDescription(space.getDescription());
        spaceEntity.setTemplate(space.getTemplate());
        spaceEntity.setDisplayName(space.getDisplayName());
        spaceEntity.setGroupId(space.getGroupId());
        spaceEntity.setPrettyName(space.getPrettyName());
        SpaceEntity.PRIORITY priority = null;
        if ("1".equals(space.getPriority())) {
            priority = SpaceEntity.PRIORITY.HIGH;
        } else if ("2".equals(space.getPriority())) {
            priority = SpaceEntity.PRIORITY.INTERMEDIATE;
        } else if ("3".equals(space.getPriority())) {
            priority = SpaceEntity.PRIORITY.LOW;
        }
        spaceEntity.setPriority(priority);
        if (space.getRegistration() != null) {
            spaceEntity.setRegistration(SpaceEntity.REGISTRATION.valueOf(space.getRegistration().toUpperCase()));
        }
        spaceEntity.setUrl(space.getUrl());
        SpaceEntity.VISIBILITY visibility = null;
        if (space.getVisibility() != null) {
            visibility = SpaceEntity.VISIBILITY.valueOf(space.getVisibility().toUpperCase());
        }
        spaceEntity.setVisibility(visibility);
        EntityConverterUtils.buildMembers(space, spaceEntity);
        return spaceEntity;
    }

    public static Relationship convertRelationshipItemToRelationship(ConnectionEntity item) {
        if (item == null) {
            return null;
        }
        Relationship relationship = new Relationship(Long.toString(item.getId()));
        relationship.setId(String.valueOf(item.getId()));
        relationship.setSender(EntityConverterUtils.convertToIdentity(item.getSender()));
        relationship.setReceiver(EntityConverterUtils.convertToIdentity(item.getReceiver()));
        relationship.setStatus(item.getStatus());
        return relationship;
    }

    private static Long getFileLastUpdated(Long fileId) {
        FileService fileService = (FileService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FileService.class);
        if (fileService != null) {
            FileInfo fileInfo = fileService.getFileInfo(fileId.longValue());
            if (fileInfo != null && fileInfo.getUpdatedDate() != null) {
                return fileInfo.getUpdatedDate().getTime();
            }
            return null;
        }
        LOG.warn((Object)"File service is null");
        return null;
    }

    private static String[] getPendingMembersId(SpaceEntity spaceEntity) {
        return EntityConverterUtils.getUserIds(spaceEntity, SpaceMemberEntity.Status.PENDING);
    }

    private static String[] getInvitedMembersId(SpaceEntity spaceEntity) {
        return EntityConverterUtils.getUserIds(spaceEntity, SpaceMemberEntity.Status.INVITED);
    }

    private static String[] getMembersId(SpaceEntity spaceEntity) {
        return EntityConverterUtils.getUserIds(spaceEntity, SpaceMemberEntity.Status.MEMBER);
    }

    private static String[] getManagerMembersId(SpaceEntity spaceEntity) {
        return EntityConverterUtils.getUserIds(spaceEntity, SpaceMemberEntity.Status.MANAGER);
    }

    private static void buildMembers(Space space, SpaceEntity spaceEntity) {
        Set<SpaceMemberEntity> invited = EntityConverterUtils.getMembers(spaceEntity, SpaceMemberEntity.Status.INVITED);
        EntityConverterUtils.merge(spaceEntity, invited, space.getInvitedUsers(), SpaceMemberEntity.Status.INVITED);
        Set<SpaceMemberEntity> manager = EntityConverterUtils.getMembers(spaceEntity, SpaceMemberEntity.Status.MANAGER);
        EntityConverterUtils.merge(spaceEntity, manager, space.getManagers(), SpaceMemberEntity.Status.MANAGER);
        Set<SpaceMemberEntity> member = EntityConverterUtils.getMembers(spaceEntity, SpaceMemberEntity.Status.MEMBER);
        EntityConverterUtils.merge(spaceEntity, member, space.getMembers(), SpaceMemberEntity.Status.MEMBER);
        Set<SpaceMemberEntity> pending = EntityConverterUtils.getMembers(spaceEntity, SpaceMemberEntity.Status.PENDING);
        EntityConverterUtils.merge(spaceEntity, pending, space.getPendingUsers(), SpaceMemberEntity.Status.PENDING);
    }

    private static void merge(SpaceEntity spaceEntity, Set<SpaceMemberEntity> spaceMembers, String[] userIds, SpaceMemberEntity.Status status) {
        HashSet ids = new HashSet(userIds != null ? Arrays.asList(userIds) : Collections.emptyList());
        for (SpaceMemberEntity mem : spaceMembers) {
            String id = mem.getUserId();
            if (ids.contains(mem.getUserId())) {
                ids.remove(id);
                continue;
            }
            spaceEntity.getMembers().remove(mem);
        }
        for (String id : ids) {
            if (!StringUtils.isNotBlank((String)id)) continue;
            spaceEntity.getMembers().add(new SpaceMemberEntity(spaceEntity, id, status));
        }
    }

    private static Set<SpaceMemberEntity> getMembers(SpaceEntity spaceEntity, SpaceMemberEntity.Status status) {
        HashSet<SpaceMemberEntity> mems = new HashSet<SpaceMemberEntity>();
        for (SpaceMemberEntity mem : spaceEntity.getMembers()) {
            if (!mem.getStatus().equals((Object)status)) continue;
            mems.add(mem);
        }
        return mems;
    }

    private static String[] getUserIds(SpaceEntity spaceEntity, SpaceMemberEntity.Status status) {
        LinkedList<String> ids = new LinkedList<String>();
        for (SpaceMemberEntity mem : EntityConverterUtils.getMembers(spaceEntity, status)) {
            ids.add(mem.getUserId());
        }
        return ids.toArray(new String[ids.size()]);
    }
}

