/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialMembershipListenerImpl
extends MembershipEventListener {
    public void postDelete(Membership m) throws Exception {
        if (m.getGroupId().startsWith("/spaces")) {
            OrganizationService orgService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            UserACL acl = (UserACL)CommonsUtils.getService(UserACL.class);
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceByGroupId(m.getGroupId());
            if (space != null) {
                boolean hasMemberMembership;
                boolean hasAllMembership;
                ConversationState state = ConversationState.getCurrent();
                if (state != null && state.getIdentity() != null && space.getEditor() == null) {
                    space.setEditor(state.getIdentity().getUserId());
                }
                boolean hasManagerMembership = (hasAllMembership = SpaceUtils.isUserHasMembershipTypesInGroup(m.getUserName(), m.getGroupId(), "*")) || SpaceUtils.isUserHasMembershipTypesInGroup(m.getUserName(), m.getGroupId(), acl.getAdminMSType());
                boolean bl = hasMemberMembership = hasManagerMembership || SpaceUtils.isUserHasMembershipTypesInGroup(m.getUserName(), m.getGroupId(), "member");
                if (!hasManagerMembership) {
                    spaceService.setManager(space, m.getUserName(), false);
                }
                if (!hasMemberMembership) {
                    spaceService.removeMember(space, m.getUserName());
                }
                SpaceUtils.refreshNavigation();
            }
        } else if (m.getGroupId().startsWith("/platform/users")) {
            this.clearIdentityCaching();
        }
    }

    public void postSave(Membership m, boolean isNew) throws Exception {
        if (m.getGroupId().startsWith("/spaces")) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            UserACL acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
            SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
            Space space = spaceService.getSpaceByGroupId(m.getGroupId());
            if (space != null) {
                ConversationState state = ConversationState.getCurrent();
                if (state != null && state.getIdentity() != null && space.getEditor() == null) {
                    space.setEditor(state.getIdentity().getUserId());
                }
                String userName = m.getUserName();
                if (acl.getAdminMSType().equalsIgnoreCase(m.getMembershipType()) || "*".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isManager(space, userName)) {
                        return;
                    }
                    if (spaceService.isMember(space, userName)) {
                        spaceService.setManager(space, userName, true);
                    } else {
                        spaceService.addMember(space, userName);
                        spaceService.setManager(space, userName, true);
                    }
                } else if ("member".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isMember(space, userName)) {
                        return;
                    }
                    spaceService.addMember(space, userName);
                }
                SpaceUtils.refreshNavigation();
            }
        } else if (m.getGroupId().startsWith("/platform/users")) {
            this.clearIdentityCaching();
        }
    }

    private void clearIdentityCaching() {
        IdentityStorage storage = (IdentityStorage)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityStorage.class);
        storage.updateIdentityMembership(null);
    }
}

