/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialUserProfileEventListenerImpl
extends UserProfileEventListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(UserProfile userProfile, boolean isNew) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ArrayList<Profile.UpdateType> list;
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity("organization", userProfile.getUserName(), true);
            Profile profile = identity.getProfile();
            String uGender = null;
            String uPosition = null;
            if (userProfile != null) {
                uGender = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[4]);
                uPosition = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[7]);
            }
            String pGender = (String)profile.getProperty("gender");
            String pPosition = (String)profile.getProperty("position");
            boolean hasUpdated = false;
            if (!StringUtils.equals((CharSequence)uGender, (CharSequence)pGender)) {
                profile.setProperty("gender", uGender);
                list = new ArrayList<Profile.UpdateType>();
                list.add(Profile.UpdateType.CONTACT);
                profile.setListUpdateTypes(list);
                hasUpdated = true;
            }
            if (!StringUtils.equals((CharSequence)uPosition, (CharSequence)pPosition)) {
                profile.setProperty("position", uPosition);
                list = new ArrayList();
                list.add(Profile.UpdateType.CONTACT);
                profile.setListUpdateTypes(list);
                hasUpdated = true;
            }
            if (hasUpdated && !isNew) {
                IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
                identityManager.updateProfile(profile);
            }
            if (isNew) {
                IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
                identityStorage.updateProfile(profile);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

