/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.ActivitiesRealtimeListAccess;
import org.exoplatform.social.core.activity.ActivityLifeCycle;
import org.exoplatform.social.core.activity.ActivityListener;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.CommentsRealtimeListAccess;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;

public class ActivityManagerImpl
implements ActivityManager {
    private static final Log LOG = ExoLogger.getLogger(ActivityManagerImpl.class);
    protected ActivityStorage activityStorage;
    protected IdentityManager identityManager;
    private UserACL userACL;
    protected SpaceService spaceService;
    private FileService fileService;
    protected ActivityLifeCycle activityLifeCycle = new ActivityLifeCycle();
    private static final int DEFAULT_LIMIT = 20;
    private static Map<String, Boolean> activityTypesRegistry = new HashMap<String, Boolean>();
    private static final String ACTIVITY_TYPE_PROPERTY_PATTERN = "exo\\.activity-type\\..*\\.enabled";
    private static final String PREFIX = "exo.activity-type.";
    private static final String SUFFIX = ".enabled";
    public static final String ENABLE_EDIT_ACTIVITY = "exo.edit.activity.enabled";
    public static final String ENABLE_EDIT_COMMENT = "exo.edit.comment.enabled";
    public static final String ENABLE_MANAGER_EDIT_ACTIVITY = "exo.manager.edit.activity.enabled";
    public static final String ENABLE_MANAGER_EDIT_COMMENT = "exo.manager.edit.comment.enabled";
    private int maxUploadSize = 10;
    private boolean enableEditActivity = true;
    private boolean enableEditComment = true;
    private boolean enableManagerEditActivity = true;
    private boolean enableManagerEditComment = true;
    public static final List<String> AUTOMATIC_EDIT_TITLE_ACTIVITIES = Arrays.asList("has_joined", "space_avatar_edited", "space_description_edited", "space_renamed", "manager_role_revoked", "manager_role_granted");
    public static final String SEPARATOR_REGEX = "\\|@\\|";
    public static final String ID = "id";
    public static final String STORAGE = "storage";
    public static final String FILE = "file";

    public ActivityManagerImpl(ActivityStorage activityStorage, IdentityManager identityManager, UserACL userACL, FileService fileService, InitParams params) {
        this.activityStorage = activityStorage;
        this.identityManager = identityManager;
        this.userACL = userACL;
        this.fileService = fileService;
        this.initActivityTypes();
        if (params != null) {
            if (params.containsKey((Object)"upload.limit.size") && StringUtils.isNotBlank((CharSequence)params.getValueParam("upload.limit.size").getValue())) {
                this.maxUploadSize = Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
            }
            if (params.containsKey((Object)ENABLE_EDIT_ACTIVITY)) {
                this.enableEditActivity = Boolean.parseBoolean(params.getValueParam(ENABLE_EDIT_ACTIVITY).getValue());
            }
            if (params.containsKey((Object)ENABLE_EDIT_COMMENT)) {
                this.enableEditComment = Boolean.parseBoolean(params.getValueParam(ENABLE_EDIT_COMMENT).getValue());
            }
            if (params.containsKey((Object)ENABLE_MANAGER_EDIT_ACTIVITY)) {
                this.enableManagerEditActivity = Boolean.parseBoolean(params.getValueParam(ENABLE_MANAGER_EDIT_ACTIVITY).getValue());
            }
            if (params.containsKey((Object)ENABLE_MANAGER_EDIT_COMMENT)) {
                this.enableManagerEditComment = Boolean.parseBoolean(params.getValueParam(ENABLE_MANAGER_EDIT_COMMENT).getValue());
            }
        } else {
            String maxUploadString = System.getProperty("wcm.connector.drives.uploadLimit");
            if (StringUtils.isNotBlank((CharSequence)maxUploadString)) {
                this.maxUploadSize = Integer.parseInt(maxUploadString);
            }
        }
    }

    @Override
    public void saveActivityNoReturn(org.exoplatform.social.core.identity.model.Identity streamOwner, ExoSocialActivity newActivity) {
        if (!streamOwner.isEnable()) {
            LOG.warn((Object)"Activity could not be saved. Owner has been disabled.");
            return;
        }
        if (newActivity.getType() != null && activityTypesRegistry.get(newActivity.getType()) != null && !activityTypesRegistry.get(newActivity.getType()).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activity could not be saved. Activity Type {} has been disabled.", new Object[]{newActivity.getType()});
            }
            return;
        }
        this.activityStorage.saveActivity(streamOwner, newActivity);
        this.activityLifeCycle.saveActivity(newActivity);
    }

    @Override
    public void saveActivityNoReturn(ExoSocialActivity newActivity) {
        org.exoplatform.social.core.identity.model.Identity owner = this.getStreamOwner(newActivity);
        this.saveActivityNoReturn(owner, newActivity);
    }

    @Override
    public void saveActivity(org.exoplatform.social.core.identity.model.Identity streamOwner, String activityType, String activityTitle) {
        if (activityType != null && activityTypesRegistry.get(activityType) != null && !activityTypesRegistry.get(activityType).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activity could not be saved. Activity Type {} has been disabled.", new Object[]{activityType});
            }
            return;
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType(activityType);
        activity.setTitle(activityTitle);
        this.saveActivity(streamOwner, activity);
    }

    @Override
    public ExoSocialActivity getActivity(String activityId) {
        return this.activityStorage.getActivity(activityId);
    }

    @Override
    public ExoSocialActivity getParentActivity(ExoSocialActivity comment) {
        return this.activityStorage.getParentActivity(comment);
    }

    @Override
    public List<ExoSocialActivity> getSubComments(ExoSocialActivity comment) {
        return this.activityStorage.getSubComments(comment);
    }

    @Override
    public void updateActivity(ExoSocialActivity existingActivity) {
        this.updateActivity(existingActivity, true);
    }

    @Override
    public void updateActivity(ExoSocialActivity existingActivity, boolean broadcast) {
        String activityId = existingActivity.getId();
        CharSequence[] previousMentions = this.getActivity(activityId).getMentionedIds();
        this.activityStorage.updateActivity(existingActivity);
        if (previousMentions.length > 0) {
            String mentions = String.join((CharSequence)",", previousMentions);
            HashMap<String, String> mentionsTemplateParams = existingActivity.getTemplateParams() != null ? existingActivity.getTemplateParams() : new HashMap<String, String>();
            mentionsTemplateParams.put("PreviousMentions", mentions);
            existingActivity.setTemplateParams(mentionsTemplateParams);
        }
        if (broadcast) {
            this.activityLifeCycle.updateActivity(existingActivity);
        }
    }

    @Override
    public void deleteActivity(ExoSocialActivity existingActivity) {
        Validate.notNull((Object)existingActivity.getId(), (String)"existingActivity.getId() must not be null!");
        this.deleteActivity(existingActivity.getId());
    }

    @Override
    public void deleteActivity(String activityId) {
        this.activityStorage.deleteActivity(activityId);
    }

    @Override
    public void saveComment(ExoSocialActivity existingActivity, ExoSocialActivity newComment) {
        boolean activityTypeDisabled;
        if (existingActivity == null) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_SAVE_COMMENT, "Activity cannot be NULL");
        }
        if (existingActivity.getId() == null) {
            LOG.debug((Object)"Comment could not be saved because activity id is null.");
            return;
        }
        String activityType = existingActivity.getType();
        String commentActivityType = newComment.getType();
        String commentId = newComment.getId();
        boolean commentActivityTypeDisabled = commentActivityType != null && activityTypesRegistry.containsKey(commentActivityType) && activityTypesRegistry.get(commentActivityType) == Boolean.FALSE;
        boolean bl = activityTypeDisabled = activityType != null && activityTypesRegistry.containsKey(activityType) && activityTypesRegistry.get(activityType) == Boolean.FALSE;
        if (commentActivityTypeDisabled || activityTypeDisabled) {
            if (LOG.isDebugEnabled()) {
                if (activityTypeDisabled) {
                    LOG.debug("Comment could not be saved. Activity Type {} is disabled.", new Object[]{activityType});
                }
                if (commentActivityTypeDisabled) {
                    LOG.debug("Comment could not be saved. Comment activity Type {} is disabled.", new Object[]{commentActivityType});
                }
            }
            return;
        }
        CharSequence[] previousMentions = StringUtils.isEmpty((CharSequence)commentId) ? new String[]{} : this.getActivity(commentId).getMentionedIds();
        this.activityStorage.saveComment(existingActivity, newComment);
        if (StringUtils.isEmpty((CharSequence)commentId)) {
            this.activityLifeCycle.saveComment(newComment);
        } else {
            if (previousMentions.length > 0) {
                String mentions = String.join((CharSequence)",", previousMentions);
                HashMap<String, String> mentionsTemplateParams = newComment.getTemplateParams() != null ? newComment.getTemplateParams() : new HashMap<String, String>();
                mentionsTemplateParams.put("PreviousMentions", mentions);
                newComment.setTemplateParams(mentionsTemplateParams);
            }
            this.activityLifeCycle.updateComment(newComment);
        }
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity existingActivity, boolean loadSubComments) {
        return new CommentsRealtimeListAccess(this.activityStorage, existingActivity, loadSubComments);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity existingActivity) {
        return new CommentsRealtimeListAccess(this.activityStorage, existingActivity);
    }

    @Override
    public void deleteComment(String activityId, String commentId) {
        this.activityStorage.deleteComment(activityId, commentId);
    }

    @Override
    public void deleteComment(ExoSocialActivity existingActivity, ExoSocialActivity existingComment) {
        this.deleteComment(existingActivity.getId(), existingComment.getId());
    }

    @Override
    public void saveLike(ExoSocialActivity existingActivity, org.exoplatform.social.core.identity.model.Identity identity) {
        Object[] identityIds = existingActivity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            LOG.warn((Object)("activity is already liked by identity: " + identity));
            return;
        }
        identityIds = (String[])ArrayUtils.add((Object[])identityIds, (Object)identity.getId());
        existingActivity.setLikeIdentityIds((String[])identityIds);
        this.updateActivity(existingActivity, false);
        if (existingActivity.isComment()) {
            this.activityLifeCycle.likeComment(existingActivity);
        } else {
            this.activityLifeCycle.likeActivity(existingActivity);
        }
    }

    @Override
    public void deleteLike(ExoSocialActivity activity, org.exoplatform.social.core.identity.model.Identity identity) {
        activity.setTitle(null);
        activity.setBody(null);
        activity.setTemplateParams(null);
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            identityIds = (String[])ArrayUtils.removeElement((Object[])identityIds, (Object)identity.getId());
            activity.setLikeIdentityIds((String[])identityIds);
            this.updateActivity(activity, false);
        } else {
            LOG.warn((Object)("activity is not liked by identity: " + identity));
        }
    }

    @Override
    public void addActivityEventListener(ActivityListenerPlugin activityListenerPlugin) {
        this.registerActivityListener(activityListenerPlugin);
    }

    public void registerActivityListener(ActivityListener listener) {
        this.activityLifeCycle.addListener(listener);
    }

    public void unregisterActivityListener(ActivityListener listener) {
        this.activityLifeCycle.removeListener(listener);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.USER_ACTIVITIES, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(org.exoplatform.social.core.identity.model.Identity ownerIdentity, org.exoplatform.social.core.identity.model.Identity viewerIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.VIEW_USER_ACTIVITIES, ownerIdentity, viewerIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfConnectionsWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.CONNECTIONS_ACTIVITIES, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfUserSpacesWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.USER_SPACE_ACTIVITIES, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfSpaceWithListAccess(org.exoplatform.social.core.identity.model.Identity existingSpaceIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.SPACE_ACTIVITIES, existingSpaceIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivityFeedWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.ACTIVITY_FEED, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(org.exoplatform.social.core.identity.model.Identity posterIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.POSTER_ACTIVITIES, posterIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(org.exoplatform.social.core.identity.model.Identity posterIdentity, String ... activityTypes) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.POSTER_AND_TYPES_ACTIVITIES, posterIdentity, activityTypes);
    }

    @Override
    public void addProcessor(ActivityProcessor processor) {
        this.activityStorage.getActivityProcessors().add(processor);
        LOG.debug((Object)("added activity processor " + processor.getClass()));
    }

    @Override
    public void addProcessorPlugin(BaseActivityProcessorPlugin plugin) {
        this.addProcessor(plugin);
    }

    public void initActivityTypes() {
        Properties properties = PropertyManager.getPropertiesByPattern((String)ACTIVITY_TYPE_PROPERTY_PATTERN);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String value = properties.getProperty(k.toString());
            String name = k.toString().substring(PREFIX.length(), k.toString().lastIndexOf(SUFFIX));
            if (value != null && value.equalsIgnoreCase("false")) {
                LOG.info("Activity Type key:  {},  registration status: disabled", new Object[]{name});
                activityTypesRegistry.putIfAbsent(name, false);
            } else {
                LOG.info("Activity Type key:  {},  registration status: enabled", new Object[]{name});
                activityTypesRegistry.putIfAbsent(name, true);
            }
        }));
    }

    @Override
    public ExoSocialActivity saveActivity(org.exoplatform.social.core.identity.model.Identity streamOwner, ExoSocialActivity newActivity) {
        ExoSocialActivity created = this.activityStorage.saveActivity(streamOwner, newActivity);
        this.activityLifeCycle.saveActivity(this.getActivity(created.getId()));
        return created;
    }

    @Override
    public ExoSocialActivity saveActivity(ExoSocialActivity newActivity) {
        this.saveActivityNoReturn(newActivity);
        return newActivity;
    }

    @Override
    public List<ExoSocialActivity> getActivities(org.exoplatform.social.core.identity.model.Identity identity) {
        List<ExoSocialActivity> activityList = Collections.emptyList();
        try {
            ExoSocialActivity[] activities = (ExoSocialActivity[])this.getActivitiesWithListAccess(identity).load(0, 20);
            activityList = Arrays.asList(activities);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get activities by identity: " + identity));
        }
        return activityList;
    }

    @Override
    public List<ExoSocialActivity> getActivities(org.exoplatform.social.core.identity.model.Identity identity, long start, long limit) {
        return this.activityStorage.getUserActivities(identity, start, limit);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfConnections(org.exoplatform.social.core.identity.model.Identity ownerIdentity) {
        List<ExoSocialActivity> activityList = Collections.emptyList();
        try {
            ExoSocialActivity[] activities = (ExoSocialActivity[])this.getActivitiesOfConnectionsWithListAccess(ownerIdentity).load(0, 30);
            activityList = Arrays.asList(activities);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get activities of connections!");
        }
        return activityList;
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfUserSpaces(org.exoplatform.social.core.identity.model.Identity ownerIdentity) {
        return this.getActivitiesOfUserSpacesWithListAccess(ownerIdentity).loadAsList(0, 20);
    }

    @Override
    public List<ExoSocialActivity> getActivityFeed(org.exoplatform.social.core.identity.model.Identity identity) {
        return this.getActivityFeedWithListAccess(identity).loadAsList(0, 40);
    }

    @Override
    public void removeLike(ExoSocialActivity existingActivity, org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        this.deleteLike(existingActivity, existingIdentity);
    }

    @Override
    public List<ExoSocialActivity> getComments(ExoSocialActivity existingActivity) {
        return this.getCommentsWithListAccess(existingActivity).loadAsList(0, 40);
    }

    @Override
    public ExoSocialActivity recordActivity(org.exoplatform.social.core.identity.model.Identity owner, String type, String title) {
        ExoSocialActivityImpl newActivity = new ExoSocialActivityImpl(owner.getId(), type, title);
        this.saveActivity(owner, newActivity);
        return newActivity;
    }

    @Override
    public int getActivitiesCount(org.exoplatform.social.core.identity.model.Identity owner) {
        return this.activityStorage.getNumberOfUserActivities(owner);
    }

    @Override
    public ExoSocialActivity recordActivity(org.exoplatform.social.core.identity.model.Identity owner, ExoSocialActivity activity) throws Exception {
        this.saveActivity(owner, activity);
        return activity;
    }

    @Override
    public ExoSocialActivity recordActivity(org.exoplatform.social.core.identity.model.Identity owner, String type, String title, String body) {
        String userId = owner.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userId, type, title, body);
        this.saveActivity(owner, activity);
        return activity;
    }

    private org.exoplatform.social.core.identity.model.Identity getStreamOwner(ExoSocialActivity newActivity) {
        Validate.notNull((Object)newActivity.getUserId(), (String)"activity.getUserId() must not be null!");
        return this.identityManager.getIdentity(newActivity.getUserId(), false);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getAllActivitiesWithListAccess() {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.ALL);
    }

    @Override
    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    @Override
    public List<ExoSocialActivity> getActivities(List<String> activityIdList) {
        return this.activityStorage.getActivities(activityIdList);
    }

    @Override
    public boolean isActivityEditable(ExoSocialActivity activity, Identity viewer) {
        if (activity != null) {
            boolean enableManagerEdit;
            boolean enableEdit;
            if (activity.isComment()) {
                enableEdit = this.enableEditComment;
                enableManagerEdit = this.enableManagerEditComment;
            } else {
                enableEdit = this.enableEditActivity;
                enableManagerEdit = this.enableManagerEditActivity;
            }
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", viewer.getUserId());
            if (enableEdit && identity != null && (StringUtils.equals((CharSequence)identity.getId(), (CharSequence)activity.getPosterId()) || enableManagerEdit && viewer.getGroups().contains(this.userACL.getAdminGroups()))) {
                return !activity.isComment() || !this.isAutomaticComment(activity);
            }
        }
        return false;
    }

    @Override
    public List<String> getActivityFilesIds(ExoSocialActivity activity) {
        ArrayList<String> values = new ArrayList<String>();
        if (activity != null) {
            String[] ids = this.getParameterValues(activity.getTemplateParams(), ID);
            String[] storages = this.getParameterValues(activity.getTemplateParams(), STORAGE);
            if (ids != null && ids.length > 0) {
                for (int i = 0; i < ids.length; ++i) {
                    if (storages == null || storages.length <= i || !storages[i].equals(FILE)) continue;
                    values.add(ids[i]);
                }
            }
        }
        return values;
    }

    @Override
    public ActivityFile getActivityFileById(long fileId) throws Exception {
        FileItem file = null;
        try {
            file = this.fileService.getFile(fileId);
        }
        catch (FileStorageException e) {
            LOG.error((Object)("Failed to  get the file with id : " + fileId), (Throwable)e);
        }
        return this.convertFileItemToActivityFile(file);
    }

    public boolean isAutomaticComment(ExoSocialActivity activity) {
        return activity != null && (!"exosocial:spaces".equals(activity.getType()) || "exosocial:spaces".equals(activity.getType()) && AUTOMATIC_EDIT_TITLE_ACTIVITIES.contains(activity.getTitleId()));
    }

    private String[] getParameterValues(Map<String, String> activityParams, String paramName) {
        String[] values = null;
        String value = activityParams.get(paramName);
        if (value == null) {
            value = activityParams.get(paramName.toLowerCase());
        }
        if (value != null) {
            values = value.split(SEPARATOR_REGEX);
        }
        return values;
    }

    private ActivityFile convertFileItemToActivityFile(FileItem fileItem) throws Exception {
        ActivityFile activityFile = new ActivityFile();
        activityFile.setInputStream(fileItem.getAsStream());
        activityFile.setName(fileItem.getFileInfo().getName());
        activityFile.setMimeType(fileItem.getFileInfo().getMimetype());
        long lastUpdated = fileItem.getFileInfo().getUpdatedDate() != null ? fileItem.getFileInfo().getUpdatedDate().getTime() : new Date().getTime();
        activityFile.setLastModified(lastUpdated);
        return activityFile;
    }

    @Override
    public boolean isActivityTypeEnabled(String activityType) {
        return activityTypesRegistry.get(activityType) == null || activityTypesRegistry.get(activityType) != false;
    }
}

