/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.organization.account.UIGroupSelector;

@ComponentConfigs(value={@ComponentConfig(template="war:/groovy/social/webui/space/UISocialGroupSelector.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={UIGroupSelector.ChangeNodeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIGroupSelector.SelectGroupActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={UIGroupSelector.SelectPathActionListener.class})}), @ComponentConfig(type=UITree.class, id="UITreeGroupSelector", template="system:/groovy/webui/core/UITree.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={UITree.ChangeNodeActionListener.class})}), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbGroupSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={UIBreadcumbs.SelectPathActionListener.class})})})
public class UISocialGroupSelector
extends UIGroupSelector {
    protected List<Group> getGroups(Group parentGroup) throws Exception {
        OrganizationService organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null && conversationState.getIdentity() != null) {
            return organizationService.getGroupHandler().findGroups(parentGroup).stream().filter(group -> userACL.hasPermission(conversationState.getIdentity(), group, "space_creation_invitation")).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }
}

