/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.page;

import java.io.Serializable;
import java.util.Formattable;
import java.util.Formatter;
import org.gatein.api.internal.Parameters;
import org.gatein.api.security.Group;
import org.gatein.api.security.User;
import org.gatein.api.site.SiteId;

public class PageId
implements Formattable,
Serializable {
    private final SiteId siteId;
    private final String pageName;

    public PageId(String siteName, String pageName) {
        this(new SiteId(siteName), pageName);
    }

    public PageId(Group group, String pageName) {
        this(new SiteId(group), pageName);
    }

    public PageId(User user, String pageName) {
        this(new SiteId(user), pageName);
    }

    public PageId(SiteId siteId, String pageName) {
        this.siteId = Parameters.requireNonNull(siteId, "siteId");
        this.pageName = Parameters.requireNonNull(pageName, "pageName");
    }

    public SiteId getSiteId() {
        return this.siteId;
    }

    public String getPageName() {
        return this.pageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageId id = (PageId)o;
        return this.pageName.equals(id.pageName) && this.siteId.equals(id.siteId);
    }

    public int hashCode() {
        int result = this.siteId.hashCode();
        result = 31 * result + this.pageName.hashCode();
        return result;
    }

    public String toString() {
        return String.format("Page.Id[%s]", this);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if ((flags & 4) == 4) {
            formatter.format("%#s.%s", this.siteId, this.pageName);
        } else {
            formatter.format("siteId=[%s], pageName=%s", this.siteId, this.pageName);
        }
    }

    public static PageId fromString(String idAsString) {
        String pageName;
        int end;
        int start;
        int len;
        Parameters.requireNonNull(idAsString, "idAsString");
        if (idAsString.startsWith("Page.Id[")) {
            idAsString = idAsString.substring(8, idAsString.length());
            len = idAsString.length() - 1;
        } else {
            len = idAsString.length();
        }
        if (idAsString.startsWith("siteId=[")) {
            start = 8;
            end = idAsString.lastIndexOf("], pageName=");
            pageName = idAsString.substring(end + 12, len);
        } else {
            start = 0;
            end = idAsString.lastIndexOf(46);
            pageName = idAsString.substring(end + 1, len);
        }
        SiteId siteId = SiteId.fromString(idAsString.substring(start, end));
        return new PageId(siteId, pageName);
    }
}

