/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.appcenter.entity;

import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.appcenter.entity.FavoriteApplicationEntity;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="ApplicationEntity")
@ExoEntity
@Table(name="AC_APPLICATION")
@NamedQueries(value={@NamedQuery(name="ApplicationEntity.getAppByTitleOrUrl", query="SELECT app FROM ApplicationEntity app WHERE app.title = :title OR app.url = :url"), @NamedQuery(name="ApplicationEntity.getApplicationsByKeyword", query="SELECT app FROM ApplicationEntity app WHERE app.title like :title OR app.url like :url"), @NamedQuery(name="ApplicationEntity.getApplications", query="SELECT app FROM ApplicationEntity app"), @NamedQuery(name="ApplicationEntity.getSystemApplications", query="SELECT app FROM ApplicationEntity app WHERE app.system = TRUE"), @NamedQuery(name="ApplicationEntity.getFavoriteActiveApps", query="SELECT distinct(app) FROM ApplicationEntity app  LEFT JOIN app.favorites as favoriteApp  WHERE app.active = TRUE AND (app.byDefault = TRUE OR favoriteApp.userName = :userName)")})
public class ApplicationEntity {
    @Id
    @SequenceGenerator(name="SEQ_APPLICATION_ID", sequenceName="SEQ_APPLICATION_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_APPLICATION_ID")
    @Column(name="ID")
    private Long id;
    @Column(name="TITLE")
    private String title;
    @Column(name="URL")
    private String url;
    @Column(name="IMAGE_FILE_ID")
    private Long imageFileId;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="ACTIVE")
    private boolean active;
    @Column(name="BY_DEFAULT")
    private boolean byDefault;
    @Column(name="IS_SYSTEM")
    private Boolean system;
    @Column(name="PERMISSIONS")
    private String permissions;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="application", cascade={CascadeType.REMOVE})
    private Collection<FavoriteApplicationEntity> favorites;

    public ApplicationEntity() {
    }

    public ApplicationEntity(Long id, String title, String url, Long imageFileId, String description, boolean active, boolean byDefault, String permissions) {
        this.id = id;
        this.title = title;
        this.url = url;
        this.imageFileId = imageFileId;
        this.description = description;
        this.active = active;
        this.byDefault = byDefault;
        this.permissions = permissions;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Long getImageFileId() {
        return this.imageFileId;
    }

    public void setImageFileId(Long imageFileId) {
        this.imageFileId = imageFileId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isByDefault() {
        return this.byDefault;
    }

    public void setByDefault(boolean byDefault) {
        this.byDefault = byDefault;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public boolean isSystem() {
        return this.system != null && this.system != false;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }
}

