/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.TimeUnit;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.inboundhandler.BaseBlockingRunnable;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;

public class DefaultTopologyRunnable
extends BaseBlockingRunnable {
    private final TopologyMode topologyMode;
    private final int commandTopologyId;

    public DefaultTopologyRunnable(BasePerCacheInboundInvocationHandler handler, CacheRpcCommand command, Reply reply, TopologyMode topologyMode, int commandTopologyId) {
        super(handler, command, reply);
        this.topologyMode = topologyMode;
        this.commandTopologyId = commandTopologyId;
    }

    @Override
    public boolean isReady() {
        switch (this.topologyMode) {
            case READY_TOPOLOGY: {
                return this.handler.getStateTransferLock().topologyReceived(this.waitTopology());
            }
            case READY_TX_DATA: {
                return this.handler.getStateTransferLock().transactionDataReceived(this.waitTopology());
            }
        }
        return true;
    }

    @Override
    protected Response beforeInvoke() throws Exception {
        switch (this.topologyMode) {
            case WAIT_TOPOLOGY: {
                this.handler.getStateTransferLock().waitForTopology(this.waitTopology(), 1L, TimeUnit.DAYS);
                break;
            }
            case WAIT_TX_DATA: {
                this.handler.getStateTransferLock().waitForTransactionData(this.waitTopology(), 1L, TimeUnit.DAYS);
                break;
            }
        }
        if (this.handler.isCommandSentBeforeFirstTopology(this.commandTopologyId)) {
            return CacheNotFoundResponse.INSTANCE;
        }
        return super.beforeInvoke();
    }

    private int waitTopology() {
        return Math.max(this.commandTopologyId, 0);
    }
}

