/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.ResourceBundleService;

public class LocaleConfigImpl
implements LocaleConfig {
    private static Map<String, Locale> predefinedLocaleMap_ = null;
    private Locale locale_;
    private String outputEncoding_;
    private String inputEncoding_;
    private String description_;
    private String localeName_;
    private String tagIdentifier_;
    private Orientation orientation;

    @Override
    public String getDescription() {
        return this.description_;
    }

    @Override
    public void setDescription(String desc) {
        this.description_ = desc;
    }

    @Override
    public String getOutputEncoding() {
        return this.outputEncoding_;
    }

    @Override
    public void setOutputEncoding(String enc) {
        this.outputEncoding_ = enc;
    }

    @Override
    public String getInputEncoding() {
        return this.inputEncoding_;
    }

    @Override
    public void setInputEncoding(String enc) {
        this.inputEncoding_ = enc;
    }

    @Override
    public Locale getLocale() {
        return this.locale_;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale_ = locale;
        if (this.localeName_ == null) {
            this.localeName_ = locale.getLanguage();
        }
    }

    @Override
    public void setLocale(String localeName) {
        this.localeName_ = localeName;
        this.locale_ = predefinedLocaleMap_.get(localeName);
        if (this.locale_ == null) {
            String[] localeParams = localeName.split("_");
            this.locale_ = localeParams.length > 1 ? new Locale(localeParams[0], localeParams[1]) : new Locale(localeName);
            this.tagIdentifier_ = I18N.toTagIdentifier((Locale)this.locale_);
        }
    }

    @Override
    public String getTagIdentifier() {
        return this.tagIdentifier_;
    }

    @Override
    public String getLanguage() {
        return this.locale_.getLanguage();
    }

    @Override
    public String getLocaleName() {
        return this.localeName_;
    }

    public void setLocaleName(String localeName) {
        this.localeName_ = localeName;
    }

    @Override
    public ResourceBundle getResourceBundle(String name) {
        ResourceBundleService service = (ResourceBundleService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle(name, this.locale_);
        return res;
    }

    @Override
    public ResourceBundle getMergeResourceBundle(String[] names) {
        ResourceBundleService service = (ResourceBundleService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle(names, this.locale_);
        return res;
    }

    @Override
    public ResourceBundle getNavigationResourceBundle(String ownerType, String ownerId) {
        return this.getResourceBundle("locale.navigation." + ownerType + "." + ownerId.replaceAll("/", "."));
    }

    @Override
    public void setInput(HttpServletRequest req) throws UnsupportedEncodingException {
        req.setCharacterEncoding(this.inputEncoding_);
    }

    @Override
    public void setOutput(HttpServletResponse res) {
        res.setContentType("text/html; charset=" + this.outputEncoding_);
        res.setLocale(this.locale_);
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public String toString() {
        return "LocaleConfig[localeName=" + this.localeName_ + ",locale=" + this.locale_ + ",description=" + this.description_ + ",inputEncoding=" + this.inputEncoding_ + ",outputEncoding=" + this.outputEncoding_ + "]";
    }

    static {
        predefinedLocaleMap_ = new HashMap<String, Locale>(10);
        predefinedLocaleMap_.put("us", Locale.US);
        predefinedLocaleMap_.put("en", Locale.ENGLISH);
        predefinedLocaleMap_.put("fr", Locale.FRENCH);
        predefinedLocaleMap_.put("zh", Locale.SIMPLIFIED_CHINESE);
    }
}

