/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.storage;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.wallet.dao.WalletTransactionDAO;
import org.exoplatform.wallet.entity.TransactionEntity;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.utils.WalletUtils;

public class TransactionStorage {
    private WalletTransactionDAO walletTransactionDAO;

    public TransactionStorage(WalletTransactionDAO walletTransactionDAO) {
        this.walletTransactionDAO = walletTransactionDAO;
    }

    public List<TransactionDetail> getPendingTransaction(long networkId) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getPendingTransactions(networkId);
        return this.fromEntities(transactions);
    }

    public List<TransactionDetail> getTransactionsToSend(long networkId) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getTransactionsToSend(networkId);
        return this.fromEntities(transactions);
    }

    public long getMaxUsedNonce(long networkId, String fromAddress) {
        return this.walletTransactionDAO.getMaxUsedNonce(networkId, fromAddress);
    }

    public List<TransactionDetail> getContractTransactions(String contractAddress, String contractMethodName, int limit) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getContractTransactions(StringUtils.lowerCase((String)contractAddress), contractMethodName, limit);
        return this.fromEntities(transactions);
    }

    public List<TransactionDetail> getTransactions(long networkId, int limit) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getTransactions(networkId, limit);
        return this.fromEntities(transactions);
    }

    public List<TransactionDetail> getWalletTransactions(long networkId, String address, String contractAddress, String contractMethodName, String hash, int limit, boolean pending, boolean administration) {
        boolean limitNotReached;
        List<TransactionEntity> transactions = this.walletTransactionDAO.getWalletTransactions(networkId, address = StringUtils.lowerCase((String)address), contractAddress, contractMethodName, limit, pending, administration);
        boolean bl = limitNotReached = transactions != null && transactions.size() == limit;
        if (StringUtils.isNotBlank((CharSequence)hash) && limitNotReached && transactions.stream().noneMatch(transaction -> StringUtils.equalsIgnoreCase((CharSequence)transaction.getHash(), (CharSequence)hash))) {
            return this.getWalletTransactions(networkId, address, contractAddress, contractMethodName, hash, limit * 2, pending, administration);
        }
        return this.fromEntities(transactions);
    }

    public void saveTransactionDetail(TransactionDetail transactionDetail) {
        TransactionEntity transactionEntity;
        if (transactionDetail.getTimestamp() <= 0L) {
            transactionDetail.setTimestamp(System.currentTimeMillis());
        }
        if (transactionDetail.getSentTimestamp() <= 0L && StringUtils.isBlank((CharSequence)transactionDetail.getRawTransaction())) {
            transactionDetail.setSentTimestamp(transactionDetail.getTimestamp());
        }
        if ((transactionEntity = this.toEntity(transactionDetail)).getId() == 0L) {
            transactionEntity = (TransactionEntity)this.walletTransactionDAO.create(transactionEntity);
            transactionDetail.setId(transactionEntity.getId());
        } else {
            this.walletTransactionDAO.update(transactionEntity);
        }
    }

    public TransactionDetail getTransactionByHash(String hash) {
        hash = WalletUtils.formatTransactionHash((String)hash);
        TransactionEntity transactionEntity = this.walletTransactionDAO.getTransactionByHash(hash);
        return this.fromEntity(transactionEntity);
    }

    public long countPendingTransactionSent(long networkId, String fromAddress) {
        return this.walletTransactionDAO.countPendingTransactionSent(networkId, fromAddress);
    }

    public long countPendingTransactionAsSender(long networkId, String fromAddress) {
        return this.walletTransactionDAO.countPendingTransactionAsSender(networkId, fromAddress);
    }

    public double countReceivedContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        return this.walletTransactionDAO.countReceivedContractAmount(contractAddress, address, startDate, endDate);
    }

    public double countSentContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        return this.walletTransactionDAO.countSentContractAmount(contractAddress, address, startDate, endDate);
    }

    private List<TransactionDetail> fromEntities(List<TransactionEntity> transactions) {
        return transactions == null ? Collections.emptyList() : transactions.stream().map(this::fromEntity).collect(Collectors.toList());
    }

    private TransactionDetail fromEntity(TransactionEntity entity) {
        if (entity == null) {
            return null;
        }
        TransactionDetail detail = new TransactionDetail();
        detail.setId(entity.getId());
        detail.setAdminOperation(entity.isAdminOperation());
        detail.setContractAddress(entity.getContractAddress());
        detail.setContractAmount(entity.getContractAmount());
        detail.setContractMethodName(entity.getContractMethodName());
        detail.setTimestamp(entity.getCreatedDate());
        detail.setValue(entity.getValue());
        detail.setIssuerId(entity.getIssuerIdentityId());
        detail.setHash(entity.getHash());
        detail.setFrom(entity.getFromAddress());
        detail.setTo(entity.getToAddress());
        detail.setBy(entity.getByAddress());
        detail.setLabel(entity.getLabel());
        detail.setMessage(entity.getMessage());
        detail.setNetworkId(entity.getNetworkId());
        detail.setPending(entity.isPending());
        detail.setSucceeded(entity.isSuccess());
        detail.setGasPrice(entity.getGasPrice());
        detail.setGasUsed(entity.getGasUsed());
        detail.setTokenFee(entity.getTokenFee());
        detail.setEtherFee(entity.getEtherFee());
        detail.setNoContractFunds(entity.isNoContractFunds());
        detail.setNonce(entity.getNonce());
        detail.setSentTimestamp(entity.getSentDate());
        detail.setSendingAttemptCount(entity.getSendingAttemptCount());
        detail.setRawTransaction(entity.getRawTransaction());
        return detail;
    }

    private TransactionEntity toEntity(TransactionDetail detail) {
        TransactionEntity entity = new TransactionEntity();
        if (detail.getId() > 0L) {
            entity.setId(detail.getId());
        }
        entity.setNetworkId(detail.getNetworkId());
        entity.setHash(WalletUtils.formatTransactionHash((String)detail.getHash()));
        entity.setFromAddress(StringUtils.lowerCase((String)detail.getFrom()));
        entity.setToAddress(StringUtils.lowerCase((String)detail.getTo()));
        entity.setByAddress(StringUtils.lowerCase((String)detail.getBy()));
        entity.setContractAddress(StringUtils.lowerCase((String)detail.getContractAddress()));
        entity.setContractAmount(detail.getContractAmount());
        entity.setContractMethodName(detail.getContractMethodName());
        entity.setAdminOperation(detail.isAdminOperation());
        entity.setLabel(detail.getLabel());
        entity.setMessage(detail.getMessage());
        entity.setPending(detail.isPending());
        entity.setSuccess(detail.isSucceeded());
        entity.setValue(detail.getValue());
        entity.setGasPrice(detail.getGasPrice());
        entity.setTokenFee(detail.getTokenFee());
        entity.setEtherFee(detail.getEtherFee());
        entity.setGasUsed(detail.getGasUsed());
        entity.setNoContractFunds(detail.isNoContractFunds());
        entity.setNonce(detail.getNonce());
        entity.setSentDate(detail.getSentTimestamp());
        entity.setSendingAttemptCount(detail.getSendingAttemptCount());
        entity.setRawTransaction(detail.getRawTransaction());
        if (detail.getTimestamp() == 0L) {
            entity.setCreatedDate(System.currentTimeMillis());
        }
        entity.setCreatedDate(detail.getTimestamp());
        if (detail.getIssuer() != null) {
            entity.setIssuerIdentityId(detail.getIssuer().getTechnicalId());
        } else if (detail.getIssuerId() > 0L) {
            entity.setIssuerIdentityId(detail.getIssuerId());
        }
        return entity;
    }
}

